/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.TaxPayerIdTransferMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestTaxIdTransfer;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public interface TaxPayerIdTransferMethod
extends PayoutMethod {
    public static final PayoutMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayoutMethod.PaymentMethodCode.TAXPAYER_ID_TRANSFER;

    @NotNull
    public String getTaxId();

    @NotNull
    public Optional<AccountPayoutRequestTaxIdTransfer> getAccount();

    @NotNull
    public static Builder builder(TaxPayerIdTransferMethod copyOf) {
        Builder builder = TaxPayerIdTransferMethod.builder();
        builder.taxId(copyOf.getTaxId());
        builder.account(copyOf.getAccount().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new TaxPayerIdTransferMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder taxId(String var1);

        public boolean isTaxIdDefined();

        @NotNull
        public Builder account(AccountPayoutRequestTaxIdTransfer var1);

        public boolean isAccountDefined();

        @NotNull
        public TaxPayerIdTransferMethod build();
    }
}

