/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.SettlementCryptoTransferMethodImpl;
import tech.carpentum.sdk.payment.model.AccountSettlementRequestCryptoTransfer;
import tech.carpentum.sdk.payment.model.SettlementMethod;

@JsonClass(generateAdapter=false)
public interface SettlementCryptoTransferMethod
extends SettlementMethod {
    public static final SettlementMethod.PaymentMethodCode PAYMENT_METHOD_CODE = SettlementMethod.PaymentMethodCode.CRYPTO_TRANSFER;

    @NotNull
    public AccountSettlementRequestCryptoTransfer getAccount();

    @NotNull
    public String getPaymentOperatorCode();

    @NotNull
    public Optional<String> getTransactionReference();

    @NotNull
    public static Builder builder(SettlementCryptoTransferMethod copyOf) {
        Builder builder = SettlementCryptoTransferMethod.builder();
        builder.account(copyOf.getAccount());
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode());
        builder.transactionReference(copyOf.getTransactionReference().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new SettlementCryptoTransferMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountSettlementRequestCryptoTransfer var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder paymentOperatorCode(String var1);

        public boolean isPaymentOperatorCodeDefined();

        @NotNull
        public Builder transactionReference(String var1);

        public boolean isTransactionReferenceDefined();

        @NotNull
        public SettlementCryptoTransferMethod build();
    }
}

