/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.CustomerNetworkAddressImpl;

@JsonClass(generateAdapter=false)
public interface CustomerNetworkAddress {
    public static final String NETWORK_TYPE_ETHEREUM = "ethereum";
    public static final String NETWORK_TYPE_TRON = "tron";

    @NotNull
    public String getNetworkType();

    @NotNull
    public String getNetworkAddress();

    @NotNull
    public String getQrCode();

    @NotNull
    public static Builder builder(CustomerNetworkAddress copyOf) {
        Builder builder = CustomerNetworkAddress.builder();
        builder.networkType(copyOf.getNetworkType());
        builder.networkAddress(copyOf.getNetworkAddress());
        builder.qrCode(copyOf.getQrCode());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new CustomerNetworkAddressImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder networkType(String var1);

        public boolean isNetworkTypeDefined();

        @NotNull
        public Builder networkAddress(String var1);

        public boolean isNetworkAddressDefined();

        @NotNull
        public Builder qrCode(String var1);

        public boolean isQrCodeDefined();

        @NotNull
        public CustomerNetworkAddress build();
    }
}

