/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestPhoneNumberTransfer;
import tech.carpentum.sdk.payment.model.IdentifyingReference;
import tech.carpentum.sdk.payment.model.PayoutMethod;
import tech.carpentum.sdk.payment.model.PhoneNumberTransferMethod;

@JsonClass(generateAdapter=false)
public class PhoneNumberTransferMethodImpl
implements PhoneNumberTransferMethod {
    private final String phoneNumber;
    private final Optional<AccountPayoutRequestPhoneNumberTransfer> account;
    private final IdentifyingReference identifyingReference;
    private final int hashCode;
    private final String toString;

    @Override
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public Optional<AccountPayoutRequestPhoneNumberTransfer> getAccount() {
        return this.account;
    }

    @Override
    public IdentifyingReference getIdentifyingReference() {
        return this.identifyingReference;
    }

    @Override
    public PayoutMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private PhoneNumberTransferMethodImpl(BuilderImpl builder) {
        this.phoneNumber = Objects.requireNonNull(builder.phoneNumber, "Property 'phoneNumber' is required.");
        this.account = Optional.ofNullable(builder.account);
        this.identifyingReference = Objects.requireNonNull(builder.identifyingReference, "Property 'identifyingReference' is required.");
        this.hashCode = Objects.hash(this.phoneNumber, this.account, this.identifyingReference);
        this.toString = builder.type + "(phoneNumber=" + this.phoneNumber + ", account=" + this.account + ", identifyingReference=" + this.identifyingReference + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberTransferMethodImpl)) {
            return false;
        }
        PhoneNumberTransferMethodImpl that = (PhoneNumberTransferMethodImpl)obj;
        if (!Objects.equals(this.phoneNumber, that.phoneNumber)) {
            return false;
        }
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        return Objects.equals(this.identifyingReference, that.identifyingReference);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PhoneNumberTransferMethod.Builder {
        private String phoneNumber = null;
        private AccountPayoutRequestPhoneNumberTransfer account = null;
        private IdentifyingReference identifyingReference = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PhoneNumberTransferMethod");
        }

        @Override
        public BuilderImpl phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public boolean isPhoneNumberDefined() {
            return this.phoneNumber != null;
        }

        @Override
        public BuilderImpl account(AccountPayoutRequestPhoneNumberTransfer account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl identifyingReference(IdentifyingReference identifyingReference) {
            this.identifyingReference = identifyingReference;
            return this;
        }

        @Override
        public boolean isIdentifyingReferenceDefined() {
            return this.identifyingReference != null;
        }

        @Override
        public PhoneNumberTransferMethodImpl build() {
            return new PhoneNumberTransferMethodImpl(this);
        }
    }
}

