/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import tech.carpentum.sdk.payment.model.AccountPayinRequestFpx;
import tech.carpentum.sdk.payment.model.FpxMethod;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class FpxMethodImpl
implements FpxMethod {
    private final AccountPayinRequestFpx account;
    private final String paymentOperatorCode;
    private final int hashCode;
    private final String toString;

    @Override
    public AccountPayinRequestFpx getAccount() {
        return this.account;
    }

    @Override
    public String getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private FpxMethodImpl(BuilderImpl builder) {
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.paymentOperatorCode = Objects.requireNonNull(builder.paymentOperatorCode, "Property 'paymentOperatorCode' is required.");
        this.hashCode = Objects.hash(this.account, this.paymentOperatorCode);
        this.toString = builder.type + "(account=" + this.account + ", paymentOperatorCode=" + this.paymentOperatorCode + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FpxMethodImpl)) {
            return false;
        }
        FpxMethodImpl that = (FpxMethodImpl)obj;
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        return Objects.equals(this.paymentOperatorCode, that.paymentOperatorCode);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements FpxMethod.Builder {
        private AccountPayinRequestFpx account = null;
        private String paymentOperatorCode = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("FpxMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestFpx account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public boolean isPaymentOperatorCodeDefined() {
            return this.paymentOperatorCode != null;
        }

        @Override
        public FpxMethodImpl build() {
            return new FpxMethodImpl(this);
        }
    }
}

