/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.ExternalProvider;
import tech.carpentum.sdk.payment.model.ExternalProviders;

@JsonClass(generateAdapter=false)
public class ExternalProvidersImpl
implements ExternalProviders {
    private final List<@NotNull ExternalProvider> providers;
    private final int hashCode;
    private final String toString;

    @Override
    public List<@NotNull ExternalProvider> getProviders() {
        return this.providers;
    }

    private ExternalProvidersImpl(BuilderImpl builder) {
        this.providers = Collections.unmodifiableList(builder.providers);
        this.hashCode = Objects.hash(this.providers);
        this.toString = builder.type + "(providers=" + this.providers + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalProvidersImpl)) {
            return false;
        }
        ExternalProvidersImpl that = (ExternalProvidersImpl)obj;
        return Objects.equals(this.providers, that.providers);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements ExternalProviders.Builder {
        private List<@NotNull ExternalProvider> providers = new ArrayList<ExternalProvider>();
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("ExternalProviders");
        }

        @Override
        public BuilderImpl providers(List<@NotNull ExternalProvider> providers) {
            this.providers.clear();
            if (providers != null) {
                this.providers.addAll(providers);
            }
            return this;
        }

        @Override
        public BuilderImpl providersAdd(ExternalProvider item) {
            if (item != null) {
                this.providers.add(item);
            }
            return this;
        }

        @Override
        public BuilderImpl providersAddAll(List<@NotNull ExternalProvider> providers) {
            if (providers != null) {
                this.providers.addAll(providers);
            }
            return this;
        }

        @Override
        public ExternalProvidersImpl build() {
            return new ExternalProvidersImpl(this);
        }
    }
}

