/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.ForexRateImpl;
import tech.carpentum.sdk.payment.model.CurrencyCode;

@JsonClass(generateAdapter=false)
public interface ForexRate {
    @NotNull
    public CurrencyCode getBaseCurrencyCode();

    @NotNull
    public CurrencyCode getQuoteCurrencyCode();

    @NotNull
    public Optional<BigDecimal> getBuyRate();

    @NotNull
    public Optional<BigDecimal> getSellRate();

    @NotNull
    public Optional<OffsetDateTime> getValidUpTo();

    @NotNull
    public static Builder builder(ForexRate copyOf) {
        Builder builder = ForexRate.builder();
        builder.baseCurrencyCode(copyOf.getBaseCurrencyCode());
        builder.quoteCurrencyCode(copyOf.getQuoteCurrencyCode());
        builder.buyRate(copyOf.getBuyRate().orElse(null));
        builder.sellRate(copyOf.getSellRate().orElse(null));
        builder.validUpTo(copyOf.getValidUpTo().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new ForexRateImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder baseCurrencyCode(CurrencyCode var1);

        public boolean isBaseCurrencyCodeDefined();

        @NotNull
        public Builder quoteCurrencyCode(CurrencyCode var1);

        public boolean isQuoteCurrencyCodeDefined();

        @NotNull
        public Builder buyRate(BigDecimal var1);

        public boolean isBuyRateDefined();

        @NotNull
        public Builder sellRate(BigDecimal var1);

        public boolean isSellRateDefined();

        @NotNull
        public Builder validUpTo(OffsetDateTime var1);

        public boolean isValidUpToDefined();

        @NotNull
        public ForexRate build();
    }
}

