/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.BankTransferMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestBankTransfer;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public interface BankTransferMethod
extends PayoutMethod {
    public static final PayoutMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayoutMethod.PaymentMethodCode.BANK_TRANSFER;

    @NotNull
    public AccountPayoutRequestBankTransfer getAccount();

    @NotNull
    public String getPaymentOperatorCode();

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public Optional<String> getRemark();

    @NotNull
    public static Builder builder(BankTransferMethod copyOf) {
        Builder builder = BankTransferMethod.builder();
        builder.account(copyOf.getAccount());
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode());
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        builder.remark(copyOf.getRemark().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new BankTransferMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayoutRequestBankTransfer var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder paymentOperatorCode(String var1);

        public boolean isPaymentOperatorCodeDefined();

        @NotNull
        public Builder emailAddress(String var1);

        public boolean isEmailAddressDefined();

        @NotNull
        public Builder remark(String var1);

        public boolean isRemarkDefined();

        @NotNull
        public BankTransferMethod build();
    }
}

