/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.PayinMethod;
import tech.carpentum.sdk.payment.model.UpiIdMethod;

@JsonClass(generateAdapter=false)
public class UpiIdMethodImpl
implements UpiIdMethod {
    private final String upiId;
    private final Optional<String> emailAddress;
    private final int hashCode;
    private final String toString;

    @Override
    public String getUpiId() {
        return this.upiId;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private UpiIdMethodImpl(BuilderImpl builder) {
        this.upiId = Objects.requireNonNull(builder.upiId, "Property 'upiId' is required.");
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.hashCode = Objects.hash(this.upiId, this.emailAddress);
        this.toString = builder.type + "(upiId=" + this.upiId + ", emailAddress=" + this.emailAddress + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpiIdMethodImpl)) {
            return false;
        }
        UpiIdMethodImpl that = (UpiIdMethodImpl)obj;
        if (!Objects.equals(this.upiId, that.upiId)) {
            return false;
        }
        return Objects.equals(this.emailAddress, that.emailAddress);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements UpiIdMethod.Builder {
        private String upiId = null;
        private String emailAddress = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("UpiIdMethod");
        }

        @Override
        public BuilderImpl upiId(String upiId) {
            this.upiId = upiId;
            return this;
        }

        @Override
        public boolean isUpiIdDefined() {
            return this.upiId != null;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public boolean isEmailAddressDefined() {
            return this.emailAddress != null;
        }

        @Override
        public UpiIdMethodImpl build() {
            return new UpiIdMethodImpl(this);
        }
    }
}

