/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.P2AV2MethodResponseImpl;
import tech.carpentum.sdk.payment.model.AccountResponseP2AV2;
import tech.carpentum.sdk.payment.model.ExternalReference;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.MoneyPaymentResponse;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentAddress;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public interface P2AV2MethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.P2A_V2;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public IdPayment getIdPayment();

    @NotNull
    public AccountResponseP2AV2 getAccount();

    @NotNull
    public MoneyPaymentResponse getMoney();

    @NotNull
    public Optional<MoneyVat> getVat();

    @NotNull
    public String getMerchantName();

    @NotNull
    public PaymentAddress getPaymentAddress();

    @NotNull
    public String getQrName();

    @NotNull
    public String getQrCode();

    @NotNull
    public String getReference();

    @NotNull
    public Optional<ExternalReference> getExternalReference();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public PaymentOperatorIncoming getPaymentOperator();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    @NotNull
    public static Builder builder(P2AV2MethodResponse copyOf) {
        Builder builder = P2AV2MethodResponse.builder();
        builder.idPayin(copyOf.getIdPayin());
        builder.idPayment(copyOf.getIdPayment());
        builder.account(copyOf.getAccount());
        builder.money(copyOf.getMoney());
        builder.vat(copyOf.getVat().orElse(null));
        builder.merchantName(copyOf.getMerchantName());
        builder.paymentAddress(copyOf.getPaymentAddress());
        builder.qrName(copyOf.getQrName());
        builder.qrCode(copyOf.getQrCode());
        builder.reference(copyOf.getReference());
        builder.externalReference(copyOf.getExternalReference().orElse(null));
        builder.returnUrl(copyOf.getReturnUrl());
        builder.paymentOperator(copyOf.getPaymentOperator());
        builder.acceptedAt(copyOf.getAcceptedAt());
        builder.expireAt(copyOf.getExpireAt());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new P2AV2MethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder idPayin(IdPayin var1);

        public boolean isIdPayinDefined();

        @NotNull
        public Builder idPayment(IdPayment var1);

        public boolean isIdPaymentDefined();

        @NotNull
        public Builder account(AccountResponseP2AV2 var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder money(MoneyPaymentResponse var1);

        public boolean isMoneyDefined();

        @NotNull
        public Builder vat(MoneyVat var1);

        public boolean isVatDefined();

        @NotNull
        public Builder merchantName(String var1);

        public boolean isMerchantNameDefined();

        @NotNull
        public Builder paymentAddress(PaymentAddress var1);

        public boolean isPaymentAddressDefined();

        @NotNull
        public Builder qrName(String var1);

        public boolean isQrNameDefined();

        @NotNull
        public Builder qrCode(String var1);

        public boolean isQrCodeDefined();

        @NotNull
        public Builder reference(String var1);

        public boolean isReferenceDefined();

        @NotNull
        public Builder externalReference(ExternalReference var1);

        public boolean isExternalReferenceDefined();

        @NotNull
        public Builder returnUrl(String var1);

        public boolean isReturnUrlDefined();

        @NotNull
        public Builder paymentOperator(PaymentOperatorIncoming var1);

        public boolean isPaymentOperatorDefined();

        @NotNull
        public Builder acceptedAt(OffsetDateTime var1);

        public boolean isAcceptedAtDefined();

        @NotNull
        public Builder expireAt(OffsetDateTime var1);

        public boolean isExpireAtDefined();

        @NotNull
        public P2AV2MethodResponse build();
    }
}

