/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.ToJson;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.TopUpRequestedJson;
import tech.carpentum.sdk.payment.model.TopUpRequested;
import tech.carpentum.sdk.payment.model.TopUpRequestedMoneyProvided;
import tech.carpentum.sdk.payment.model.TopUpRequestedMoneyRequired;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0007\u00a8\u0006\n"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/model/TopUpRequestedJsonAdapter;", "", "<init>", "()V", "fromJson", "Ltech/carpentum/sdk/payment/model/TopUpRequested;", "json", "Ltech/carpentum/sdk/payment/internal/generated/model/TopUpRequestedJson;", "toJson", "model", "payment-client-v2"})
public final class TopUpRequestedJsonAdapter {
    @FromJson
    @NotNull
    public final TopUpRequested fromJson(@NotNull TopUpRequestedJson json) {
        TopUpRequested topUpRequested;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (json.getMoneyProvided() != null) {
            TopUpRequestedMoneyProvided.Builder builder = TopUpRequestedMoneyProvided.builder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            TopUpRequestedMoneyProvided.Builder builder2 = builder;
            builder2.moneyProvided(json.getMoneyProvided());
            builder2.currencyRequired(json.getCurrencyRequired());
            TopUpRequestedMoneyProvided topUpRequestedMoneyProvided = builder2.build();
            Intrinsics.checkNotNull((Object)topUpRequestedMoneyProvided);
            topUpRequested = topUpRequestedMoneyProvided;
        } else if (json.getMoneyRequired() != null) {
            TopUpRequestedMoneyRequired.Builder builder = TopUpRequestedMoneyRequired.builder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            TopUpRequestedMoneyRequired.Builder builder3 = builder;
            builder3.moneyRequired(json.getMoneyRequired());
            builder3.currencyProvided(json.getCurrencyProvided());
            TopUpRequestedMoneyRequired topUpRequestedMoneyRequired = builder3.build();
            Intrinsics.checkNotNull((Object)topUpRequestedMoneyRequired);
            topUpRequested = topUpRequestedMoneyRequired;
        } else {
            throw new JsonDataException("Missing required attributes: [moneyProvided] or [moneyRequired].");
        }
        return topUpRequested;
    }

    @ToJson
    @NotNull
    public final TopUpRequestedJson toJson(@NotNull TopUpRequested model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        TopUpRequestedJson json = new TopUpRequestedJson();
        TopUpRequested topUpRequested = model;
        if (topUpRequested instanceof TopUpRequestedMoneyProvided) {
            json.setMoneyProvided(((TopUpRequestedMoneyProvided)model).getMoneyProvided());
            json.setCurrencyRequired(((TopUpRequestedMoneyProvided)model).getCurrencyRequired().orElse(null));
        } else if (topUpRequested instanceof TopUpRequestedMoneyRequired) {
            json.setMoneyRequired(((TopUpRequestedMoneyRequired)model).getMoneyRequired());
            json.setCurrencyProvided(((TopUpRequestedMoneyRequired)model).getCurrencyProvided().orElse(null));
        } else {
            throw new JsonDataException("Unsupported type [" + model.getClass().getName() + "] of model.");
        }
        return json;
    }
}

