/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.api;

import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiClient;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiClientKt;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiResponse;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientException;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Informational;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Redirection;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.RequestConfig;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.RequestMethod;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ResponseExtensionsKt;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ResponseType;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Serializer;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerException;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Success;
import tech.carpentum.sdk.payment.model.BalanceList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003J \u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000e2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0002\u00a8\u0006\u0015"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/api/AccountsApi;", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient;", "basePath", "", "client", "Lokhttp3/OkHttpClient;", "<init>", "(Ljava/lang/String;Lokhttp3/OkHttpClient;)V", "getBalances", "Ltech/carpentum/sdk/payment/model/BalanceList;", "xAPIVersion", "", "currencyCodes", "getBalancesWithHttpInfo", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiResponse;", "getBalancesRequestConfig", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/RequestConfig;", "", "encodeURIComponent", "uriComponent", "Companion", "payment-client-v2"})
@SourceDebugExtension(value={"SMAP\nAccountsApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountsApi.kt\ntech/carpentum/sdk/payment/internal/generated/api/AccountsApi\n+ 2 ApiClient.kt\ntech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n162#2,9:135\n171#2:145\n172#2,2:147\n174#2:150\n175#2,24:152\n72#2,49:176\n199#2,3:225\n72#2,49:228\n202#2:277\n72#2,49:278\n203#2:327\n72#2,49:328\n204#2,23:377\n124#2,23:400\n148#2,2:424\n227#2,14:426\n216#3:144\n217#3:151\n1863#4:146\n1864#4:149\n29#5:423\n1#6:440\n*S KotlinDebug\n*F\n+ 1 AccountsApi.kt\ntech/carpentum/sdk/payment/internal/generated/api/AccountsApi\n*L\n96#1:135,9\n96#1:145\n96#1:147,2\n96#1:150\n96#1:152,24\n96#1:176,49\n96#1:225,3\n96#1:228,49\n96#1:277\n96#1:278,49\n96#1:327\n96#1:328,49\n96#1:377,23\n96#1:400,23\n96#1:424,2\n96#1:426,14\n96#1:144\n96#1:151\n96#1:146\n96#1:149\n96#1:423\n*E\n"})
public class AccountsApi
extends ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<String> defaultBasePath$delegate = LazyKt.lazy(AccountsApi::defaultBasePath_delegate$lambda$2);

    public AccountsApi(@NotNull String basePath, @NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(basePath, client);
    }

    public /* synthetic */ AccountsApi(String string, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = Companion.getDefaultBasePath();
        }
        if ((n & 2) != 0) {
            okHttpClient = ApiClient.Companion.getDefaultClient();
        }
        this(string, okHttpClient);
    }

    @NotNull
    public final BalanceList getBalances(int xAPIVersion, @Nullable String currencyCodes) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiResponse<BalanceList> localVarResponse = this.getBalancesWithHttpInfo(xAPIVersion, currencyCodes);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.Success<*>");
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.model.BalanceList");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException("Client error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException("Server error : " + n + " " + string + " " + localVarError.getBody(), localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (BalanceList)t;
    }

    public static /* synthetic */ BalanceList getBalances$default(AccountsApi accountsApi, int n, String string, int n2, Object object) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getBalances");
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        return accountsApi.getBalances(n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ApiResponse<BalanceList> getBalancesWithHttpInfo(int xAPIVersion, @Nullable String currencyCodes) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Object object;
        String string2;
        Map<String, String> headers$iv;
        Unit element$iv$iv;
        RequestConfig<Unit> localVariableConfig = this.getBalancesRequestConfig(xAPIVersion, currencyCodes);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object2 = new char[]{'/'};
        Object $this$request_u24lambda_u249$iv = object2 = (Object)httpUrl$iv.newBuilder().addEncodedPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object2));
        boolean bl42 = false;
        Request.Builder $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach = false;
        Object object3 = $this$forEach$iv$iv.entrySet().iterator();
        while (object3.hasNext()) {
            Unit query$iv = element$iv$iv = object3.next();
            boolean bl2 = false;
            Iterable iterable = query$iv.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : iterable) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl3 = false;
                $this$request_u24lambda_u249$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object2.build();
        if (localVariableConfig.getBody() != null && ((object2 = (Object)localVariableConfig.getHeaders().get("Content-Type")) == null || object2.length() == 0)) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object2 = (Object)localVariableConfig.getHeaders().get("Accept")) == null || object2.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u249$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Accept")) == null || $this$request_u24lambda_u249$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        if (headers$iv.get("Content-Type") != null) {
            String string3 = headers$iv.get("Content-Type");
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type kotlin.String");
            String bl42 = StringsKt.substringBefore$default((String)string3, (String)";", null, (int)2, null);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string4 = bl42.toLowerCase(locale);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string2 = null;
        }
        String contentType$iv = string2;
        Request.Builder $this$request_u24lambda_u2411$iv = $this$forEach$iv$iv = (switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1 -> {
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv$iv;
                MediaType fileMediaType$iv$iv;
                Map partHeaders$iv$iv;
                PartConfig part$iv$iv;
                String name$iv$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv$iv;
                Map.Entry var25_88;
                Map $this$forEach$iv$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv$iv;
                RequestBody v7;
                ApiClient this_$iv$iv;
                Unit content$iv$iv;
                object3 = this_$iv;
                element$iv$iv = localVariableConfig.getBody();
                Request.Builder var24_87 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    File v5 = (File)content$iv$iv;
                    String v6 = contentType$iv;
                    if (v6 == null) {
                        v6 = ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)content$iv$iv);
                    }
                    v7 = RequestBody.Companion.create(v5, MediaType.Companion.parse(v6));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl2;
                    MultipartBody.Builder var16_38 = bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $i$a$-apply-ApiClient$requestBody$1$iv$iv = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach = false;
                    object = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (object.hasNext()) {
                        MultipartBody.Builder v8;
                        Map.Entry element$iv$iv$iv;
                        var25_88 = element$iv$iv$iv = object.next();
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv$iv = false;
                        name$iv$iv = (String)var25_88.getKey();
                        part$iv$iv = (PartConfig)var25_88.getValue();
                        if (part$iv$iv.getBody() instanceof File) {
                            partHeaders$iv$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv$iv + "\"; filename=\"" + ((File)part$iv$iv.getBody()).getName() + "\"")));
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)part$iv$iv.getBody()));
                            v8 = var16_38.addPart(Headers.Companion.of(partHeaders$iv$iv), RequestBody.Companion.create((File)part$iv$iv.getBody(), fileMediaType$iv$iv));
                            continue;
                        }
                        partHeaders$iv$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv$iv + "\"")));
                        v8 = var16_38.addPart(Headers.Companion.of(partHeaders$iv$iv), RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, part$iv$iv.getBody()), null));
                    }
                    v7 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl2;
                    FormBody.Builder var16_39 = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv$iv = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        var25_88 = element$iv$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv$iv = false;
                        name$iv$iv = (String)var25_88.getKey();
                        part$iv$iv = (PartConfig)var25_88.getValue();
                        var16_39.add(name$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, part$iv$iv.getBody()));
                    }
                    v7 = (RequestBody)bl2.build();
                } else if (contentType$iv == null || StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        v7 = ApiClientKt.getEMPTY_REQUEST();
                    } else {
                        String v9 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"toJson(...)");
                        String v10 = contentType$iv;
                        if (v10 == null) {
                            v10 = "application/json";
                        }
                        v7 = RequestBody.Companion.create(v9, MediaType.Companion.parse(v10));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/octet-stream") && content$iv$iv instanceof byte[]) {
                        v7 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((byte[])content$iv$iv), (MediaType)MediaType.Companion.parse("application/octet-stream"), (int)0, (int)0, (int)6, null);
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, byte body and File body.");
                    }
                }
                yield var24_87.delete(v7);
            }
            case 2 -> new Request.Builder().url(url$iv);
            case 3 -> new Request.Builder().url(url$iv).head();
            case 4 -> {
                RequestBody v14;
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv$iv;
                MediaType fileMediaType$iv$iv;
                Map partHeaders$iv$iv;
                PartConfig part$iv$iv;
                String name$iv$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv$iv;
                Map.Entry var25_88;
                Map $this$forEach$iv$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder var24_87 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    File v12 = (File)content$iv$iv;
                    String v13 = contentType$iv;
                    if (v13 == null) {
                        v13 = ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)content$iv$iv);
                    }
                    v14 = RequestBody.Companion.create(v12, MediaType.Companion.parse(v13));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl2;
                    MultipartBody.Builder var16_41 = bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $i$a$-apply-ApiClient$requestBody$1$iv$iv = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        MultipartBody.Builder v15;
                        var25_88 = element$iv$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv$iv = false;
                        name$iv$iv = (String)var25_88.getKey();
                        part$iv$iv = (PartConfig)var25_88.getValue();
                        if (part$iv$iv.getBody() instanceof File) {
                            partHeaders$iv$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv$iv + "\"; filename=\"" + ((File)part$iv$iv.getBody()).getName() + "\"")));
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)part$iv$iv.getBody()));
                            v15 = var16_41.addPart(Headers.Companion.of(partHeaders$iv$iv), RequestBody.Companion.create((File)part$iv$iv.getBody(), fileMediaType$iv$iv));
                            continue;
                        }
                        partHeaders$iv$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv$iv + "\"")));
                        v15 = var16_41.addPart(Headers.Companion.of(partHeaders$iv$iv), RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, part$iv$iv.getBody()), null));
                    }
                    v14 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl2;
                    FormBody.Builder var16_42 = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv$iv = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        var25_88 = element$iv$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv$iv = false;
                        name$iv$iv = (String)var25_88.getKey();
                        part$iv$iv = (PartConfig)var25_88.getValue();
                        var16_42.add(name$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, part$iv$iv.getBody()));
                    }
                    v14 = (RequestBody)bl2.build();
                } else if (contentType$iv == null || StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        v14 = ApiClientKt.getEMPTY_REQUEST();
                    } else {
                        String v16 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"toJson(...)");
                        String v17 = contentType$iv;
                        if (v17 == null) {
                            v17 = "application/json";
                        }
                        v14 = RequestBody.Companion.create(v16, MediaType.Companion.parse(v17));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/octet-stream") && content$iv$iv instanceof byte[]) {
                        v14 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((byte[])content$iv$iv), (MediaType)MediaType.Companion.parse("application/octet-stream"), (int)0, (int)0, (int)6, null);
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, byte body and File body.");
                    }
                }
                yield var24_87.patch(v14);
            }
            case 5 -> {
                RequestBody v20;
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv$iv;
                MediaType fileMediaType$iv$iv;
                Map partHeaders$iv$iv;
                PartConfig part$iv$iv;
                String name$iv$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv$iv;
                Map.Entry var25_88;
                Map $this$forEach$iv$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder var24_87 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    File v18 = (File)content$iv$iv;
                    String v19 = contentType$iv;
                    if (v19 == null) {
                        v19 = ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)content$iv$iv);
                    }
                    v20 = RequestBody.Companion.create(v18, MediaType.Companion.parse(v19));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl2;
                    MultipartBody.Builder var16_44 = bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $i$a$-apply-ApiClient$requestBody$1$iv$iv = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        MultipartBody.Builder v21;
                        var25_88 = element$iv$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv$iv = false;
                        name$iv$iv = (String)var25_88.getKey();
                        part$iv$iv = (PartConfig)var25_88.getValue();
                        if (part$iv$iv.getBody() instanceof File) {
                            partHeaders$iv$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv$iv + "\"; filename=\"" + ((File)part$iv$iv.getBody()).getName() + "\"")));
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)part$iv$iv.getBody()));
                            v21 = var16_44.addPart(Headers.Companion.of(partHeaders$iv$iv), RequestBody.Companion.create((File)part$iv$iv.getBody(), fileMediaType$iv$iv));
                            continue;
                        }
                        partHeaders$iv$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv$iv + "\"")));
                        v21 = var16_44.addPart(Headers.Companion.of(partHeaders$iv$iv), RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, part$iv$iv.getBody()), null));
                    }
                    v20 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl2;
                    FormBody.Builder var16_45 = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv$iv = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        var25_88 = element$iv$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv$iv = false;
                        name$iv$iv = (String)var25_88.getKey();
                        part$iv$iv = (PartConfig)var25_88.getValue();
                        var16_45.add(name$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, part$iv$iv.getBody()));
                    }
                    v20 = (RequestBody)bl2.build();
                } else if (contentType$iv == null || StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        v20 = ApiClientKt.getEMPTY_REQUEST();
                    } else {
                        String v22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"toJson(...)");
                        String v23 = contentType$iv;
                        if (v23 == null) {
                            v23 = "application/json";
                        }
                        v20 = RequestBody.Companion.create(v22, MediaType.Companion.parse(v23));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/octet-stream") && content$iv$iv instanceof byte[]) {
                        v20 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((byte[])content$iv$iv), (MediaType)MediaType.Companion.parse("application/octet-stream"), (int)0, (int)0, (int)6, null);
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, byte body and File body.");
                    }
                }
                yield var24_87.put(v20);
            }
            case 6 -> {
                RequestBody v26;
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv$iv;
                MediaType fileMediaType$iv$iv;
                Map partHeaders$iv$iv;
                PartConfig part$iv$iv;
                String name$iv$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv$iv;
                Map.Entry var25_88;
                Map $this$forEach$iv$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder var24_87 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    File v24 = (File)content$iv$iv;
                    String v25 = contentType$iv;
                    if (v25 == null) {
                        v25 = ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)content$iv$iv);
                    }
                    v26 = RequestBody.Companion.create(v24, MediaType.Companion.parse(v25));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl2;
                    MultipartBody.Builder var16_47 = bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $i$a$-apply-ApiClient$requestBody$1$iv$iv = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        MultipartBody.Builder v27;
                        var25_88 = element$iv$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv$iv = false;
                        name$iv$iv = (String)var25_88.getKey();
                        part$iv$iv = (PartConfig)var25_88.getValue();
                        if (part$iv$iv.getBody() instanceof File) {
                            partHeaders$iv$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv$iv + "\"; filename=\"" + ((File)part$iv$iv.getBody()).getName() + "\"")));
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)part$iv$iv.getBody()));
                            v27 = var16_47.addPart(Headers.Companion.of(partHeaders$iv$iv), RequestBody.Companion.create((File)part$iv$iv.getBody(), fileMediaType$iv$iv));
                            continue;
                        }
                        partHeaders$iv$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv$iv + "\"")));
                        v27 = var16_47.addPart(Headers.Companion.of(partHeaders$iv$iv), RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, part$iv$iv.getBody()), null));
                    }
                    v26 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl2;
                    FormBody.Builder var16_48 = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv$iv = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, tech.carpentum.sdk.payment.internal.generated.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        var25_88 = element$iv$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv$iv = false;
                        name$iv$iv = (String)var25_88.getKey();
                        part$iv$iv = (PartConfig)var25_88.getValue();
                        var16_48.add(name$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, part$iv$iv.getBody()));
                    }
                    v26 = (RequestBody)bl2.build();
                } else if (contentType$iv == null || StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        v26 = ApiClientKt.getEMPTY_REQUEST();
                    } else {
                        String v28 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v28, (String)"toJson(...)");
                        String v29 = contentType$iv;
                        if (v29 == null) {
                            v29 = "application/json";
                        }
                        v26 = RequestBody.Companion.create(v28, MediaType.Companion.parse(v29));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/octet-stream") && content$iv$iv instanceof byte[]) {
                        v26 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])((byte[])content$iv$iv), (MediaType)MediaType.Companion.parse("application/octet-stream"), (int)0, (int)0, (int)6, null);
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, byte body and File body.");
                    }
                }
                yield var24_87.post(v26);
            }
            case 7 -> new Request.Builder().url(url$iv).method("OPTIONS", null);
            default -> throw new NoWhenBranchMatchedException();
        });
        boolean bl522 = false;
        Map<String, String> $this$forEach$iv$iv3 = headers$iv;
        boolean $i$f$forEach322 = false;
        Iterator<Map.Entry<String, String>> bl2 = $this$forEach$iv$iv3.entrySet().iterator();
        while (bl2.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> header$iv = entry = bl2.next();
            boolean bl6 = false;
            $this$request_u24lambda_u2411$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string5 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string5 != null && (string5 = StringsKt.substringBefore$default((String)string5, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach322 = string5;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string6 = $i$f$forEach322.toLowerCase(locale);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object4;
            ApiClient bl522 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object4 = null;
            } else if (Intrinsics.areEqual(BalanceList.class, File.class)) {
                File tempFile$iv$iv = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                tempFile$iv$iv.deleteOnExit();
                Closeable closeable = body$iv$iv.byteStream();
                Throwable header$iv = null;
                try {
                    long l;
                    InputStream inputStream$iv$iv = (InputStream)closeable;
                    boolean bl7 = false;
                    Intrinsics.checkNotNull((Object)tempFile$iv$iv);
                    object = new FileOutputStream(tempFile$iv$iv);
                    Throwable throwable = null;
                    try {
                        FileOutputStream tempFileOutputStream$iv$iv = (FileOutputStream)object;
                        boolean bl8 = false;
                        l = ByteStreamsKt.copyTo$default((InputStream)inputStream$iv$iv, (OutputStream)tempFileOutputStream$iv$iv, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    }
                    long l2 = l;
                }
                catch (Throwable throwable) {
                    header$iv = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)header$iv);
                }
                object4 = (BalanceList)((Object)tempFile$iv$iv);
            } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                String bodyContent$iv$iv = body$iv$iv.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object4 = null;
                } else {
                    Moshi moshi = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object4 = _MoshiKotlinExtensionsKt.adapter((Moshi)moshi, (KType)Reflection.nullableTypeOf(BalanceList.class)).fromJson(bodyContent$iv$iv);
                }
            } else if (Intrinsics.areEqual((Object)accept$iv, (Object)"application/octet-stream")) {
                byte[] byArray = body$iv$iv.bytes();
                if (!(byArray instanceof BalanceList)) {
                    byArray = null;
                }
                object4 = (BalanceList)byArray;
            } else {
                throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
            }
            Map map = response$iv.headers().toMultimap();
            int n = response$iv.code();
            BalanceList balanceList = object4;
            apiResponse = new Success<Object>(balanceList, n, (Map<String, List<String>>)((Map<String, ? extends List<String>>)map));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Unit> getBalancesRequestConfig(int xAPIVersion, @Nullable String currencyCodes) {
        int n;
        Map map;
        Object localVariableBody = null;
        Map $this$getBalancesRequestConfig_u24lambda_u240 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (currencyCodes != null) {
            $this$getBalancesRequestConfig_u24lambda_u240.put("currencyCodes", CollectionsKt.listOf((Object)currencyCodes.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        int $this$getBalancesRequestConfig_u24lambda_u241 = n = xAPIVersion;
        boolean bl2 = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$getBalancesRequestConfig_u24lambda_u241));
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.GET;
        return new RequestConfig<Unit>(requestMethod, "/balances", localVariableHeaders, null, localVariableQuery, true, localVariableBody, 8, null);
    }

    private final String encodeURIComponent(String uriComponent) {
        return (String)new HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments().get(0);
    }

    private static final String defaultBasePath_delegate$lambda$2() {
        return System.getProperties().getProperty("tech.carpentum.sdk.payment.internal.generated.baseUrl", "https://api.sandbox.carpentum.tech");
    }

    public AccountsApi() {
        this(null, null, 3, null);
    }

    @NotNull
    public static final String getDefaultBasePath() {
        return Companion.getDefaultBasePath();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u00020\u00058FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/api/AccountsApi$Companion;", "", "<init>", "()V", "defaultBasePath", "", "getDefaultBasePath$annotations", "getDefaultBasePath", "()Ljava/lang/String;", "defaultBasePath$delegate", "Lkotlin/Lazy;", "payment-client-v2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultBasePath() {
            Lazy lazy = defaultBasePath$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (String)object;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultBasePath$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseType.values().length];
            try {
                nArray[ResponseType.Success.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Informational.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Redirection.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ClientError.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ServerError.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

