/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PaymentOperatorReverseInheritanceImpl;
import tech.carpentum.sdk.payment.model.CustomerTransactionFee;
import tech.carpentum.sdk.payment.model.PaymentOperator;

@JsonClass(generateAdapter=false)
public interface PaymentOperatorOutgoing
extends PaymentOperator {
    @Override
    @NotNull
    public String getCode();

    @Override
    @NotNull
    public String getName();

    @Override
    @NotNull
    public Optional<CustomerTransactionFee> getCustomerTransactionFee();

    @NotNull
    public static Builder builder(PaymentOperatorOutgoing copyOf) {
        Builder builder = PaymentOperatorOutgoing.builder();
        builder.code(copyOf.getCode());
        builder.name(copyOf.getName());
        builder.customerTransactionFee(copyOf.getCustomerTransactionFee().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PaymentOperatorReverseInheritanceImpl.BuilderImpl("PaymentOperatorOutgoing");
    }

    public static interface Builder {
        @NotNull
        public Builder code(String var1);

        @NotNull
        public Builder name(String var1);

        @NotNull
        public Builder customerTransactionFee(CustomerTransactionFee var1);

        @NotNull
        public PaymentOperatorOutgoing build();
    }
}

