/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.ExternalReference;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;
import tech.carpentum.sdk.payment.model.UpiQRMethodResponse;

@JsonClass(generateAdapter=false)
public class UpiQRMethodResponseImpl
implements UpiQRMethodResponse {
    private final IdPayin idPayin;
    private final IdPayment idPayment;
    private final Money money;
    private final Optional<MoneyVat> vat;
    private final String merchantName;
    private final String reference;
    private final Optional<ExternalReference> externalReference;
    private final String qrName;
    private final String qrCode;
    private final Optional<String> upiQrDeepLink;
    private final Optional<PaymentOperatorIncoming> paymentOperator;
    private final Optional<String> upiId;
    private final String returnUrl;
    private final OffsetDateTime acceptedAt;
    private final OffsetDateTime expireAt;
    private final int hashCode;
    private final String toString;

    @Override
    public IdPayin getIdPayin() {
        return this.idPayin;
    }

    @Override
    public IdPayment getIdPayment() {
        return this.idPayment;
    }

    @Override
    public Money getMoney() {
        return this.money;
    }

    @Override
    public Optional<MoneyVat> getVat() {
        return this.vat;
    }

    @Override
    public String getMerchantName() {
        return this.merchantName;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public Optional<ExternalReference> getExternalReference() {
        return this.externalReference;
    }

    @Override
    public String getQrName() {
        return this.qrName;
    }

    @Override
    public String getQrCode() {
        return this.qrCode;
    }

    @Override
    public Optional<String> getUpiQrDeepLink() {
        return this.upiQrDeepLink;
    }

    @Override
    public Optional<PaymentOperatorIncoming> getPaymentOperator() {
        return this.paymentOperator;
    }

    @Override
    public Optional<String> getUpiId() {
        return this.upiId;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public OffsetDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    @Override
    public OffsetDateTime getExpireAt() {
        return this.expireAt;
    }

    @Override
    public PayinMethodResponse.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private UpiQRMethodResponseImpl(BuilderImpl builder) {
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.idPayment = Objects.requireNonNull(builder.idPayment, "Property 'idPayment' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.vat = Optional.ofNullable(builder.vat);
        this.merchantName = Objects.requireNonNull(builder.merchantName, "Property 'merchantName' is required.");
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.externalReference = Optional.ofNullable(builder.externalReference);
        this.qrName = Objects.requireNonNull(builder.qrName, "Property 'qrName' is required.");
        this.qrCode = Objects.requireNonNull(builder.qrCode, "Property 'qrCode' is required.");
        this.upiQrDeepLink = Optional.ofNullable(builder.upiQrDeepLink);
        this.paymentOperator = Optional.ofNullable(builder.paymentOperator);
        this.upiId = Optional.ofNullable(builder.upiId);
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.hashCode = Objects.hash(this.idPayin, this.idPayment, this.money, this.vat, this.merchantName, this.reference, this.externalReference, this.qrName, this.qrCode, this.upiQrDeepLink, this.paymentOperator, this.upiId, this.returnUrl, this.acceptedAt, this.expireAt);
        this.toString = builder.type + "(idPayin=" + this.idPayin + ", idPayment=" + this.idPayment + ", money=" + this.money + ", vat=" + this.vat + ", merchantName=" + this.merchantName + ", reference=" + this.reference + ", externalReference=" + this.externalReference + ", qrName=" + this.qrName + ", qrCode=" + this.qrCode + ", upiQrDeepLink=" + this.upiQrDeepLink + ", paymentOperator=" + this.paymentOperator + ", upiId=" + this.upiId + ", returnUrl=" + this.returnUrl + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpiQRMethodResponseImpl)) {
            return false;
        }
        UpiQRMethodResponseImpl that = (UpiQRMethodResponseImpl)obj;
        if (!Objects.equals(this.idPayin, that.idPayin)) {
            return false;
        }
        if (!Objects.equals(this.idPayment, that.idPayment)) {
            return false;
        }
        if (!Objects.equals(this.money, that.money)) {
            return false;
        }
        if (!Objects.equals(this.vat, that.vat)) {
            return false;
        }
        if (!Objects.equals(this.merchantName, that.merchantName)) {
            return false;
        }
        if (!Objects.equals(this.reference, that.reference)) {
            return false;
        }
        if (!Objects.equals(this.externalReference, that.externalReference)) {
            return false;
        }
        if (!Objects.equals(this.qrName, that.qrName)) {
            return false;
        }
        if (!Objects.equals(this.qrCode, that.qrCode)) {
            return false;
        }
        if (!Objects.equals(this.upiQrDeepLink, that.upiQrDeepLink)) {
            return false;
        }
        if (!Objects.equals(this.paymentOperator, that.paymentOperator)) {
            return false;
        }
        if (!Objects.equals(this.upiId, that.upiId)) {
            return false;
        }
        if (!Objects.equals(this.returnUrl, that.returnUrl)) {
            return false;
        }
        if (!Objects.equals(this.acceptedAt, that.acceptedAt)) {
            return false;
        }
        return Objects.equals(this.expireAt, that.expireAt);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements UpiQRMethodResponse.Builder {
        private IdPayin idPayin = null;
        private IdPayment idPayment = null;
        private Money money = null;
        private MoneyVat vat = null;
        private String merchantName = null;
        private String reference = null;
        private ExternalReference externalReference = null;
        private String qrName = null;
        private String qrCode = null;
        private String upiQrDeepLink = null;
        private PaymentOperatorIncoming paymentOperator = null;
        private String upiId = null;
        private String returnUrl = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("UpiQRMethodResponse");
        }

        @Override
        public BuilderImpl idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        @Override
        public BuilderImpl idPayment(IdPayment idPayment) {
            this.idPayment = idPayment;
            return this;
        }

        @Override
        public BuilderImpl money(Money money) {
            this.money = money;
            return this;
        }

        @Override
        public BuilderImpl vat(MoneyVat vat) {
            this.vat = vat;
            return this;
        }

        @Override
        public BuilderImpl merchantName(String merchantName) {
            this.merchantName = merchantName;
            return this;
        }

        @Override
        public BuilderImpl reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public BuilderImpl externalReference(ExternalReference externalReference) {
            this.externalReference = externalReference;
            return this;
        }

        @Override
        public BuilderImpl qrName(String qrName) {
            this.qrName = qrName;
            return this;
        }

        @Override
        public BuilderImpl qrCode(String qrCode) {
            this.qrCode = qrCode;
            return this;
        }

        @Override
        public BuilderImpl upiQrDeepLink(String upiQrDeepLink) {
            this.upiQrDeepLink = upiQrDeepLink;
            return this;
        }

        @Override
        public BuilderImpl paymentOperator(PaymentOperatorIncoming paymentOperator) {
            this.paymentOperator = paymentOperator;
            return this;
        }

        @Override
        public BuilderImpl upiId(String upiId) {
            this.upiId = upiId;
            return this;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public BuilderImpl acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        @Override
        public BuilderImpl expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Override
        public UpiQRMethodResponseImpl build() {
            return new UpiQRMethodResponseImpl(this);
        }
    }
}

