/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment;

import java.io.InterruptedIOException;
import java.time.Duration;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.EndpointDefinition;
import tech.carpentum.sdk.payment.PaymentContext;
import tech.carpentum.sdk.payment.ResponseException;
import tech.carpentum.sdk.payment.internal.api.CommaSeparatedCodes;
import tech.carpentum.sdk.payment.internal.api.EnhancedAccountsApi;
import tech.carpentum.sdk.payment.internal.api.GetPayoutErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.ResponseExceptionUtils;
import tech.carpentum.sdk.payment.model.BalanceList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ltech/carpentum/sdk/payment/AccountsApi;", "", "apiVersion", "", "api", "Ltech/carpentum/sdk/payment/internal/api/EnhancedAccountsApi;", "(ILtech/carpentum/sdk/payment/internal/api/EnhancedAccountsApi;)V", "listBalances", "Ltech/carpentum/sdk/payment/model/BalanceList;", "currencyCodes", "", "", "Factory", "payment-client-v2"})
public final class AccountsApi {
    @NotNull
    public static final Factory Factory = new Factory(null);
    private final int apiVersion;
    @NotNull
    private final EnhancedAccountsApi api;

    private AccountsApi(int apiVersion, EnhancedAccountsApi api) {
        this.apiVersion = apiVersion;
        this.api = api;
    }

    @JvmOverloads
    @NotNull
    public final BalanceList listBalances(@Nullable Set<String> currencyCodes) throws ResponseException, InterruptedIOException {
        return (BalanceList)ResponseExceptionUtils.INSTANCE.wrap(GetPayoutErrorExceptionFactory.Companion.getInstance(), (Function0)new Function0<BalanceList>(this, currencyCodes){
            final /* synthetic */ AccountsApi this$0;
            final /* synthetic */ Set<String> $currencyCodes;
            {
                this.this$0 = $receiver;
                this.$currencyCodes = $currencyCodes;
                super(0);
            }

            @NotNull
            public final BalanceList invoke() {
                EnhancedAccountsApi enhancedAccountsApi = AccountsApi.access$getApi$p(this.this$0);
                String string = CommaSeparatedCodes.INSTANCE.format(this.$currencyCodes);
                int n = AccountsApi.access$getApiVersion$p(this.this$0);
                return enhancedAccountsApi.getBalances(n, string);
            }
        });
    }

    public static /* synthetic */ BalanceList listBalances$default(AccountsApi accountsApi, Set set, int n, Object object) throws ResponseException, InterruptedIOException {
        if ((n & 1) != 0) {
            set = null;
        }
        return accountsApi.listBalances(set);
    }

    @JvmOverloads
    @NotNull
    public final BalanceList listBalances() throws ResponseException, InterruptedIOException {
        return AccountsApi.listBalances$default(this, null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineListBalancesEndpoint() {
        return Factory.defineListBalancesEndpoint();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AccountsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
        return Factory.create(context, accessToken, callTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AccountsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
        return Factory.create(context, accessToken);
    }

    public static final /* synthetic */ EnhancedAccountsApi access$getApi$p(AccountsApi $this) {
        return $this.api;
    }

    public static final /* synthetic */ int access$getApiVersion$p(AccountsApi $this) {
        return $this.apiVersion;
    }

    public /* synthetic */ AccountsApi(int apiVersion, EnhancedAccountsApi api, DefaultConstructorMarker $constructor_marker) {
        this(apiVersion, api);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Ltech/carpentum/sdk/payment/AccountsApi$Factory;", "", "()V", "create", "Ltech/carpentum/sdk/payment/AccountsApi;", "context", "Ltech/carpentum/sdk/payment/PaymentContext;", "accessToken", "", "callTimeout", "Ljava/time/Duration;", "defineListBalancesEndpoint", "Ltech/carpentum/sdk/payment/EndpointDefinition;", "payment-client-v2"})
    public static final class Factory {
        private Factory() {
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineListBalancesEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.GET, "/balances");
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AccountsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            int n = context.getApiVersion();
            String string = context.getApiBaseUrl();
            Duration duration = callTimeout;
            if (duration == null) {
                duration = context.getDefaultCallTimeout();
            }
            return new AccountsApi(n, new EnhancedAccountsApi(string, accessToken, duration), null);
        }

        public static /* synthetic */ AccountsApi create$default(Factory factory, PaymentContext paymentContext, String string, Duration duration, int n, Object object) {
            if ((n & 4) != 0) {
                duration = null;
            }
            return factory.create(paymentContext, string, duration);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AccountsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return tech.carpentum.sdk.payment.AccountsApi$Factory.create$default(this, context, accessToken, null, 4, null);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

