/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountResponseDetail;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public class AccountResponseDetailImpl
implements AccountResponseDetail {
    private final Optional<String> accountName;
    private final Optional<String> accountNumber;
    private final Optional<String> accountType;
    private final Optional<String> bankCode;
    private final Optional<PaymentOperatorIncoming> paymentOperator;
    private final Optional<String> bankName;
    private final Optional<String> bankBranch;
    private final Optional<String> bankCity;
    private final Optional<String> bankProvince;
    private final int hashCode;
    private final String toString;

    @Override
    public Optional<String> getAccountName() {
        return this.accountName;
    }

    @Override
    public Optional<String> getAccountNumber() {
        return this.accountNumber;
    }

    @Override
    public Optional<String> getAccountType() {
        return this.accountType;
    }

    @Override
    public Optional<String> getBankCode() {
        return this.bankCode;
    }

    @Override
    public Optional<PaymentOperatorIncoming> getPaymentOperator() {
        return this.paymentOperator;
    }

    @Override
    public Optional<String> getBankName() {
        return this.bankName;
    }

    @Override
    public Optional<String> getBankBranch() {
        return this.bankBranch;
    }

    @Override
    public Optional<String> getBankCity() {
        return this.bankCity;
    }

    @Override
    public Optional<String> getBankProvince() {
        return this.bankProvince;
    }

    private AccountResponseDetailImpl(BuilderImpl builder) {
        this.accountName = Optional.ofNullable(builder.accountName);
        this.accountNumber = Optional.ofNullable(builder.accountNumber);
        this.accountType = Optional.ofNullable(builder.accountType);
        this.bankCode = Optional.ofNullable(builder.bankCode);
        this.paymentOperator = Optional.ofNullable(builder.paymentOperator);
        this.bankName = Optional.ofNullable(builder.bankName);
        this.bankBranch = Optional.ofNullable(builder.bankBranch);
        this.bankCity = Optional.ofNullable(builder.bankCity);
        this.bankProvince = Optional.ofNullable(builder.bankProvince);
        this.hashCode = Objects.hash(this.accountName, this.accountNumber, this.accountType, this.bankCode, this.paymentOperator, this.bankName, this.bankBranch, this.bankCity, this.bankProvince);
        this.toString = builder.type + "(accountName=" + this.accountName + ", accountNumber=" + this.accountNumber + ", accountType=" + this.accountType + ", bankCode=" + this.bankCode + ", paymentOperator=" + this.paymentOperator + ", bankName=" + this.bankName + ", bankBranch=" + this.bankBranch + ", bankCity=" + this.bankCity + ", bankProvince=" + this.bankProvince + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountResponseDetailImpl)) {
            return false;
        }
        AccountResponseDetailImpl that = (AccountResponseDetailImpl)obj;
        if (!Objects.equals(this.accountName, that.accountName)) {
            return false;
        }
        if (!Objects.equals(this.accountNumber, that.accountNumber)) {
            return false;
        }
        if (!Objects.equals(this.accountType, that.accountType)) {
            return false;
        }
        if (!Objects.equals(this.bankCode, that.bankCode)) {
            return false;
        }
        if (!Objects.equals(this.paymentOperator, that.paymentOperator)) {
            return false;
        }
        if (!Objects.equals(this.bankName, that.bankName)) {
            return false;
        }
        if (!Objects.equals(this.bankBranch, that.bankBranch)) {
            return false;
        }
        if (!Objects.equals(this.bankCity, that.bankCity)) {
            return false;
        }
        return Objects.equals(this.bankProvince, that.bankProvince);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements AccountResponseDetail.Builder {
        private String accountName = null;
        private String accountNumber = null;
        private String accountType = null;
        private String bankCode = null;
        private PaymentOperatorIncoming paymentOperator = null;
        private String bankName = null;
        private String bankBranch = null;
        private String bankCity = null;
        private String bankProvince = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("AccountResponseDetail");
        }

        @Override
        public BuilderImpl accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        @Override
        public BuilderImpl accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        @Override
        public BuilderImpl accountType(String accountType) {
            this.accountType = accountType;
            return this;
        }

        @Override
        public BuilderImpl bankCode(String bankCode) {
            this.bankCode = bankCode;
            return this;
        }

        @Override
        public BuilderImpl paymentOperator(PaymentOperatorIncoming paymentOperator) {
            this.paymentOperator = paymentOperator;
            return this;
        }

        @Override
        public BuilderImpl bankName(String bankName) {
            this.bankName = bankName;
            return this;
        }

        @Override
        public BuilderImpl bankBranch(String bankBranch) {
            this.bankBranch = bankBranch;
            return this;
        }

        @Override
        public BuilderImpl bankCity(String bankCity) {
            this.bankCity = bankCity;
            return this;
        }

        @Override
        public BuilderImpl bankProvince(String bankProvince) {
            this.bankProvince = bankProvince;
            return this;
        }

        @Override
        public AccountResponseDetailImpl build() {
            return new AccountResponseDetailImpl(this);
        }
    }
}

