/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.infrastructure;

import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiAbstractionsKt;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiResponse;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Informational;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Redirection;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.RequestConfig;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.RequestMethod;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ResponseExtensionsKt;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Serializer;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Success;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0004J\u0012\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0004J\"\u0010\u0010\u001a\u00020\u0003\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u00012\u0006\u0010\u000f\u001a\u0002H\u0011H\u0084\b\u00a2\u0006\u0002\u0010\u0012J/\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00110\u0014\"\u0006\b\u0000\u0010\u0015\u0018\u0001\"\u0006\b\u0001\u0010\u0011\u0018\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017H\u0084\bJ(\u0010\u0018\u001a\u00020\u0019\"\u0006\b\u0000\u0010\u0011\u0018\u00012\u0006\u0010\u001a\u001a\u0002H\u00112\b\b\u0002\u0010\u001b\u001a\u00020\u0003H\u0084\b\u00a2\u0006\u0002\u0010\u001cJ.\u0010\u001d\u001a\u0004\u0018\u0001H\u0011\"\u0006\b\u0000\u0010\u0011\u0018\u00012\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0084\b\u00a2\u0006\u0002\u0010 J\u001c\u0010!\u001a\u00020\"\"\u0004\b\u0000\u0010\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0017H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient;", "", "baseUrl", "", "client", "Lokhttp3/OkHttpClient;", "(Ljava/lang/String;Lokhttp3/OkHttpClient;)V", "getBaseUrl", "()Ljava/lang/String;", "getClient", "()Lokhttp3/OkHttpClient;", "guessContentTypeFromFile", "file", "Ljava/io/File;", "parameterToString", "value", "parseDateToQueryString", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "request", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiResponse;", "I", "requestConfig", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/RequestConfig;", "requestBody", "Lokhttp3/RequestBody;", "content", "mediaType", "(Ljava/lang/Object;Ljava/lang/String;)Lokhttp3/RequestBody;", "responseBody", "body", "Lokhttp3/ResponseBody;", "(Lokhttp3/ResponseBody;Ljava/lang/String;)Ljava/lang/Object;", "updateAuthParams", "", "Companion", "payment-client-v2"})
@SourceDebugExtension(value={"SMAP\nApiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiClient.kt\ntech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,249:1\n62#1,9:259\n71#1,18:269\n89#1,7:288\n96#1,2:296\n98#1,15:299\n62#1,9:314\n71#1,18:324\n89#1,7:343\n96#1,2:351\n98#1,15:354\n62#1,9:369\n71#1,18:379\n89#1,7:398\n96#1,2:406\n98#1,15:409\n62#1,9:424\n71#1,18:434\n89#1,7:453\n96#1,2:461\n98#1,15:464\n116#1,19:481\n135#1:501\n246#1:502\n215#2,2:250\n215#2,2:252\n215#2:255\n216#2:258\n215#2:268\n216#2:287\n215#2:295\n216#2:298\n215#2:323\n216#2:342\n215#2:350\n216#2:353\n215#2:378\n216#2:397\n215#2:405\n216#2:408\n215#2:433\n216#2:452\n215#2:460\n216#2:463\n215#2,2:479\n29#3:254\n29#3:500\n1855#4,2:256\n*S KotlinDebug\n*F\n+ 1 ApiClient.kt\ntech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient\n*L\n184#1:259,9\n184#1:269,18\n184#1:288,7\n184#1:296,2\n184#1:299,15\n187#1:314,9\n187#1:324,18\n187#1:343,7\n187#1:351,2\n187#1:354,15\n188#1:369,9\n188#1:379,18\n188#1:398,7\n188#1:406,2\n188#1:409,15\n189#1:424,9\n189#1:434,18\n189#1:453,7\n189#1:461,2\n189#1:464,15\n211#1:481,19\n211#1:501\n235#1:502\n70#1:250,2\n95#1:252,2\n156#1:255\n156#1:258\n184#1:268\n184#1:287\n184#1:295\n184#1:298\n187#1:323\n187#1:342\n187#1:350\n187#1:353\n188#1:378\n188#1:397\n188#1:405\n188#1:408\n189#1:433\n189#1:452\n189#1:460\n189#1:463\n192#1:479,2\n134#1:254\n211#1:500\n157#1:256,2\n*E\n"})
public class ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String baseUrl;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    protected static final String ContentType = "Content-Type";
    @NotNull
    protected static final String Accept = "Accept";
    @NotNull
    public static final String Authorization = "Authorization";
    @NotNull
    protected static final String JsonMediaType = "application/json";
    @NotNull
    protected static final String FormDataMediaType = "multipart/form-data";
    @NotNull
    protected static final String FormUrlEncMediaType = "application/x-www-form-urlencoded";
    @NotNull
    protected static final String XmlMediaType = "application/xml";
    @NotNull
    private static final Map<String, String> apiKey = new LinkedHashMap();
    @NotNull
    private static final Map<String, String> apiKeyPrefix = new LinkedHashMap();
    @Nullable
    private static String username;
    @Nullable
    private static String password;
    @Nullable
    private static String accessToken;
    @NotNull
    public static final String baseUrlKey = "tech.carpentum.sdk.payment.internal.generated.baseUrl";

    public ApiClient(@NotNull String baseUrl, @NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.baseUrl = baseUrl;
        this.client = client;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    @NotNull
    protected final String guessContentTypeFromFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        String string = contentType;
        if (string == null) {
            string = "application/octet-stream";
        }
        return string;
    }

    protected final /* synthetic */ <T> RequestBody requestBody(T content, String mediaType) {
        RequestBody requestBody;
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        boolean $i$f$requestBody = false;
        if (content instanceof File) {
            requestBody = RequestBody.Companion.create((File)content, MediaType.Companion.parse(mediaType));
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormDataMediaType)) {
            MultipartBody.Builder builder;
            MultipartBody.Builder $this$requestBody_u24lambda_u241 = builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
            boolean bl = false;
            Intrinsics.checkNotNull(content, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Headers partHeaders;
                String[] stringArray;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof File) {
                    stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key + "\"; filename=\"" + ((File)value).getName() + "\""};
                    partHeaders = Headers.Companion.of(stringArray);
                    MediaType fileMediaType = MediaType.Companion.parse(this.guessContentTypeFromFile((File)value));
                    $this$requestBody_u24lambda_u241.addPart(partHeaders, RequestBody.Companion.create((File)value, fileMediaType));
                    continue;
                }
                stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key + "\""};
                partHeaders = Headers.Companion.of(stringArray);
                $this$requestBody_u24lambda_u241.addPart(partHeaders, RequestBody.Companion.create(this.parameterToString(value), null));
            }
            requestBody = (RequestBody)builder.build();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormUrlEncMediaType)) {
            FormBody.Builder builder;
            FormBody.Builder $this$requestBody_u24lambda_u243 = builder = new FormBody.Builder(null, 1, null);
            boolean bl = false;
            Intrinsics.checkNotNull(content, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl3 = false;
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                $this$requestBody_u24lambda_u243.add(key, this.parameterToString(value));
            }
            requestBody = (RequestBody)builder.build();
        } else if (StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null)) {
            if (content == null) {
                requestBody = Util.EMPTY_REQUEST;
            } else {
                Moshi moshi2 = Serializer.getMoshi();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                String string = moshi2.adapter(Object.class).toJson(content);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                requestBody = RequestBody.Companion.create(string, MediaType.Companion.parse(mediaType));
            }
        } else {
            if (Intrinsics.areEqual((Object)mediaType, (Object)XmlMediaType)) {
                throw new UnsupportedOperationException("xml not currently supported.");
            }
            throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
        }
        return requestBody;
    }

    public static /* synthetic */ RequestBody requestBody$default(ApiClient $this, Object content, String mediaType, int n, Object object) {
        RequestBody requestBody;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: requestBody");
        }
        if ((n & 2) != 0) {
            mediaType = JsonMediaType;
        }
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        boolean $i$f$requestBody = false;
        if (content instanceof File) {
            requestBody = RequestBody.Companion.create((File)content, MediaType.Companion.parse(mediaType));
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormDataMediaType)) {
            object = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
            MultipartBody.Builder $this$requestBody_u24lambda_u241 = (MultipartBody.Builder)object;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)content, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Headers partHeaders;
                String[] stringArray;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof File) {
                    stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key + "\"; filename=\"" + ((File)value).getName() + "\""};
                    partHeaders = Headers.Companion.of(stringArray);
                    MediaType fileMediaType = MediaType.Companion.parse($this.guessContentTypeFromFile((File)value));
                    $this$requestBody_u24lambda_u241.addPart(partHeaders, RequestBody.Companion.create((File)value, fileMediaType));
                    continue;
                }
                stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key + "\""};
                partHeaders = Headers.Companion.of(stringArray);
                $this$requestBody_u24lambda_u241.addPart(partHeaders, RequestBody.Companion.create($this.parameterToString(value), null));
            }
            requestBody = (RequestBody)((MultipartBody.Builder)object).build();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormUrlEncMediaType)) {
            object = new FormBody.Builder(null, 1, null);
            FormBody.Builder $this$requestBody_u24lambda_u243 = (FormBody.Builder)object;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)content, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl3 = false;
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                $this$requestBody_u24lambda_u243.add(key, $this.parameterToString(value));
            }
            requestBody = (RequestBody)((FormBody.Builder)object).build();
        } else if (StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null)) {
            if (content == null) {
                requestBody = Util.EMPTY_REQUEST;
            } else {
                Moshi moshi2 = Serializer.getMoshi();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                String string = moshi2.adapter(Object.class).toJson(content);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                requestBody = RequestBody.Companion.create(string, MediaType.Companion.parse(mediaType));
            }
        } else {
            if (Intrinsics.areEqual((Object)mediaType, (Object)XmlMediaType)) {
                throw new UnsupportedOperationException("xml not currently supported.");
            }
            throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
        }
        return requestBody;
    }

    protected final /* synthetic */ <T> T responseBody(ResponseBody body, String mediaType) {
        boolean $i$f$responseBody = false;
        if (body == null) {
            return null;
        }
        String bodyContent = body.string();
        if (((CharSequence)bodyContent).length() == 0) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, File.class)) {
            File f = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
            f.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            out.write(bodyContent);
            out.close();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)f;
        }
        if (!(mediaType == null || StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null))) {
            throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
        }
        Moshi $this$adapter$iv = Serializer.getMoshi();
        boolean $i$f$adapter = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        return (T)_MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, null).fromJson(bodyContent);
    }

    public static /* synthetic */ Object responseBody$default(ApiClient $this, ResponseBody body, String mediaType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: responseBody");
        }
        if ((n & 2) != 0) {
            mediaType = JsonMediaType;
        }
        boolean $i$f$responseBody = false;
        if (body == null) {
            return null;
        }
        String bodyContent = body.string();
        if (((CharSequence)bodyContent).length() == 0) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, File.class)) {
            File f = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
            f.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            out.write(bodyContent);
            out.close();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return f;
        }
        if (!(mediaType == null || StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null))) {
            throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
        }
        Moshi $this$adapter$iv = Serializer.getMoshi();
        boolean $i$f$adapter = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        return _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, null).fromJson(bodyContent);
    }

    protected <T> void updateAuthParams(@NotNull RequestConfig<T> requestConfig) {
        block1: {
            Intrinsics.checkNotNullParameter(requestConfig, (String)"requestConfig");
            CharSequence charSequence = requestConfig.getHeaders().get(Authorization);
            if (!(charSequence == null || charSequence.length() == 0)) break block1;
            String string = accessToken;
            if (string != null) {
                String accessToken = string;
                boolean bl = false;
                requestConfig.getHeaders().put(Authorization, "Bearer " + accessToken);
            }
        }
    }

    protected final /* synthetic */ <I, T> ApiResponse<T> request(RequestConfig<I> requestConfig) {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers;
        Map.Entry<String, List<String>> element$iv;
        Intrinsics.checkNotNullParameter(requestConfig, (String)"requestConfig");
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl2 = httpUrl;
        this.updateAuthParams(requestConfig);
        Object object = new char[]{'/'};
        object = httpUrl2.newBuilder().addPathSegments(StringsKt.trimStart((String)requestConfig.getPath(), (char[])object));
        Object $this$request_u24lambda_u247 = (HttpUrl.Builder)object;
        boolean $i$a$-apply-ApiClient$request$url$22 = false;
        Request.Builder $this$forEach$iv = requestConfig.getQuery();
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry<String, List<String>> query = element$iv = object2.next();
            boolean bl6 = false;
            Iterable $this$forEach$iv2 = query.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String queryValue = (String)element$iv2;
                boolean bl2 = false;
                $this$request_u24lambda_u247.addQueryParameter(query.getKey(), queryValue);
            }
        }
        HttpUrl url = ((HttpUrl.Builder)object).build();
        object = requestConfig.getHeaders().get(ContentType);
        if (object == null || object.length() == 0) {
            requestConfig.getHeaders().put(ContentType, JsonMediaType);
        }
        if ((object = (CharSequence)requestConfig.getHeaders().get(Accept)) == null || object.length() == 0) {
            requestConfig.getHeaders().put(Accept, JsonMediaType);
        }
        if (($this$request_u24lambda_u247 = (CharSequence)(headers = requestConfig.getHeaders()).get(ContentType)) == null || $this$request_u24lambda_u247.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u247 = headers.get(Accept);
        if ($this$request_u24lambda_u247 == null || $this$request_u24lambda_u247.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers.get(ContentType);
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String $i$a$-apply-ApiClient$request$url$22 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = $i$a$-apply-ApiClient$request$url$22.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType = string3;
        switch (WhenMappings.$EnumSwitchMapping$0[requestConfig.getMethod().ordinal()]) {
            case 1: {
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv;
                String[] fileMediaType$iv;
                ApiClient this_$iv;
                Headers partHeaders$iv;
                String[] stringArray;
                Object value$iv;
                String key$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv;
                RequestBody requestBody;
                I content$iv;
                object2 = this;
                element$iv = requestConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(contentType));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv;
                        entry = element$iv$iv = iterator.next();
                        bl4 = false;
                        key$iv = (String)entry.getKey();
                        value$iv = entry.getValue();
                        if (value$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\"; filename=\"" + ((File)value$iv).getName() + "\""};
                            partHeaders$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)value$iv));
                            $this$requestBody_u24lambda_u241$iv.addPart(partHeaders$iv, RequestBody.Companion.create((File)value$iv, (MediaType)fileMediaType$iv));
                            continue;
                        }
                        fileMediaType$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\""};
                        partHeaders$iv = Headers.Companion.of(fileMediaType$iv);
                        $this$requestBody_u24lambda_u241$iv.addPart(partHeaders$iv, RequestBody.Companion.create(this_$iv.parameterToString(value$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        entry = element$iv$iv;
                        bl = false;
                        key$iv = (String)entry.getKey();
                        value$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv.add(key$iv, this_$iv.parameterToString(value$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        Moshi moshi2 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String string4 = moshi2.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string4, MediaType.Companion.parse(contentType));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url).head();
                break;
            }
            case 4: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv;
                String[] fileMediaType$iv;
                Headers partHeaders$iv;
                Object value$iv;
                String key$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(contentType));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach5 = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        entry = element$iv$iv;
                        bl4 = false;
                        key$iv = (String)entry.getKey();
                        value$iv = entry.getValue();
                        if (value$iv instanceof File) {
                            fileMediaType$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\"; filename=\"" + ((File)value$iv).getName() + "\""};
                            partHeaders$iv = Headers.Companion.of(fileMediaType$iv);
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)value$iv));
                            $this$requestBody_u24lambda_u241$iv.addPart(partHeaders$iv, RequestBody.Companion.create((File)value$iv, (MediaType)fileMediaType$iv));
                            continue;
                        }
                        fileMediaType$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\""};
                        partHeaders$iv = Headers.Companion.of(fileMediaType$iv);
                        $this$requestBody_u24lambda_u241$iv.addPart(partHeaders$iv, RequestBody.Companion.create(this_$iv.parameterToString(value$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach6 = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        entry = element$iv$iv;
                        bl = false;
                        key$iv = (String)entry.getKey();
                        value$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv.add(key$iv, this_$iv.parameterToString(value$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        Moshi moshi3 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String string5 = moshi3.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string5, MediaType.Companion.parse(contentType));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv;
                String[] fileMediaType$iv;
                Headers partHeaders$iv;
                Object value$iv;
                String key$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(contentType));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach7 = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        entry = element$iv$iv;
                        bl4 = false;
                        key$iv = (String)entry.getKey();
                        value$iv = entry.getValue();
                        if (value$iv instanceof File) {
                            fileMediaType$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\"; filename=\"" + ((File)value$iv).getName() + "\""};
                            partHeaders$iv = Headers.Companion.of(fileMediaType$iv);
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)value$iv));
                            $this$requestBody_u24lambda_u241$iv.addPart(partHeaders$iv, RequestBody.Companion.create((File)value$iv, (MediaType)fileMediaType$iv));
                            continue;
                        }
                        fileMediaType$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\""};
                        partHeaders$iv = Headers.Companion.of(fileMediaType$iv);
                        $this$requestBody_u24lambda_u241$iv.addPart(partHeaders$iv, RequestBody.Companion.create(this_$iv.parameterToString(value$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        entry = element$iv$iv;
                        bl = false;
                        key$iv = (String)entry.getKey();
                        value$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv.add(key$iv, this_$iv.parameterToString(value$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        Moshi moshi4 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String string6 = moshi4.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(contentType));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv;
                String[] fileMediaType$iv;
                Headers partHeaders$iv;
                String[] stringArray;
                Object value$iv;
                String key$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(contentType));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach9 = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        entry = element$iv$iv;
                        bl4 = false;
                        key$iv = (String)entry.getKey();
                        value$iv = entry.getValue();
                        if (value$iv instanceof File) {
                            fileMediaType$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\"; filename=\"" + ((File)value$iv).getName() + "\""};
                            partHeaders$iv = Headers.Companion.of(fileMediaType$iv);
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)value$iv));
                            $this$requestBody_u24lambda_u241$iv.addPart(partHeaders$iv, RequestBody.Companion.create((File)value$iv, (MediaType)fileMediaType$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\""};
                        partHeaders$iv = Headers.Companion.of(stringArray);
                        $this$requestBody_u24lambda_u241$iv.addPart(partHeaders$iv, RequestBody.Companion.create(this_$iv.parameterToString(value$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach10 = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        entry = element$iv$iv;
                        bl = false;
                        key$iv = (String)entry.getKey();
                        value$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv.add(key$iv, this_$iv.parameterToString(value$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        Moshi moshi5 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String string7 = moshi5.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string7, MediaType.Companion.parse(contentType));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$request_u24lambda_u249 = $this$forEach$iv = builder;
        boolean bl8 = false;
        Map<String, String> $this$forEach$iv3 = headers;
        boolean $i$f$forEach112 = false;
        Iterator<Map.Entry<String, String>> bl6 = $this$forEach$iv3.entrySet().iterator();
        while (bl6.hasNext()) {
            Map.Entry<String, String> element$iv3;
            Map.Entry<String, String> header = element$iv3 = bl6.next();
            boolean bl7 = false;
            $this$request_u24lambda_u249.addHeader(header.getKey(), header.getValue());
        }
        Request request = $this$forEach$iv.build();
        Response response = this.getClient().newCall(request).execute();
        String string8 = Response.header$default((Response)response, (String)ContentType, null, (int)2, null);
        if (string8 != null && (string8 = StringsKt.substringBefore$default((String)string8, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach112 = string8;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string9 = $i$f$forEach112.toLowerCase(locale2);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept = string;
        if (response.isRedirect()) {
            apiResponse = new Redirection(response.code(), response.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response)) {
            apiResponse = new Informational(response.message(), response.code(), response.headers().toMultimap());
        } else if (response.isSuccessful()) {
            Object object3;
            ApiClient bl8 = this;
            ResponseBody body$iv = response.body();
            boolean $i$f$responseBody = false;
            if (body$iv == null) {
                object3 = null;
            } else {
                String bodyContent$iv = body$iv.string();
                if (((CharSequence)bodyContent$iv).length() == 0) {
                    object3 = null;
                } else {
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                    if (Intrinsics.areEqual(Object.class, File.class)) {
                        File f$iv = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                        f$iv.deleteOnExit();
                        BufferedWriter out$iv = new BufferedWriter(new FileWriter(f$iv));
                        out$iv.write(bodyContent$iv);
                        out$iv.close();
                        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                        object3 = f$iv;
                    } else if (accept == null || StringsKt.startsWith$default((String)accept, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept, (String)"json", (boolean)false, (int)2, null)) {
                        Moshi $this$adapter$iv$iv = Serializer.getMoshi();
                        boolean $i$f$adapter = false;
                        Intrinsics.reifiedOperationMarker((int)6, (String)"T?");
                        object3 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv$iv, null).fromJson(bodyContent$iv);
                    } else {
                        throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                    }
                }
            }
            apiResponse = new Success<Object>(object3, response.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response)) {
            ResponseBody responseBody = response.body();
            apiResponse = new ClientError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
        } else {
            ResponseBody responseBody = response.body();
            apiResponse = new ServerError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    protected final String parameterToString(@Nullable Object value) {
        String string;
        Object object = value;
        if (object == null) {
            string = "";
        } else if (object instanceof Object[]) {
            string = ApiAbstractionsKt.toMultiValue$default((Object[])value, "csv", null, 4, null).toString();
        } else if (object instanceof Iterable) {
            string = ApiAbstractionsKt.toMultiValue$default((Iterable)value, "csv", null, 4, null).toString();
        } else if ((((object instanceof OffsetDateTime ? true : object instanceof OffsetTime) ? true : object instanceof LocalDateTime) ? true : object instanceof LocalDate) ? true : object instanceof LocalTime) {
            ApiClient this_$iv = this;
            boolean $i$f$parseDateToQueryString = false;
            String string2 = Serializer.getMoshi().adapter(Object.class).toJson(value);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toJson(...)");
            string = StringsKt.replace$default((String)string2, (String)"\"", (String)"", (boolean)false, (int)4, null);
        } else {
            string = value.toString();
        }
        return string;
    }

    protected final /* synthetic */ <T> String parseDateToQueryString(T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        boolean $i$f$parseDateToQueryString = false;
        Moshi moshi2 = Serializer.getMoshi();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = moshi2.adapter(Object.class).toJson(value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return StringsKt.replace$default((String)string, (String)"\"", (String)"", (boolean)false, (int)4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\r\"\u0004\b\u001c\u0010\u000f\u00a8\u0006\u001d"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient$Companion;", "", "()V", "Accept", "", "Authorization", "ContentType", "FormDataMediaType", "FormUrlEncMediaType", "JsonMediaType", "XmlMediaType", "accessToken", "getAccessToken", "()Ljava/lang/String;", "setAccessToken", "(Ljava/lang/String;)V", "apiKey", "", "getApiKey", "()Ljava/util/Map;", "apiKeyPrefix", "getApiKeyPrefix", "baseUrlKey", "password", "getPassword", "setPassword", "username", "getUsername", "setUsername", "payment-client-v2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getApiKey() {
            return apiKey;
        }

        @NotNull
        public final Map<String, String> getApiKeyPrefix() {
            return apiKeyPrefix;
        }

        @Nullable
        public final String getUsername() {
            return username;
        }

        public final void setUsername(@Nullable String string) {
            username = string;
        }

        @Nullable
        public final String getPassword() {
            return password;
        }

        public final void setPassword(@Nullable String string) {
            password = string;
        }

        @Nullable
        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(@Nullable String string) {
            accessToken = string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=176)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestMethod.values().length];
            try {
                nArray[RequestMethod.DELETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.GET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.HEAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.PATCH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.PUT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.POST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.OPTIONS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

