/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.FailureReasons;
import tech.carpentum.sdk.payment.model.PaymentProcess;
import tech.carpentum.sdk.payment.model.PaymentStatus;
import tech.carpentum.sdk.payment.model.ProcessorStatus;

@JsonClass(generateAdapter=false)
public class PaymentProcessImpl
implements PaymentProcess {
    private final PaymentStatus status;
    private final Optional<FailureReasons> failureReasons;
    private final OffsetDateTime createdAt;
    private final Optional<OffsetDateTime> processedAt;
    private final Boolean isTest;
    private final Optional<ProcessorStatus> processorStatus;
    private final int hashCode;
    private final String toString;

    @Override
    public PaymentStatus getStatus() {
        return this.status;
    }

    @Override
    public Optional<FailureReasons> getFailureReasons() {
        return this.failureReasons;
    }

    @Override
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Optional<OffsetDateTime> getProcessedAt() {
        return this.processedAt;
    }

    @Override
    public Boolean getIsTest() {
        return this.isTest;
    }

    @Override
    public Optional<ProcessorStatus> getProcessorStatus() {
        return this.processorStatus;
    }

    private PaymentProcessImpl(BuilderImpl builder) {
        this.status = Objects.requireNonNull(builder.status, "Property 'status' is required.");
        this.failureReasons = Optional.ofNullable(builder.failureReasons);
        this.createdAt = Objects.requireNonNull(builder.createdAt, "Property 'createdAt' is required.");
        this.processedAt = Optional.ofNullable(builder.processedAt);
        this.isTest = Objects.requireNonNull(builder.isTest, "Property 'isTest' is required.");
        this.processorStatus = Optional.ofNullable(builder.processorStatus);
        this.hashCode = Objects.hash(this.status, this.failureReasons, this.createdAt, this.processedAt, this.isTest, this.processorStatus);
        this.toString = builder.type + "(status=" + this.status + ", failureReasons=" + this.failureReasons + ", createdAt=" + this.createdAt + ", processedAt=" + this.processedAt + ", isTest=" + this.isTest + ", processorStatus=" + this.processorStatus + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentProcessImpl)) {
            return false;
        }
        PaymentProcessImpl that = (PaymentProcessImpl)obj;
        if (!this.status.equals(that.status)) {
            return false;
        }
        if (!this.failureReasons.equals(that.failureReasons)) {
            return false;
        }
        if (!this.createdAt.equals(that.createdAt)) {
            return false;
        }
        if (!this.processedAt.equals(that.processedAt)) {
            return false;
        }
        if (!this.isTest.equals(that.isTest)) {
            return false;
        }
        return this.processorStatus.equals(that.processorStatus);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PaymentProcess.Builder {
        private PaymentStatus status = null;
        private FailureReasons failureReasons = null;
        private OffsetDateTime createdAt = null;
        private OffsetDateTime processedAt = null;
        private Boolean isTest = null;
        private ProcessorStatus processorStatus = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PaymentProcess");
        }

        @Override
        public BuilderImpl status(PaymentStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public BuilderImpl failureReasons(FailureReasons failureReasons) {
            this.failureReasons = failureReasons;
            return this;
        }

        @Override
        public BuilderImpl createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public BuilderImpl processedAt(OffsetDateTime processedAt) {
            this.processedAt = processedAt;
            return this;
        }

        @Override
        public BuilderImpl isTest(Boolean isTest) {
            this.isTest = isTest;
            return this;
        }

        @Override
        public BuilderImpl processorStatus(ProcessorStatus processorStatus) {
            this.processorStatus = processorStatus;
            return this;
        }

        @Override
        public PaymentProcessImpl build() {
            return new PaymentProcessImpl(this);
        }
    }
}

