/*
 * Decompiled with CFR 0.152.
 */
package teamdapsr.loaders.lib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import java.util.Random;
import teamdapsr.loaders.lib.R;
import teamdapsr.loaders.lib.utils.MeasureUtils;

public class CrosswordGrid
extends View {
    private int squareSide;
    private Paint mSquarePaint;
    private Paint mSquarePaintFill;
    private int GRID_ROWS;
    private int GRID_COLUMNS;
    private boolean[][] coordinates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrosswordGrid(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CrosswordGrid, 0, 0);
        try {
            this.squareSide = a.getInt(R.styleable.CrosswordGrid_squareSide, 10);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            a.recycle();
        }
        this.GRID_COLUMNS = 10;
        this.GRID_ROWS = 10;
        this.coordinates = new boolean[this.GRID_ROWS][this.GRID_COLUMNS];
        for (int i = 0; i < this.GRID_ROWS; ++i) {
            for (int j = 0; j < this.GRID_COLUMNS; ++j) {
                this.coordinates[i][j] = false;
            }
        }
        this.init();
    }

    public CrosswordGrid(Context context, int squareSide) {
        super(context);
        this.squareSide = squareSide;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = MeasureUtils.getMeasurement(widthMeasureSpec, this.getDesiredWidth());
        int heightSize = MeasureUtils.getMeasurement(heightMeasureSpec, this.getDesiredHeight());
        this.setMeasuredDimension(widthSize + 10, heightSize + 10);
    }

    private int getDesiredWidth() {
        return 2 * this.squareSide + 200;
    }

    private int getDesiredHeight() {
        return 2 * this.squareSide + 200;
    }

    public int getSquareSide() {
        return this.squareSide;
    }

    public void setSquareSide(int side) {
        this.squareSide = side;
        this.invalidate();
        this.requestLayout();
    }

    private void init() {
        this.mSquarePaint = new Paint(1);
        this.mSquarePaint.setColor(-15724528);
        this.mSquarePaint.setStyle(Paint.Style.FILL);
        this.mSquarePaintFill = new Paint(1);
        this.mSquarePaintFill.setColor(-1);
        this.mSquarePaintFill.setStyle(Paint.Style.FILL);
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i = 0; i < this.GRID_ROWS; ++i) {
            for (int j = 0; j < this.GRID_COLUMNS; ++j) {
                int left = i * 10;
                int top = j * 10;
                int right = left + 10;
                int bottom = top + 10;
                if (this.coordinates[i][j]) {
                    canvas.drawRect(new Rect(left, top, right, bottom), this.mSquarePaint);
                    continue;
                }
                canvas.drawRect(new Rect(left, top, right, bottom), this.mSquarePaintFill);
            }
        }
        Log.i((String)"View", (String)"onDraw finished.");
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.generateRandomCoordinates();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    private void generateRandomCoordinates() {
        int i;
        for (i = 0; i < this.GRID_ROWS; ++i) {
            for (int j = 0; j < this.GRID_COLUMNS; ++j) {
                this.coordinates[i][j] = false;
            }
        }
        for (i = 0; i < 40; ++i) {
            this.coordinates[CrosswordGrid.randInt((int)0, (int)(this.GRID_ROWS - 1))][CrosswordGrid.randInt((int)0, (int)(this.GRID_COLUMNS - 1))] = true;
        }
        this.invalidate();
        this.requestLayout();
    }

    public static int randInt(int min, int max) {
        Random rand = new Random();
        int randomNum = rand.nextInt(max - min + 1) + min;
        return randomNum;
    }

    public class Coordinate {
        int x;
        int y;

        Coordinate(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

