/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.tree.components;

import java.util.Iterator;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.tree.components.TreeView;
import org.apache.tapestry.contrib.tree.model.ITreeDataModel;
import org.apache.tapestry.contrib.tree.model.ITreeModel;
import org.apache.tapestry.contrib.tree.model.ITreeRowSource;
import org.apache.tapestry.contrib.tree.model.TreeRowObject;

public abstract class TreeDataView
extends BaseComponent
implements ITreeRowSource {
    private TreeRowObject m_objTreeRowObject = null;
    private int m_nTreeDeep = -1;

    public TreeDataView() {
        this.initialize();
    }

    public void initialize() {
        this.m_objTreeRowObject = null;
        this.m_nTreeDeep = -1;
    }

    public abstract TreeView getTreeView();

    public void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        Object objExistedTreeModelSource = cycle.getAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource");
        cycle.setAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource", (Object)this);
        TreeView objView = this.getTreeView();
        ITreeModel objTreeModel = objView.getTreeModel();
        ITreeDataModel objTreeDataModel = objTreeModel.getTreeDataModel();
        Object objRoot = objTreeDataModel.getRoot();
        Object objRootUID = objTreeDataModel.getUniqueKey(objRoot, null);
        if (this.getShowRootNode()) {
            this.walkTree(objRoot, objRootUID, 0, objTreeModel, writer, cycle, 4, new int[0], true);
        } else {
            boolean bFirst = true;
            int nChildenCount = objTreeModel.getTreeDataModel().getChildCount(objRoot);
            int nRowPossiotionType = nChildenCount == 1 ? 4 : 1;
            Iterator iter = objTreeModel.getTreeDataModel().getChildren(objRoot);
            while (iter.hasNext()) {
                boolean bChildLast;
                Object objChild = iter.next();
                Object objChildUID = objTreeModel.getTreeDataModel().getUniqueKey(objChild, objRoot);
                boolean bl = bChildLast = !iter.hasNext();
                if (!bFirst) {
                    nRowPossiotionType = bChildLast ? 3 : 2;
                }
                this.walkTree(objChild, objChildUID, 0, objTreeModel, writer, cycle, nRowPossiotionType, new int[0], bChildLast);
                bFirst = false;
            }
        }
        cycle.setAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource", objExistedTreeModelSource);
    }

    public void walkTree(Object objParent, Object objParentUID, int nDepth, ITreeModel objTreeModel, IMarkupWriter writer, IRequestCycle cycle, int nRowPossiotionType, int[] arrConnectImages, boolean bLast) {
        this.m_nTreeDeep = nDepth;
        int nNumberOfChildren = objTreeModel.getTreeDataModel().getChildCount(objParent);
        boolean bLeaf = nNumberOfChildren == 0;
        this.m_objTreeRowObject = new TreeRowObject(objParent, objParentUID, nDepth, bLeaf, nRowPossiotionType, arrConnectImages);
        super.renderComponent(writer, cycle);
        boolean bContain = objTreeModel.getTreeStateModel().isUniqueKeyExpanded(objParentUID);
        if (bContain) {
            int[] arrConnectImagesNew = new int[arrConnectImages.length + 1];
            System.arraycopy(arrConnectImages, 0, arrConnectImagesNew, 0, arrConnectImages.length);
            arrConnectImagesNew[arrConnectImagesNew.length - 1] = bLast ? 1 : 2;
            Iterator iter = objTreeModel.getTreeDataModel().getChildren(objParent);
            while (iter.hasNext()) {
                Object objChild = iter.next();
                Object objChildUID = objTreeModel.getTreeDataModel().getUniqueKey(objChild, objParentUID);
                boolean bChildLast = !iter.hasNext();
                nRowPossiotionType = bChildLast ? 3 : 2;
                this.walkTree(objChild, objChildUID, nDepth + 1, objTreeModel, writer, cycle, nRowPossiotionType, arrConnectImagesNew, bChildLast);
            }
        }
    }

    public int getTreeDeep() {
        return this.m_nTreeDeep;
    }

    public TreeRowObject getTreeRow() {
        return this.getTreeRowObject();
    }

    public TreeRowObject getTreeRowObject() {
        return this.m_objTreeRowObject;
    }

    public void setTreeRowObject(TreeRowObject object) {
        this.m_objTreeRowObject = object;
    }

    public abstract boolean getShowRootNode();
}

