/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.model.simple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry.contrib.table.model.CTableDataModelEvent;
import org.apache.tapestry.contrib.table.model.common.AbstractTableDataModel;
import org.apache.tapestry.contrib.table.model.common.ArrayIterator;

public class SimpleListTableDataModel
extends AbstractTableDataModel
implements Serializable {
    private List m_arrRows;

    public SimpleListTableDataModel(Object[] arrRows) {
        this(Arrays.asList(arrRows));
    }

    public SimpleListTableDataModel(List arrRows) {
        this.m_arrRows = arrRows;
    }

    public SimpleListTableDataModel(Collection arrRows) {
        this.m_arrRows = new ArrayList(arrRows);
    }

    public SimpleListTableDataModel(Iterator objRows) {
        this.m_arrRows = new ArrayList();
        this.addAll(this.m_arrRows, objRows);
    }

    private void addAll(List arrRows, Iterator objRows) {
        while (objRows.hasNext()) {
            arrRows.add(objRows.next());
        }
    }

    public int getRowCount() {
        return this.m_arrRows.size();
    }

    public Object getRow(int nRow) {
        if (nRow < 0 || nRow >= this.m_arrRows.size()) {
            return null;
        }
        return this.m_arrRows.get(nRow);
    }

    public Iterator getRows(int nFrom, int nTo) {
        return new ArrayIterator(this.m_arrRows.toArray(), nFrom, nTo);
    }

    public Iterator getRows() {
        return this.m_arrRows.iterator();
    }

    public void addRow(Object objRow) {
        this.m_arrRows.add(objRow);
        CTableDataModelEvent objEvent = new CTableDataModelEvent();
        this.fireTableDataModelEvent(objEvent);
    }

    public void addRows(Collection arrRows) {
        this.m_arrRows.addAll(arrRows);
        CTableDataModelEvent objEvent = new CTableDataModelEvent();
        this.fireTableDataModelEvent(objEvent);
    }

    public void removeRow(Object objRow) {
        this.m_arrRows.remove(objRow);
        CTableDataModelEvent objEvent = new CTableDataModelEvent();
        this.fireTableDataModelEvent(objEvent);
    }

    public void removeRows(Collection arrRows) {
        this.m_arrRows.removeAll(arrRows);
        CTableDataModelEvent objEvent = new CTableDataModelEvent();
        this.fireTableDataModelEvent(objEvent);
    }
}

