/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.inspector;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.util.io.BinaryDumpOutputStream;

public abstract class ShowEngine
extends BaseComponent
implements PageDetachListener {
    private byte[] serializedEngine;

    public void pageDetached(PageEvent event) {
        this.serializedEngine = null;
    }

    public String getEngineClassName() {
        return this.getPage().getEngine().getClass().getName();
    }

    private byte[] getSerializedEngine() {
        if (this.serializedEngine == null) {
            this.buildSerializedEngine();
        }
        return this.serializedEngine;
    }

    private void buildSerializedEngine() {
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(this.getPage().getEngine());
            this.serializedEngine = bos.toByteArray();
            this.close(oos);
            this.close(bos);
        }
        catch (IOException ex) {
            try {
                throw new ApplicationRuntimeException(Tapestry.getMessage((String)"ShowEngine.could-not-serialize"), (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.close(oos);
                this.close(bos);
                throw throwable;
            }
        }
    }

    private void close(OutputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getEngineByteCount() {
        return this.getSerializedEngine().length;
    }

    public IRender getEngineDumpDelegate() {
        return new IRender(){

            public void render(IMarkupWriter writer, IRequestCycle cycle) {
                ShowEngine.this.dumpSerializedEngine(writer);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSerializedEngine(IMarkupWriter responseWriter) {
        CharArrayWriter writer = null;
        BinaryDumpOutputStream bos = null;
        try {
            writer = new CharArrayWriter();
            bos = new BinaryDumpOutputStream((Writer)writer);
            bos.setBytesPerLine(32);
            bos.write(this.getSerializedEngine());
            bos.close();
            responseWriter.print(writer.toString());
        }
        catch (IOException ex) {
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ex) {}
            }
            if (writer != null) {
                writer.reset();
                writer.close();
            }
        }
    }
}

