/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.localbackend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.std.server.SynchronizationProviderCfg;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.Backend;
import org.opends.server.api.ChangeNotificationListener;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.controls.LDAPAssertionRequestControl;
import org.opends.server.controls.LDAPPostReadRequestControl;
import org.opends.server.controls.LDAPPostReadResponseControl;
import org.opends.server.controls.LDAPPreReadRequestControl;
import org.opends.server.controls.LDAPPreReadResponseControl;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.controls.ProxiedAuthV1Control;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.ModifyOperationWrapper;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.BooleanSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.AccountStatusNotification;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LockManager;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.Privilege;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostResponseModifyOperation;
import org.opends.server.types.operation.PostSynchronizationModifyOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;
import org.opends.server.workflowelement.localbackend.LocalBackendWorkflowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalBackendModifyOperation
extends ModifyOperationWrapper
implements PreOperationModifyOperation,
PostOperationModifyOperation,
PostResponseModifyOperation,
PostSynchronizationModifyOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Backend backend;
    private boolean currentPasswordProvided;
    private boolean enabledStateChanged;
    private boolean isEnabled;
    private boolean noOp;
    private boolean passwordChanged;
    private boolean pwPolicyControlRequested;
    private boolean selfChange;
    private boolean wasLocked;
    private ClientConnection clientConnection;
    private DN entryDN;
    private Entry currentEntry = null;
    private Entry modifiedEntry = null;
    private int numPasswords;
    private LDAPPostReadRequestControl postReadRequest;
    private LDAPPreReadRequestControl preReadRequest;
    private List<AttributeValue> currentPasswords = null;
    private List<AttributeValue> newPasswords = null;
    private List<Modification> modifications;
    private PasswordPolicyErrorType pwpErrorType;
    private PasswordPolicyState pwPolicyState;

    public LocalBackendModifyOperation(ModifyOperation modify) {
        super(modify);
        LocalBackendWorkflowElement.attachLocalOperation(modify, this);
    }

    @Override
    public final Entry getCurrentEntry() {
        return this.currentEntry;
    }

    @Override
    public final List<AttributeValue> getCurrentPasswords() {
        return this.currentPasswords;
    }

    @Override
    public final Entry getModifiedEntry() {
        return this.modifiedEntry;
    }

    @Override
    public final List<AttributeValue> getNewPasswords() {
        return this.newPasswords;
    }

    @Override
    public void addModification(Modification modification) throws DirectoryException {
        this.modifiedEntry.applyModification(modification);
        super.addModification(modification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processLocalModify(Backend backend) throws CanceledOperationException {
        block103: {
            block112: {
                block111: {
                    block110: {
                        block109: {
                            block108: {
                                block107: {
                                    block105: {
                                        block104: {
                                            block102: {
                                                block115: {
                                                    block114: {
                                                        block113: {
                                                            executePostOpPlugins = false;
                                                            this.backend = backend;
                                                            this.clientConnection = this.getClientConnection();
                                                            pluginConfigManager = DirectoryServer.getPluginConfigManager();
                                                            this.checkIfCanceled(false);
                                                            this.entryDN = this.getEntryDN();
                                                            if (this.entryDN == null) break block103;
                                                            this.modifications = this.getModifications();
                                                            if (this.modifications == null) break block103;
                                                            if (!this.modifications.isEmpty()) break block113;
                                                            this.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                                            this.appendErrorMessage(CoreMessages.ERR_MODIFY_NO_MODIFICATIONS.get(String.valueOf(this.entryDN)));
                                                            break block103;
                                                        }
                                                        if (this.isInternalOperation() || !this.clientConnection.mustChangePassword() || (authzDN = this.getAuthorizationDN()) == null || authzDN.equals(this.entryDN)) break block114;
                                                        for (Control c : this.getRequestControls()) {
                                                            if (!c.getOID().equals("1.3.6.1.4.1.42.2.27.8.5.1")) continue;
                                                            this.pwPolicyControlRequested = true;
                                                            this.pwpErrorType = PasswordPolicyErrorType.CHANGE_AFTER_RESET;
                                                            break;
                                                        }
                                                        this.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                        this.appendErrorMessage(CoreMessages.ERR_MODIFY_MUST_CHANGE_PASSWORD.get());
                                                        break block103;
                                                    }
                                                    this.checkIfCanceled(false);
                                                    entryLock = null;
                                                    for (i = 0; i < 3 && (entryLock = LockManager.lockWrite(this.entryDN)) == null; ++i) {
                                                    }
                                                    if (entryLock != null) break block115;
                                                    this.setResultCode(DirectoryServer.getServerErrorResultCode());
                                                    this.appendErrorMessage(CoreMessages.ERR_MODIFY_CANNOT_LOCK_ENTRY.get(String.valueOf(this.entryDN)));
                                                    break block103;
                                                }
                                                try {
                                                    block106: {
                                                        this.checkIfCanceled(false);
                                                        try {
                                                            this.currentEntry = backend.getEntry(this.entryDN);
                                                            if (this.currentEntry == null) {
                                                                block101: {
                                                                    this.setResultCode(ResultCode.NO_SUCH_OBJECT);
                                                                    this.appendErrorMessage(CoreMessages.ERR_MODIFY_NO_SUCH_ENTRY.get(String.valueOf(this.entryDN)));
                                                                    try {
                                                                        for (parentDN = this.entryDN.getParentDNInSuffix(); parentDN != null; parentDN = parentDN.getParentDNInSuffix()) {
                                                                            if (!DirectoryServer.entryExists(parentDN)) continue;
                                                                            this.setMatchedDN(parentDN);
                                                                            break;
                                                                        }
                                                                    }
                                                                    catch (Exception e) {
                                                                        if (!DebugLogger.debugEnabled()) break block101;
                                                                        LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                                                    }
                                                                }
                                                                var9_20 = null;
                                                                i$ = DirectoryServer.getSynchronizationProviders().iterator();
                                                                break block102;
                                                            }
                                                        }
                                                        catch (DirectoryException de) {
                                                            if (DebugLogger.debugEnabled()) {
                                                                LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                            }
                                                            this.setResponseData(de);
                                                            var9_21 = null;
                                                            for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                                                                try {
                                                                    provider.doPostOperation(this);
                                                                }
                                                                catch (DirectoryException de) {
                                                                    if (DebugLogger.debugEnabled()) {
                                                                        LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                    }
                                                                    ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                                                    this.setResponseData(de);
                                                                    break;
                                                                }
                                                            }
                                                            LockManager.unlock(this.entryDN, entryLock);
                                                            break block103;
                                                        }
                                                        {
                                                            this.processRequestControls();
                                                            this.selfChange = this.entryDN.equals(this.getAuthorizationDN());
                                                            this.pwPolicyState = new PasswordPolicyState(this.currentEntry, false, TimeThread.getTime(), true);
                                                        }
                                                        this.modifiedEntry = this.currentEntry.duplicate(false);
                                                        if (!this.noOp) {
                                                            for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                                                                try {
                                                                    result = provider.handleConflictResolution(this);
                                                                    if (result.continueProcessing()) continue;
                                                                    this.setResultCode(result.getResultCode());
                                                                    this.appendErrorMessage(result.getErrorMessage());
                                                                    this.setMatchedDN(result.getMatchedDN());
                                                                    this.setReferralURLs(result.getReferralURLs());
                                                                    break block104;
                                                                }
                                                                catch (DirectoryException de) {
                                                                    if (DebugLogger.debugEnabled()) {
                                                                        LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                    }
                                                                    ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_CONFLICT_RESOLUTION_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                                                    this.setResponseData(de);
                                                                    var9_23 = null;
                                                                    for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                                                                        ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl97:
                                                                        // 1 sources

                                                                        provider.doPostOperation(this);
                                                                        continue;
lbl99:
                                                                        // 1 sources

                                                                        catch (DirectoryException de) {
                                                                            if (DebugLogger.debugEnabled()) {
                                                                                LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                            }
                                                                            ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                                                            this.setResponseData(de);
                                                                            break;
                                                                        }
                                                                    }
                                                                    LockManager.unlock(this.entryDN, entryLock);
                                                                    break block103;
                                                                }
                                                            }
                                                        }
                                                        try {
                                                            this.handleSchemaProcessing();
                                                        }
                                                        catch (DirectoryException de) {
                                                            if (DebugLogger.debugEnabled()) {
                                                                LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                            }
                                                            this.setResponseData(de);
                                                            var9_24 = null;
                                                            for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                                                                ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl118:
                                                                // 1 sources

                                                                provider.doPostOperation(this);
                                                                continue;
lbl120:
                                                                // 1 sources

                                                                catch (DirectoryException de) {
                                                                    if (DebugLogger.debugEnabled()) {
                                                                        LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                    }
                                                                    ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                                                    this.setResponseData(de);
                                                                    break;
                                                                }
                                                            }
                                                            LockManager.unlock(this.entryDN, entryLock);
                                                            break block103;
                                                        }
                                                        if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this)) {
                                                            this.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                                                            this.appendErrorMessage(CoreMessages.ERR_MODIFY_AUTHZ_INSUFFICIENT_ACCESS_RIGHTS.get(String.valueOf(this.entryDN)));
                                                            break block105;
                                                        }
                                                        try {
                                                            this.handleInitialPasswordPolicyProcessing();
                                                            this.wasLocked = false;
                                                            if (!this.passwordChanged) break block106;
                                                            this.performAdditionalPasswordChangedProcessing();
                                                        }
                                                        catch (DirectoryException de) {
                                                            if (DebugLogger.debugEnabled()) {
                                                                LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                            }
                                                            this.setResponseData(de);
                                                            var9_26 = null;
                                                            for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                                                                ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl147:
                                                                // 1 sources

                                                                provider.doPostOperation(this);
                                                                continue;
lbl149:
                                                                // 1 sources

                                                                catch (DirectoryException de) {
                                                                    if (DebugLogger.debugEnabled()) {
                                                                        LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                    }
                                                                    ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                                                    this.setResponseData(de);
                                                                    break;
                                                                }
                                                            }
                                                            LockManager.unlock(this.entryDN, entryLock);
                                                            break block103;
                                                        }
                                                    }
                                                    if (!this.passwordChanged && !this.isInternalOperation() && this.pwPolicyState.mustChangePassword()) {
                                                        this.pwpErrorType = PasswordPolicyErrorType.CHANGE_AFTER_RESET;
                                                        this.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                        this.appendErrorMessage(CoreMessages.ERR_MODIFY_MUST_CHANGE_PASSWORD.get());
                                                        break block107;
                                                    }
                                                    if (DirectoryServer.checkSchema() && !this.isSynchronizationOperation() && !this.modifiedEntry.conformsToSchema(null, false, false, false, invalidReason = new MessageBuilder())) {
                                                        this.setResultCode(ResultCode.OBJECTCLASS_VIOLATION);
                                                        this.appendErrorMessage(CoreMessages.ERR_MODIFY_VIOLATES_SCHEMA.get(String.valueOf(this.entryDN), invalidReason));
                                                        break block108;
                                                    }
                                                    this.checkIfCanceled(false);
                                                    if (!this.isSynchronizationOperation()) {
                                                        executePostOpPlugins = true;
                                                        preOpResult = pluginConfigManager.invokePreOperationModifyPlugins(this);
                                                        if (!preOpResult.continueProcessing()) {
                                                            this.setResultCode(preOpResult.getResultCode());
                                                            this.appendErrorMessage(preOpResult.getErrorMessage());
                                                            this.setMatchedDN(preOpResult.getMatchedDN());
                                                            this.setReferralURLs(preOpResult.getReferralURLs());
                                                            break block109;
                                                        }
                                                    }
                                                    if (backend == null) {
                                                        this.setResultCode(ResultCode.NO_SUCH_OBJECT);
                                                        this.appendErrorMessage(CoreMessages.ERR_MODIFY_NO_BACKEND_FOR_ENTRY.get(String.valueOf(this.entryDN)));
                                                        break block110;
                                                    }
                                                    try {
                                                        try {
                                                            this.checkWritability();
                                                            ** GOTO lbl-1000
                                                        }
                                                        catch (DirectoryException de) {
                                                            if (DebugLogger.debugEnabled()) {
                                                                LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                            }
                                                            this.setResponseData(de);
                                                            var9_31 = null;
                                                            for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                                                                ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl197:
                                                                // 1 sources

                                                                provider.doPostOperation(this);
                                                                continue;
lbl199:
                                                                // 1 sources

                                                                catch (DirectoryException de) {
                                                                    if (DebugLogger.debugEnabled()) {
                                                                        LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                    }
                                                                    ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                                                    this.setResponseData(de);
                                                                    break;
                                                                }
                                                            }
                                                            LockManager.unlock(this.entryDN, entryLock);
                                                        }
                                                    }
                                                    catch (DirectoryException de) {
                                                        if (DebugLogger.debugEnabled()) {
                                                            LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                        }
                                                        this.setResponseData(de);
                                                        var9_34 = null;
                                                        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                                                            ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl215:
                                                            // 1 sources

                                                            provider.doPostOperation(this);
                                                            continue;
lbl217:
                                                            // 1 sources

                                                            catch (DirectoryException de) {
                                                                if (DebugLogger.debugEnabled()) {
                                                                    LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                }
                                                                ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                                                this.setResponseData(de);
                                                                break;
                                                            }
                                                        }
                                                        LockManager.unlock(this.entryDN, entryLock);
                                                    }
                                                    break block103;
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        block116: {
                                                            if (!this.noOp) break block116;
                                                            this.appendErrorMessage(CoreMessages.INFO_MODIFY_NOOP.get());
                                                            this.setResultCode(ResultCode.NO_OPERATION);
                                                            ** GOTO lbl261
                                                        }
                                                        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                                                            result = provider.doPreOperation(this);
                                                            if (result.continueProcessing()) continue;
                                                            this.setResultCode(result.getResultCode());
                                                            this.appendErrorMessage(result.getErrorMessage());
                                                            this.setMatchedDN(result.getMatchedDN());
                                                            this.setReferralURLs(result.getReferralURLs());
                                                            break block111;
                                                            {
                                                                catch (DirectoryException de) {
                                                                    if (DebugLogger.debugEnabled()) {
                                                                        LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                    }
                                                                    ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_PREOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                                                    this.setResponseData(de);
                                                                    var9_33 = null;
                                                                    for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                                                                        ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl248:
                                                                        // 1 sources

                                                                        provider.doPostOperation(this);
                                                                        continue;
lbl250:
                                                                        // 1 sources

                                                                        catch (DirectoryException de) {
                                                                            if (DebugLogger.debugEnabled()) {
                                                                                LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                            }
                                                                            ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                                                            this.setResponseData(de);
                                                                            break;
                                                                        }
                                                                    }
                                                                    LockManager.unlock(this.entryDN, entryLock);
                                                                    break block103;
                                                                }
                                                            }
                                                        }
                                                    }
                                                    {
                                                        backend.replaceEntry(this.modifiedEntry, this);
                                                        if (this.passwordChanged || this.enabledStateChanged || this.wasLocked) {
                                                            this.handleAccountStatusNotifications();
                                                        }
lbl261:
                                                        // 4 sources

                                                        this.handleReadEntryProcessing();
                                                        if (this.noOp) break block112;
                                                        this.setResultCode(ResultCode.SUCCESS);
                                                        break block112;
                                                    }
                                                }
                                                catch (Throwable var8_91) {
                                                    var9_36 = null;
                                                    for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                                                        ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl270:
                                                        // 1 sources

                                                        provider.doPostOperation(this);
                                                        continue;
lbl272:
                                                        // 1 sources

                                                        catch (DirectoryException de) {
                                                            if (DebugLogger.debugEnabled()) {
                                                                LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                            }
                                                            ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                                            this.setResponseData(de);
                                                            break;
                                                        }
                                                    }
                                                    LockManager.unlock(this.entryDN, entryLock);
                                                    throw var8_91;
                                                }
                                            }
                                            while (i$.hasNext()) {
                                                provider = i$.next();
                                                ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl284:
                                                // 1 sources

                                                provider.doPostOperation(this);
                                                continue;
lbl286:
                                                // 1 sources

                                                catch (DirectoryException de) {
                                                    if (DebugLogger.debugEnabled()) {
                                                        LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                    }
                                                    ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                                    this.setResponseData(de);
                                                    break;
                                                }
                                            }
                                            LockManager.unlock(this.entryDN, entryLock);
                                            break block103;
                                        }
                                        var9_22 = null;
                                        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                                            ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl298:
                                            // 1 sources

                                            provider.doPostOperation(this);
                                            continue;
lbl300:
                                            // 1 sources

                                            catch (DirectoryException de) {
                                                if (DebugLogger.debugEnabled()) {
                                                    LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                }
                                                ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                                this.setResponseData(de);
                                                break;
                                            }
                                        }
                                        LockManager.unlock(this.entryDN, entryLock);
                                        break block103;
                                    }
                                    var9_25 = null;
                                    for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                                        ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl312:
                                        // 1 sources

                                        provider.doPostOperation(this);
                                        continue;
lbl314:
                                        // 1 sources

                                        catch (DirectoryException de) {
                                            if (DebugLogger.debugEnabled()) {
                                                LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                            }
                                            ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                            this.setResponseData(de);
                                            break;
                                        }
                                    }
                                    LockManager.unlock(this.entryDN, entryLock);
                                    break block103;
                                }
                                var9_27 = null;
                                for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                                    ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl326:
                                    // 1 sources

                                    provider.doPostOperation(this);
                                    continue;
lbl328:
                                    // 1 sources

                                    catch (DirectoryException de) {
                                        if (DebugLogger.debugEnabled()) {
                                            LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                        }
                                        ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                        this.setResponseData(de);
                                        break;
                                    }
                                }
                                LockManager.unlock(this.entryDN, entryLock);
                                break block103;
                            }
                            var9_28 = null;
                            for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                                ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl340:
                                // 1 sources

                                provider.doPostOperation(this);
                                continue;
lbl342:
                                // 1 sources

                                catch (DirectoryException de) {
                                    if (DebugLogger.debugEnabled()) {
                                        LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                    }
                                    ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                    this.setResponseData(de);
                                    break;
                                }
                            }
                            LockManager.unlock(this.entryDN, entryLock);
                            break block103;
                        }
                        var9_29 = null;
                        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                            ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl354:
                            // 1 sources

                            provider.doPostOperation(this);
                            continue;
lbl356:
                            // 1 sources

                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                                this.setResponseData(de);
                                break;
                            }
                        }
                        LockManager.unlock(this.entryDN, entryLock);
                        break block103;
                    }
                    var9_30 = null;
                    for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                        ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl368:
                        // 1 sources

                        provider.doPostOperation(this);
                        continue;
lbl370:
                        // 1 sources

                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                            this.setResponseData(de);
                            break;
                        }
                    }
                    LockManager.unlock(this.entryDN, entryLock);
                    break block103;
                }
                var9_32 = null;
                for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                    ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl382:
                    // 1 sources

                    provider.doPostOperation(this);
                    continue;
lbl384:
                    // 1 sources

                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                        this.setResponseData(de);
                        break;
                    }
                }
                LockManager.unlock(this.entryDN, entryLock);
                break block103;
            }
            var9_35 = null;
            for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
                ** try [egrp 13[TRYBLOCK] [29 : 1391->1400)] { 
lbl396:
                // 1 sources

                provider.doPostOperation(this);
                continue;
lbl398:
                // 1 sources

                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        LocalBackendModifyOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                    this.setResponseData(de);
                    break;
                }
            }
            LockManager.unlock(this.entryDN, entryLock);
        }
        if (this.pwPolicyControlRequested) {
            this.addResponseControl(new PasswordPolicyResponseControl(null, 0, this.pwpErrorType));
        }
        if (this.isSynchronizationOperation()) {
            if (this.getResultCode() == ResultCode.SUCCESS) {
                pluginConfigManager.invokePostSynchronizationModifyPlugins(this);
            }
        } else if (executePostOpPlugins && !(postOpResult = pluginConfigManager.invokePostOperationModifyPlugins(this)).continueProcessing()) {
            this.setResultCode(postOpResult.getResultCode());
            this.appendErrorMessage(postOpResult.getErrorMessage());
            this.setMatchedDN(postOpResult.getMatchedDN());
            this.setReferralURLs(postOpResult.getReferralURLs());
            return;
        }
        if (this.getResultCode() == ResultCode.SUCCESS) {
            this.notifyChangeListeners();
        }
    }

    private void processRequestControls() throws DirectoryException {
        List<Control> requestControls = this.getRequestControls();
        if (requestControls != null && !requestControls.isEmpty()) {
            for (int i = 0; i < requestControls.size(); ++i) {
                Entry authorizationEntry;
                Control proxyControl;
                Control c = requestControls.get(i);
                String oid = c.getOID();
                if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this.entryDN, this, c)) {
                    throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(oid));
                }
                if (oid.equals("1.3.6.1.1.12")) {
                    LDAPAssertionRequestControl assertControl;
                    if (c instanceof LDAPAssertionRequestControl) {
                        assertControl = (LDAPAssertionRequestControl)c;
                    } else {
                        try {
                            assertControl = LDAPAssertionRequestControl.decodeControl(c);
                            requestControls.set(i, assertControl);
                        }
                        catch (LDAPException le) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, le);
                            }
                            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject());
                        }
                    }
                    try {
                        SearchFilter filter = assertControl.getSearchFilter();
                        if (filter.matchesEntry(this.currentEntry)) continue;
                        throw new DirectoryException(ResultCode.ASSERTION_FAILED, CoreMessages.ERR_MODIFY_ASSERTION_FAILED.get(String.valueOf(this.entryDN)));
                    }
                    catch (DirectoryException de) {
                        if (de.getResultCode() == ResultCode.ASSERTION_FAILED) {
                            throw de;
                        }
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_MODIFY_CANNOT_PROCESS_ASSERTION_FILTER.get(String.valueOf(this.entryDN), de.getMessageObject()));
                    }
                }
                if (oid.equals("1.3.6.1.4.1.4203.1.10.2")) {
                    this.noOp = true;
                    continue;
                }
                if (oid.equals("1.3.6.1.1.13.1")) {
                    if (c instanceof LDAPPreReadRequestControl) {
                        this.preReadRequest = (LDAPPreReadRequestControl)c;
                        continue;
                    }
                    try {
                        this.preReadRequest = LDAPPreReadRequestControl.decodeControl(c);
                        requestControls.set(i, this.preReadRequest);
                        continue;
                    }
                    catch (LDAPException le) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, le);
                        }
                        throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject());
                    }
                }
                if (oid.equals("1.3.6.1.1.13.2")) {
                    if (c instanceof LDAPPostReadRequestControl) {
                        this.postReadRequest = (LDAPPostReadRequestControl)c;
                        continue;
                    }
                    try {
                        this.postReadRequest = LDAPPostReadRequestControl.decodeControl(c);
                        requestControls.set(i, this.postReadRequest);
                        continue;
                    }
                    catch (LDAPException le) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, le);
                        }
                        throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject());
                    }
                }
                if (oid.equals("2.16.840.1.113730.3.4.12")) {
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    if (c instanceof ProxiedAuthV1Control) {
                        proxyControl = (ProxiedAuthV1Control)c;
                    } else {
                        try {
                            proxyControl = ProxiedAuthV1Control.decodeControl(c);
                        }
                        catch (LDAPException le) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, le);
                            }
                            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject());
                        }
                    }
                    authorizationEntry = ((ProxiedAuthV1Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.18")) {
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    if (c instanceof ProxiedAuthV2Control) {
                        proxyControl = (ProxiedAuthV2Control)c;
                    } else {
                        try {
                            proxyControl = ProxiedAuthV2Control.decodeControl(c);
                        }
                        catch (LDAPException le) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, le);
                            }
                            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject());
                        }
                    }
                    authorizationEntry = ((ProxiedAuthV2Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.42.2.27.8.5.1")) {
                    this.pwPolicyControlRequested = true;
                    continue;
                }
                if (!c.isCritical() || this.backend != null && this.backend.supportsControl(oid)) continue;
                throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, CoreMessages.ERR_MODIFY_UNSUPPORTED_CRITICAL_CONTROL.get(String.valueOf(this.entryDN), oid));
            }
        }
    }

    private void handleSchemaProcessing() throws DirectoryException {
        for (Modification m : this.modifications) {
            Attribute a = m.getAttribute();
            AttributeType t = a.getAttributeType();
            if (t.isNoUserModification() && !this.isInternalOperation() && !this.isSynchronizationOperation() && !m.isInternal()) {
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_ATTR_IS_NO_USER_MOD.get(String.valueOf(this.entryDN), a.getName()));
            }
            if (t.isObsolete() && a.hasValue() && m.getModificationType() != ModificationType.DELETE && !this.isInternalOperation() && !this.isSynchronizationOperation() && !m.isInternal()) {
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_ATTR_IS_OBSOLETE.get(String.valueOf(this.entryDN), a.getName()));
            }
            if (t.hasName("ds-privilege-name") && !this.clientConnection.hasPrivilege(Privilege.PRIVILEGE_CHANGE, this)) {
                throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_MODIFY_CHANGE_PRIVILEGE_INSUFFICIENT_PRIVILEGES.get());
            }
            boolean isPassword = t.equals(this.pwPolicyState.getPolicy().getPasswordAttribute());
            if (isPassword) continue;
            AttributeType disabledAttr = DirectoryServer.getAttributeType("ds-pwp-account-disabled", true);
            if (t.equals(disabledAttr)) {
                this.enabledStateChanged = true;
                for (AttributeValue v : a.getValues()) {
                    try {
                        this.isEnabled = !BooleanSyntax.decodeBooleanValue(v.getNormalizedValue());
                    }
                    catch (DirectoryException de) {
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, CoreMessages.ERR_MODIFY_INVALID_DISABLED_VALUE.get("ds-pwp-account-disabled", String.valueOf(de.getMessageObject())), de);
                    }
                }
            }
            switch (m.getModificationType()) {
                case ADD: {
                    this.processInitialAddSchema(a);
                    break;
                }
                case DELETE: {
                    this.processInitialDeleteSchema(a);
                    break;
                }
                case REPLACE: {
                    this.processInitialReplaceSchema(a);
                    break;
                }
                case INCREMENT: {
                    this.processInitialIncrementSchema(a);
                }
            }
        }
    }

    private void handleInitialPasswordPolicyProcessing() throws DirectoryException {
        this.currentPasswordProvided = false;
        this.isEnabled = true;
        this.enabledStateChanged = false;
        this.numPasswords = this.currentEntry.hasAttribute(this.pwPolicyState.getPolicy().getPasswordAttribute()) ? 1 : 0;
        if (!this.isInternalOperation() && !this.isSynchronizationOperation()) {
            for (Modification m : this.modifications) {
                AttributeType t = m.getAttribute().getAttributeType();
                boolean isPassword = t.equals(this.pwPolicyState.getPolicy().getPasswordAttribute());
                if (!isPassword) continue;
                this.passwordChanged = true;
                if (this.selfChange || this.clientConnection.hasPrivilege(Privilege.PASSWORD_RESET, this)) break;
                this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED;
                throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_MODIFY_PWRESET_INSUFFICIENT_PRIVILEGES.get());
            }
        }
        for (Modification m : this.modifications) {
            Attribute a = m.getAttribute();
            AttributeType t = a.getAttributeType();
            boolean isPassword = t.equals(this.pwPolicyState.getPolicy().getPasswordAttribute());
            if (!isPassword) continue;
            if (!this.isSynchronizationOperation()) {
                if (!this.isInternalOperation()) {
                    if (a.hasOptions()) {
                        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_PASSWORDS_CANNOT_HAVE_OPTIONS.get());
                    }
                    if (this.selfChange && !this.pwPolicyState.getPolicy().allowUserPasswordChanges()) {
                        this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED;
                        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_NO_USER_PW_CHANGES.get());
                    }
                    if (this.pwPolicyState.getPolicy().requireSecurePasswordChanges() && !this.clientConnection.isSecure()) {
                        this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED;
                        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_REQUIRE_SECURE_CHANGES.get());
                    }
                    if (this.selfChange && this.pwPolicyState.isWithinMinimumAge()) {
                        this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_TOO_YOUNG;
                        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_WITHIN_MINIMUM_AGE.get());
                    }
                }
                boolean isAdd = m.getModificationType() == ModificationType.ADD;
                LinkedHashSet<AttributeValue> pwValues = a.getValues();
                LinkedHashSet<AttributeValue> encodedValues = new LinkedHashSet<AttributeValue>();
                switch (m.getModificationType()) {
                    case ADD: 
                    case REPLACE: {
                        this.processInitialAddOrReplacePW(isAdd, pwValues, encodedValues, a);
                        break;
                    }
                    case DELETE: {
                        this.processInitialDeletePW(pwValues, encodedValues, a);
                        break;
                    }
                    default: {
                        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_INVALID_MOD_TYPE_FOR_PASSWORD.get(String.valueOf((Object)m.getModificationType()), a.getName()));
                    }
                }
            }
            switch (m.getModificationType()) {
                case ADD: {
                    this.processInitialAddSchema(a);
                    break;
                }
                case DELETE: {
                    this.processInitialDeleteSchema(a);
                    break;
                }
                case REPLACE: {
                    this.processInitialReplaceSchema(a);
                    break;
                }
                case INCREMENT: {
                    this.processInitialIncrementSchema(a);
                }
            }
        }
    }

    private void processInitialAddOrReplacePW(boolean isAdd, LinkedHashSet<AttributeValue> pwValues, LinkedHashSet<AttributeValue> encodedValues, Attribute pwAttr) throws DirectoryException {
        int passwordsToAdd = pwValues.size();
        this.numPasswords = isAdd ? (this.numPasswords += passwordsToAdd) : passwordsToAdd;
        if (!this.isInternalOperation() && !this.pwPolicyState.getPolicy().allowMultiplePasswordValues() && passwordsToAdd > 1) {
            this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED;
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_MULTIPLE_VALUES_NOT_ALLOWED.get());
        }
        for (AttributeValue v : pwValues) {
            if (this.pwPolicyState.passwordIsPreEncoded(v.getValue())) {
                if (!this.isInternalOperation() && !this.pwPolicyState.getPolicy().allowPreEncodedPasswords()) {
                    this.pwpErrorType = PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY;
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_NO_PREENCODED_PASSWORDS.get());
                }
                encodedValues.add(v);
                continue;
            }
            if (isAdd && this.pwPolicyState.passwordMatches(v.getValue())) {
                this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_IN_HISTORY;
                throw new DirectoryException(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, CoreMessages.ERR_MODIFY_PASSWORD_EXISTS.get());
            }
            if (this.newPasswords == null) {
                this.newPasswords = new LinkedList<AttributeValue>();
            }
            this.newPasswords.add(v);
            for (ByteString s : this.pwPolicyState.encodePassword(v.getValue())) {
                encodedValues.add(new AttributeValue(pwAttr.getAttributeType(), s));
            }
        }
        pwAttr.setValues(encodedValues);
    }

    private void processInitialDeletePW(LinkedHashSet<AttributeValue> pwValues, LinkedHashSet<AttributeValue> encodedValues, Attribute pwAttr) throws DirectoryException {
        for (AttributeValue v : pwValues) {
            if (this.pwPolicyState.passwordIsPreEncoded(v.getValue())) {
                if (!this.isInternalOperation() && this.selfChange) {
                    this.pwpErrorType = PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY;
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_NO_PREENCODED_PASSWORDS.get());
                }
                encodedValues.add(v);
                continue;
            }
            List<Attribute> attrList = this.currentEntry.getAttribute(pwAttr.getAttributeType());
            if (attrList == null || attrList.isEmpty()) {
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_NO_EXISTING_VALUES.get());
            }
            boolean found = false;
            for (Attribute attr : attrList) {
                for (AttributeValue av : attr.getValues()) {
                    PasswordStorageScheme scheme;
                    CharSequence[] compoenents;
                    if (this.pwPolicyState.getPolicy().usesAuthPasswordSyntax()) {
                        if (AuthPasswordSyntax.isEncoded(av.getValue())) {
                            compoenents = AuthPasswordSyntax.decodeAuthPassword(av.getStringValue());
                            scheme = DirectoryServer.getAuthPasswordStorageScheme(((StringBuilder)compoenents[0]).toString());
                            if (scheme == null || !scheme.authPasswordMatches(v.getValue(), ((StringBuilder)compoenents[1]).toString(), ((StringBuilder)compoenents[2]).toString())) continue;
                            encodedValues.add(av);
                            found = true;
                            continue;
                        }
                        if (!av.equals(v)) continue;
                        encodedValues.add(v);
                        found = true;
                        continue;
                    }
                    if (UserPasswordSyntax.isEncoded(av.getValue())) {
                        compoenents = UserPasswordSyntax.decodeUserPassword(av.getStringValue());
                        scheme = DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase((String)compoenents[0]));
                        if (scheme == null || !scheme.passwordMatches(v.getValue(), new ASN1OctetString((String)compoenents[1]))) continue;
                        encodedValues.add(av);
                        found = true;
                        continue;
                    }
                    if (!av.equals(v)) continue;
                    encodedValues.add(v);
                    found = true;
                }
            }
            if (found) {
                if (this.currentPasswords == null) {
                    this.currentPasswords = new LinkedList<AttributeValue>();
                }
                this.currentPasswords.add(v);
                --this.numPasswords;
            } else {
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_INVALID_PASSWORD.get());
            }
            this.currentPasswordProvided = true;
        }
        pwAttr.setValues(encodedValues);
    }

    private void processInitialAddSchema(Attribute attr) throws DirectoryException {
        LinkedHashSet<AttributeValue> newValues = attr.getValues();
        if (newValues == null || newValues.isEmpty()) {
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_MODIFY_ADD_NO_VALUES.get(String.valueOf(this.entryDN), attr.getName()));
        }
        if (DirectoryServer.checkSchema() && !this.isSynchronizationOperation()) {
            MessageBuilder invalidReason;
            AcceptRejectWarn syntaxPolicy = DirectoryServer.getSyntaxEnforcementPolicy();
            AttributeSyntax syntax = attr.getAttributeType().getSyntax();
            if (syntaxPolicy == AcceptRejectWarn.REJECT) {
                invalidReason = new MessageBuilder();
                for (AttributeValue v : newValues) {
                    if (syntax.valueIsAcceptable(v.getValue(), invalidReason)) continue;
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, CoreMessages.ERR_MODIFY_ADD_INVALID_SYNTAX.get(String.valueOf(this.entryDN), attr.getName(), v.getStringValue(), invalidReason));
                }
            } else if (syntaxPolicy == AcceptRejectWarn.WARN) {
                invalidReason = new MessageBuilder();
                for (AttributeValue v : newValues) {
                    if (syntax.valueIsAcceptable(v.getValue(), invalidReason)) continue;
                    this.setResultCode(ResultCode.INVALID_ATTRIBUTE_SYNTAX);
                    ErrorLogger.logError(CoreMessages.ERR_MODIFY_ADD_INVALID_SYNTAX.get(String.valueOf(this.entryDN), attr.getName(), v.getStringValue(), invalidReason));
                    invalidReason = new MessageBuilder();
                }
            }
        }
        if (attr.getAttributeType().isObjectClassType()) {
            this.modifiedEntry.addObjectClasses(newValues);
        } else {
            LinkedList<AttributeValue> duplicateValues = new LinkedList<AttributeValue>();
            this.modifiedEntry.addAttribute(attr, duplicateValues);
            if (!duplicateValues.isEmpty()) {
                StringBuilder buffer = new StringBuilder();
                Iterator iterator = duplicateValues.iterator();
                buffer.append(((AttributeValue)iterator.next()).getStringValue());
                while (iterator.hasNext()) {
                    buffer.append(", ");
                    buffer.append(((AttributeValue)iterator.next()).getStringValue());
                }
                throw new DirectoryException(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, CoreMessages.ERR_MODIFY_ADD_DUPLICATE_VALUE.get(String.valueOf(this.entryDN), attr.getName(), buffer));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processInitialDeleteSchema(Attribute attr) throws DirectoryException {
        LinkedList<AttributeValue> missingValues = new LinkedList<AttributeValue>();
        boolean attrExists = this.modifiedEntry.removeAttribute(attr, missingValues);
        if (!attrExists) throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, CoreMessages.ERR_MODIFY_DELETE_NO_SUCH_ATTR.get(String.valueOf(this.entryDN), attr.getName()));
        if (missingValues.isEmpty()) {
            AttributeType t = attr.getAttributeType();
            RDN rdn = this.modifiedEntry.getDN().getRDN();
            if (rdn == null || !rdn.hasAttributeType(t) || this.modifiedEntry.hasValue(t, attr.getOptions(), rdn.getAttributeValue(t))) return;
            throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_RDN, CoreMessages.ERR_MODIFY_DELETE_RDN_ATTR.get(String.valueOf(this.entryDN), attr.getName()));
        }
        StringBuilder buffer = new StringBuilder();
        Iterator iterator = missingValues.iterator();
        buffer.append(((AttributeValue)iterator.next()).getStringValue());
        while (iterator.hasNext()) {
            buffer.append(", ");
            buffer.append(((AttributeValue)iterator.next()).getStringValue());
        }
        throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, CoreMessages.ERR_MODIFY_DELETE_MISSING_VALUES.get(String.valueOf(this.entryDN), attr.getName(), buffer));
    }

    private void processInitialReplaceSchema(Attribute attr) throws DirectoryException {
        RDN rdn;
        RDN rdn2;
        List<Object> attrList;
        if (attr.getAttributeType().isObjectClassType()) {
            this.modifiedEntry.setObjectClasses(attr.getValues());
            return;
        }
        AttributeType t = attr.getAttributeType();
        if (!attr.hasValue()) {
            this.modifiedEntry.removeAttribute(t, attr.getOptions());
            RDN rdn3 = this.modifiedEntry.getDN().getRDN();
            if (rdn3 != null && rdn3.hasAttributeType(t) && !this.modifiedEntry.hasValue(t, attr.getOptions(), rdn3.getAttributeValue(t))) {
                throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_RDN, CoreMessages.ERR_MODIFY_DELETE_RDN_ATTR.get(String.valueOf(this.entryDN), attr.getName()));
            }
            return;
        }
        LinkedHashSet<AttributeValue> newValues = attr.getValues();
        if (DirectoryServer.checkSchema() && !this.isSynchronizationOperation()) {
            MessageBuilder invalidReason;
            AcceptRejectWarn syntaxPolicy = DirectoryServer.getSyntaxEnforcementPolicy();
            AttributeSyntax syntax = t.getSyntax();
            if (syntaxPolicy == AcceptRejectWarn.REJECT) {
                invalidReason = new MessageBuilder();
                for (AttributeValue v : newValues) {
                    if (syntax.valueIsAcceptable(v.getValue(), invalidReason)) continue;
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, CoreMessages.ERR_MODIFY_REPLACE_INVALID_SYNTAX.get(String.valueOf(this.entryDN), attr.getName(), v.getStringValue(), invalidReason));
                }
            } else if (syntaxPolicy == AcceptRejectWarn.WARN) {
                invalidReason = new MessageBuilder();
                for (AttributeValue v : newValues) {
                    if (syntax.valueIsAcceptable(v.getValue(), invalidReason)) continue;
                    this.setResultCode(ResultCode.INVALID_ATTRIBUTE_SYNTAX);
                    ErrorLogger.logError(CoreMessages.ERR_MODIFY_REPLACE_INVALID_SYNTAX.get(String.valueOf(this.entryDN), attr.getName(), v.getStringValue(), invalidReason));
                    invalidReason = new MessageBuilder();
                }
            }
        }
        if (!attr.hasOptions()) {
            attrList = new ArrayList(1);
            attrList.add(attr);
            this.modifiedEntry.putAttribute(t, attrList);
            rdn2 = this.modifiedEntry.getDN().getRDN();
            if (rdn2 != null && rdn2.hasAttributeType(t) && !this.modifiedEntry.hasValue(t, attr.getOptions(), rdn2.getAttributeValue(t))) {
                throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_RDN, CoreMessages.ERR_MODIFY_DELETE_RDN_ATTR.get(String.valueOf(this.entryDN), attr.getName()));
            }
            return;
        }
        attrList = this.modifiedEntry.getAttribute(t);
        if (attrList == null || attrList.isEmpty()) {
            attrList = new ArrayList(1);
            attrList.add(attr);
            this.modifiedEntry.putAttribute(t, attrList);
            rdn2 = this.modifiedEntry.getDN().getRDN();
            if (rdn2 != null && rdn2.hasAttributeType(t) && !this.modifiedEntry.hasValue(t, attr.getOptions(), rdn2.getAttributeValue(t))) {
                throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_RDN, CoreMessages.ERR_MODIFY_DELETE_RDN_ATTR.get(String.valueOf(this.entryDN), attr.getName()));
            }
            return;
        }
        boolean found = false;
        for (int i = 0; i < attrList.size(); ++i) {
            if (!((Attribute)attrList.get(i)).optionsEqual(attr.getOptions())) continue;
            attrList.set(i, attr);
            found = true;
            break;
        }
        if (!found) {
            attrList.add(attr);
        }
        if ((rdn = this.modifiedEntry.getDN().getRDN()) != null && rdn.hasAttributeType(t) && !this.modifiedEntry.hasValue(t, attr.getOptions(), rdn.getAttributeValue(t))) {
            throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_RDN, CoreMessages.ERR_MODIFY_DELETE_RDN_ATTR.get(String.valueOf(this.entryDN), attr.getName()));
        }
    }

    private void processInitialIncrementSchema(Attribute attr) throws DirectoryException {
        long incrementValue;
        AttributeType t = attr.getAttributeType();
        RDN rdn = this.modifiedEntry.getDN().getRDN();
        if (rdn != null && rdn.hasAttributeType(t)) {
            throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_RDN, CoreMessages.ERR_MODIFY_INCREMENT_RDN.get(String.valueOf(this.entryDN), attr.getName()));
        }
        LinkedHashSet<AttributeValue> values = attr.getValues();
        if (values == null || values.isEmpty()) {
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_MODIFY_INCREMENT_REQUIRES_VALUE.get(String.valueOf(this.entryDN), attr.getName()));
        }
        if (values.size() > 1) {
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_MODIFY_INCREMENT_REQUIRES_SINGLE_VALUE.get(String.valueOf(this.entryDN), attr.getName()));
        }
        AttributeValue v = (AttributeValue)values.iterator().next();
        try {
            incrementValue = Long.parseLong(v.getNormalizedStringValue());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, CoreMessages.ERR_MODIFY_INCREMENT_PROVIDED_VALUE_NOT_INTEGER.get(String.valueOf(this.entryDN), attr.getName(), v.getStringValue()), e);
        }
        List<Attribute> attrList = this.modifiedEntry.getAttribute(t, attr.getOptions());
        if (attrList == null || attrList.isEmpty()) {
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, CoreMessages.ERR_MODIFY_INCREMENT_REQUIRES_EXISTING_VALUE.get(String.valueOf(this.entryDN), attr.getName()));
        }
        boolean updated = false;
        for (Attribute a : attrList) {
            LinkedHashSet<AttributeValue> valueList = a.getValues();
            if (valueList == null || valueList.isEmpty()) continue;
            LinkedHashSet<AttributeValue> newValueList = new LinkedHashSet<AttributeValue>(valueList.size());
            for (AttributeValue existingValue : valueList) {
                long newIntValue;
                try {
                    long existingIntValue = Long.parseLong(existingValue.getStringValue());
                    newIntValue = existingIntValue + incrementValue;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, CoreMessages.ERR_MODIFY_INCREMENT_REQUIRES_INTEGER_VALUE.get(String.valueOf(this.entryDN), a.getName(), existingValue.getStringValue()), e);
                }
                ASN1OctetString newValue = new ASN1OctetString(String.valueOf(newIntValue));
                newValueList.add(new AttributeValue(t, (ByteString)newValue));
            }
            a.setValues(newValueList);
            updated = true;
        }
        if (!updated) {
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, CoreMessages.ERR_MODIFY_INCREMENT_REQUIRES_EXISTING_VALUE.get(String.valueOf(this.entryDN), attr.getName()));
        }
    }

    public void performAdditionalPasswordChangedProcessing() throws DirectoryException {
        if (this.selfChange && this.pwPolicyState.getPolicy().requireCurrentPassword() && !this.currentPasswordProvided) {
            this.pwpErrorType = PasswordPolicyErrorType.MUST_SUPPLY_OLD_PASSWORD;
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_PW_CHANGE_REQUIRES_CURRENT_PW.get());
        }
        if (this.numPasswords > 1 && !this.pwPolicyState.getPolicy().allowMultiplePasswordValues()) {
            this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED;
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_MULTIPLE_PASSWORDS_NOT_ALLOWED.get());
        }
        if ((this.selfChange || !this.pwPolicyState.getPolicy().skipValidationForAdministrators()) && this.newPasswords != null) {
            HashSet<ByteString> clearPasswords = new HashSet<ByteString>();
            clearPasswords.addAll(this.pwPolicyState.getClearPasswords());
            if (this.currentPasswords != null) {
                if (clearPasswords.isEmpty()) {
                    for (AttributeValue v : this.currentPasswords) {
                        clearPasswords.add(v.getValue());
                    }
                } else {
                    for (AttributeValue v : this.currentPasswords) {
                        ByteString pw = v.getValue();
                        boolean found = false;
                        for (ByteString s : clearPasswords) {
                            if (!Arrays.equals(s.value(), pw.value())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        clearPasswords.add(pw);
                    }
                }
            }
            for (AttributeValue v : this.newPasswords) {
                MessageBuilder invalidReason = new MessageBuilder();
                if (this.pwPolicyState.passwordIsAcceptable(this, this.modifiedEntry, v.getValue(), clearPasswords, invalidReason)) continue;
                this.pwpErrorType = PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY;
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_PW_VALIDATION_FAILED.get(invalidReason));
            }
        }
        if (this.pwPolicyState.maintainHistory() && this.newPasswords != null) {
            for (AttributeValue v : this.newPasswords) {
                if (!this.pwPolicyState.isPasswordInHistory(v.getValue()) || !this.selfChange && this.pwPolicyState.getPolicy().skipValidationForAdministrators()) continue;
                this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_IN_HISTORY;
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_PW_IN_HISTORY.get());
            }
            this.pwPolicyState.updatePasswordHistory();
        }
        this.wasLocked = this.pwPolicyState.lockedDueToIdleInterval() || this.pwPolicyState.lockedDueToMaximumResetAge() || this.pwPolicyState.lockedDueToFailures();
        this.pwPolicyState.setPasswordChangedTime();
        this.pwPolicyState.clearFailureLockout();
        this.pwPolicyState.clearGraceLoginTimes();
        this.pwPolicyState.clearWarnedTime();
        if (this.pwPolicyState.getPolicy().forceChangeOnAdd() || this.pwPolicyState.getPolicy().forceChangeOnReset()) {
            if (this.selfChange) {
                this.pwPolicyState.setMustChangePassword(false);
            } else {
                if (this.pwpErrorType == null && this.pwPolicyState.getPolicy().forceChangeOnReset()) {
                    this.pwpErrorType = PasswordPolicyErrorType.CHANGE_AFTER_RESET;
                }
                this.pwPolicyState.setMustChangePassword(this.pwPolicyState.getPolicy().forceChangeOnReset());
            }
        }
        if (this.pwPolicyState.getPolicy().getRequireChangeByTime() > 0L) {
            this.pwPolicyState.setRequiredChangeTime();
        }
        this.modifications.addAll(this.pwPolicyState.getModifications());
        this.modifiedEntry.applyModifications(this.pwPolicyState.getModifications());
    }

    private void checkWritability() throws DirectoryException {
        if (!this.backend.isPrivateBackend()) {
            switch (DirectoryServer.getWritabilityMode()) {
                case DISABLED: {
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_SERVER_READONLY.get(String.valueOf(this.entryDN)));
                }
                case INTERNAL_ONLY: {
                    if (this.isInternalOperation() || this.isSynchronizationOperation()) break;
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_SERVER_READONLY.get(String.valueOf(this.entryDN)));
                }
            }
            switch (this.backend.getWritabilityMode()) {
                case DISABLED: {
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_BACKEND_READONLY.get(String.valueOf(this.entryDN)));
                }
                case INTERNAL_ONLY: {
                    if (this.isInternalOperation() && !this.isSynchronizationOperation()) break;
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_BACKEND_READONLY.get(String.valueOf(this.entryDN)));
                }
            }
        }
    }

    private void handleAccountStatusNotifications() {
        Message message;
        if (this.passwordChanged) {
            if (this.selfChange) {
                AuthenticationInfo authInfo = this.clientConnection.getAuthenticationInfo();
                if (authInfo.getAuthenticationDN().equals(this.modifiedEntry.getDN())) {
                    this.clientConnection.setMustChangePassword(false);
                }
                Message message2 = CoreMessages.INFO_MODIFY_PASSWORD_CHANGED.get();
                this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_CHANGED, this.modifiedEntry, message2, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, this.currentPasswords, this.newPasswords));
            } else {
                message = CoreMessages.INFO_MODIFY_PASSWORD_RESET.get();
                this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_RESET, this.modifiedEntry, message, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, this.currentPasswords, this.newPasswords));
            }
        }
        if (this.enabledStateChanged) {
            if (this.isEnabled) {
                message = CoreMessages.INFO_MODIFY_ACCOUNT_ENABLED.get();
                this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_ENABLED, this.modifiedEntry, message, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, null, null));
            } else {
                message = CoreMessages.INFO_MODIFY_ACCOUNT_DISABLED.get();
                this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_DISABLED, this.modifiedEntry, message, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, null, null));
            }
        }
        if (this.wasLocked) {
            message = CoreMessages.INFO_MODIFY_ACCOUNT_UNLOCKED.get();
            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_UNLOCKED, this.modifiedEntry, message, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, null, null));
        }
    }

    private void handleReadEntryProcessing() {
        Control responseControl;
        SearchResultEntry searchEntry;
        AttributeType attrType;
        Iterator<AttributeType> iterator;
        Entry entry;
        if (this.preReadRequest != null) {
            entry = this.currentEntry.duplicate(true);
            if (!this.preReadRequest.allowsAttribute(DirectoryServer.getObjectClassAttributeType())) {
                entry.removeAttribute(DirectoryServer.getObjectClassAttributeType());
            }
            if (!this.preReadRequest.returnAllUserAttributes()) {
                iterator = entry.getUserAttributes().keySet().iterator();
                while (iterator.hasNext()) {
                    attrType = iterator.next();
                    if (this.preReadRequest.allowsAttribute(attrType)) continue;
                    iterator.remove();
                }
            }
            if (!this.preReadRequest.returnAllOperationalAttributes()) {
                iterator = entry.getOperationalAttributes().keySet().iterator();
                while (iterator.hasNext()) {
                    attrType = iterator.next();
                    if (this.preReadRequest.allowsAttribute(attrType)) continue;
                    iterator.remove();
                }
            }
            searchEntry = new SearchResultEntry(entry);
            responseControl = new LDAPPreReadResponseControl(this.preReadRequest.getOID(), this.preReadRequest.isCritical(), searchEntry);
            this.getResponseControls().add(responseControl);
        }
        if (this.postReadRequest != null) {
            entry = this.modifiedEntry.duplicate(true);
            if (!this.postReadRequest.allowsAttribute(DirectoryServer.getObjectClassAttributeType())) {
                entry.removeAttribute(DirectoryServer.getObjectClassAttributeType());
            }
            if (!this.postReadRequest.returnAllUserAttributes()) {
                iterator = entry.getUserAttributes().keySet().iterator();
                while (iterator.hasNext()) {
                    attrType = iterator.next();
                    if (this.postReadRequest.allowsAttribute(attrType)) continue;
                    iterator.remove();
                }
            }
            if (!this.postReadRequest.returnAllOperationalAttributes()) {
                iterator = entry.getOperationalAttributes().keySet().iterator();
                while (iterator.hasNext()) {
                    attrType = iterator.next();
                    if (this.postReadRequest.allowsAttribute(attrType)) continue;
                    iterator.remove();
                }
            }
            searchEntry = new SearchResultEntry(entry);
            responseControl = new LDAPPostReadResponseControl(this.postReadRequest.getOID(), this.postReadRequest.isCritical(), searchEntry);
            this.getResponseControls().add(responseControl);
        }
    }

    private void notifyChangeListeners() {
        for (ChangeNotificationListener changeListener : DirectoryServer.getChangeNotificationListeners()) {
            try {
                changeListener.handleModifyOperation(this, this.currentEntry, this.modifiedEntry);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = CoreMessages.ERR_MODIFY_ERROR_NOTIFYING_CHANGE_LISTENER.get(StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message);
            }
        }
    }
}

