/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.cli;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.ldap.InitialLdapContext;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.admin.ads.util.OpendsCertificateException;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.UtilityMessages;
import org.opends.quicksetup.util.Utils;
import org.opends.server.tools.ClientException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.LDAPConnectionConsoleInteraction;
import org.opends.server.util.cli.ValidationCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConsoleApplication {
    private final PrintStream err;
    private final BufferedReader in;
    private final PrintStream out;
    protected static final int CONFIRMATION_MAX_TRIES = 5;

    protected ConsoleApplication(BufferedReader in, PrintStream out, PrintStream err) {
        this.in = in != null ? in : new BufferedReader(new NullReader());
        this.out = out != null ? out : NullOutputStream.printStream();
        this.err = err != null ? out : NullOutputStream.printStream();
    }

    protected ConsoleApplication(InputStream in, OutputStream out, OutputStream err) {
        this.in = in != null ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new NullReader());
        this.out = out != null ? new PrintStream(out) : NullOutputStream.printStream();
        this.err = err != null ? new PrintStream(err) : NullOutputStream.printStream();
    }

    public final boolean confirmAction(Message prompt, final boolean defaultValue) throws CLIException {
        if (!this.isInteractive()) {
            return defaultValue;
        }
        final Message yes = UtilityMessages.INFO_GENERAL_YES.get();
        final Message no = UtilityMessages.INFO_GENERAL_NO.get();
        final Message errMsg = UtilityMessages.ERR_CONSOLE_APP_CONFIRM.get(yes, no);
        prompt = UtilityMessages.INFO_MENU_PROMPT_CONFIRM.get(prompt, yes, no, defaultValue ? yes : no);
        ValidationCallback<Boolean> validator = new ValidationCallback<Boolean>(){

            @Override
            public Boolean validate(ConsoleApplication app, String input) {
                String ninput = input.toLowerCase().trim();
                if (ninput.length() == 0) {
                    return defaultValue;
                }
                if (no.toString().startsWith(ninput)) {
                    return false;
                }
                if (yes.toString().startsWith(ninput)) {
                    return true;
                }
                app.println();
                app.println(errMsg);
                app.println();
                return null;
            }
        };
        return this.readValidatedInput(prompt, validator, 5);
    }

    public final PrintStream getErrorStream() {
        return this.err;
    }

    public final BufferedReader getInputStream() {
        return this.in;
    }

    public final PrintStream getOutputStream() {
        return this.out;
    }

    public abstract boolean isAdvancedMode();

    public abstract boolean isInteractive();

    public abstract boolean isMenuDrivenMode();

    public abstract boolean isQuiet();

    public abstract boolean isScriptFriendly();

    public abstract boolean isVerbose();

    public final void pressReturnToContinue() {
        Message msg = UtilityMessages.INFO_MENU_PROMPT_RETURN_TO_CONTINUE.get();
        try {
            this.readLineOfInput(msg);
        }
        catch (CLIException cLIException) {
            // empty catch block
        }
    }

    public final void println() {
        this.err.println();
    }

    public final void println(Message msg) {
        this.err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
    }

    public final void print(Message msg) {
        this.err.print(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
    }

    public final void printlnProgress() {
        if (!this.isQuiet()) {
            this.out.println();
        }
    }

    public final void printProgress(Message msg) {
        if (!this.isQuiet()) {
            this.out.print(msg);
        }
    }

    public final void println(Message msg, int indent) {
        this.err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH, indent));
    }

    public final void printVerboseMessage(Message msg) {
        if (this.isVerbose() || this.isInteractive()) {
            this.err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
        }
    }

    public final String readLineOfInput(Message prompt) throws CLIException {
        if (prompt != null) {
            this.err.print(StaticUtils.wrapText(prompt, ServerConstants.MAX_LINE_WIDTH));
            this.err.print(" ");
        }
        try {
            String s = this.in.readLine();
            if (s == null) {
                throw CLIException.adaptInputException(new EOFException("End of input"));
            }
            return s;
        }
        catch (IOException e) {
            throw CLIException.adaptInputException(e);
        }
    }

    public String readInput(Message prompt, String defaultValue) throws CLIException {
        String response;
        block2: {
            while (true) {
                if (defaultValue != null) {
                    prompt = UtilityMessages.INFO_PROMPT_SINGLE_DEFAULT.get(prompt.toString(), defaultValue);
                }
                if (!"".equals(response = this.readLineOfInput(prompt))) break block2;
                if (defaultValue != null) break;
                this.print(QuickSetupMessages.INFO_ERROR_EMPTY_RESPONSE.get());
            }
            return defaultValue;
        }
        return response;
    }

    public String readInput(Message prompt, String defaultValue, Logger logger) {
        String s = defaultValue;
        try {
            s = this.readInput(prompt, defaultValue);
        }
        catch (CLIException ce) {
            logger.log(Level.WARNING, "Error reading input: " + ce, ce);
        }
        return s;
    }

    public final String readPassword(Message prompt) throws CLIException {
        char[] pwChars;
        this.err.print(StaticUtils.wrapText(prompt + " ", ServerConstants.MAX_LINE_WIDTH));
        try {
            pwChars = PasswordReader.readPassword();
        }
        catch (Exception e) {
            throw CLIException.adaptInputException(e);
        }
        return new String(pwChars);
    }

    protected final String readPassword(Message prompt, Logger logger) {
        String pwd = null;
        try {
            pwd = this.readPassword(prompt);
        }
        catch (CLIException ce) {
            logger.log(Level.WARNING, "Error reading input: " + ce, ce);
        }
        return pwd;
    }

    public final int readPort(Message prompt, final int defaultValue) throws CLIException {
        ValidationCallback<Integer> callback = new ValidationCallback<Integer>(){

            @Override
            public Integer validate(ConsoleApplication app, String input) throws CLIException {
                String ninput = input.trim();
                if (ninput.length() == 0) {
                    return defaultValue;
                }
                try {
                    int i = Integer.parseInt(ninput);
                    if (i < 1 || i > 65535) {
                        throw new NumberFormatException();
                    }
                    return i;
                }
                catch (NumberFormatException e) {
                    app.println();
                    app.println(UtilityMessages.ERR_LDAP_CONN_BAD_PORT_NUMBER.get(ninput));
                    app.println();
                    return null;
                }
            }
        };
        if (defaultValue != -1) {
            prompt = UtilityMessages.INFO_PROMPT_SINGLE_DEFAULT.get(prompt.toString(), String.valueOf(defaultValue));
        }
        return this.readValidatedInput(prompt, callback);
    }

    public final <T> T readValidatedInput(Message prompt, ValidationCallback<T> validator) throws CLIException {
        String response;
        T value;
        while ((value = validator.validate(this, response = this.readLineOfInput(prompt))) == null) {
        }
        return value;
    }

    public final <T> T readValidatedInput(Message prompt, ValidationCallback<T> validator, int maxTries) throws CLIException {
        for (int nTries = 0; nTries < maxTries; ++nTries) {
            String response = this.readLineOfInput(prompt);
            T value = validator.validate(this, response);
            if (value == null) continue;
            return value;
        }
        throw new CLIException(UtilityMessages.ERR_TRIES_LIMIT_REACHED.get(maxTries));
    }

    protected final boolean askConfirmation(Message prompt, boolean defaultValue, Logger logger) throws CLIException {
        boolean v = defaultValue;
        boolean done = false;
        int nTries = 0;
        while (!done && nTries < 5) {
            ++nTries;
            try {
                v = this.confirmAction(prompt, defaultValue);
                done = true;
            }
            catch (CLIException ce) {
                if (ce.getMessageObject().getDescriptor().equals(UtilityMessages.ERR_CONFIRMATION_TRIES_LIMIT_REACHED) || ce.getMessageObject().getDescriptor().equals(UtilityMessages.ERR_TRIES_LIMIT_REACHED)) {
                    throw ce;
                }
                logger.log(Level.WARNING, "Error reading input: " + ce, ce);
                this.println();
            }
        }
        if (!done) {
            throw new CLIException(UtilityMessages.ERR_CONFIRMATION_TRIES_LIMIT_REACHED.get(5));
        }
        return v;
    }

    protected InitialLdapContext createAdministrativeContext(String host, int port, boolean useSSL, boolean useStartTLS, String bindDn, String pwd, ApplicationTrustManager trustManager) throws NamingException {
        String ldapUrl = ConnectionUtils.getLDAPUrl(host, port, useSSL);
        InitialLdapContext ctx = useSSL ? Utils.createLdapsContext(ldapUrl, bindDn, pwd, Utils.getDefaultLDAPTimeout(), null, trustManager) : (useStartTLS ? Utils.createStartTLSContext(ldapUrl, bindDn, pwd, Utils.getDefaultLDAPTimeout(), null, trustManager, null) : Utils.createLdapContext(ldapUrl, bindDn, pwd, Utils.getDefaultLDAPTimeout(), null));
        if (!ConnectionUtils.connectedAsAdministrativeUser(ctx)) {
            throw new NoPermissionException(AdminToolMessages.ERR_NOT_ADMINISTRATIVE_USER.get().toString());
        }
        return ctx;
    }

    protected InitialLdapContext createInitialLdapContextInteracting(LDAPConnectionConsoleInteraction ci) throws ClientException {
        InitialLdapContext ctx;
        block23: {
            String hostName = ConnectionUtils.getHostNameForLdapUrl(ci.getHostName());
            Integer portNumber = ci.getPortNumber();
            String bindDN = ci.getBindDN();
            String bindPassword = ci.getBindPassword();
            TrustManager trustManager = ci.getTrustManager();
            KeyManager keyManager = ci.getKeyManager();
            if (ci.useSSL()) {
                String ldapsUrl = "ldaps://" + hostName + ":" + portNumber;
                while (true) {
                    try {
                        ctx = ConnectionUtils.createLdapsContext(ldapsUrl, bindDN, bindPassword, ConnectionUtils.getDefaultLDAPTimeout(), null, trustManager, keyManager);
                        ctx.reconnect(null);
                        break block23;
                    }
                    catch (NamingException e) {
                        Message message;
                        if (this.isInteractive() && ci.isTrustStoreInMemory()) {
                            if (e.getRootCause() != null && e.getRootCause().getCause() instanceof OpendsCertificateException) {
                                OpendsCertificateException oce = (OpendsCertificateException)e.getRootCause().getCause();
                                String authType = null;
                                if (trustManager instanceof ApplicationTrustManager) {
                                    ApplicationTrustManager appTrustManager = (ApplicationTrustManager)trustManager;
                                    authType = appTrustManager.getLastRefusedAuthType();
                                }
                                if (ci.checkServerCertificate(oce.getChain(), authType, hostName)) {
                                    trustManager = ci.getTrustManager();
                                    continue;
                                }
                                return null;
                            }
                            message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get(hostName, String.valueOf(portNumber));
                            throw new ClientException(91, message);
                        }
                        message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get(hostName, String.valueOf(portNumber));
                        throw new ClientException(91, message);
                    }
                    break;
                }
            }
            if (ci.useStartTLS()) {
                String ldapUrl = "ldap://" + hostName + ":" + portNumber;
                while (true) {
                    try {
                        ctx = ConnectionUtils.createStartTLSContext(ldapUrl, bindDN, bindPassword, ConnectionUtils.getDefaultLDAPTimeout(), null, trustManager, keyManager, null);
                        ctx.reconnect(null);
                        break block23;
                    }
                    catch (NamingException e) {
                        Message message;
                        if (this.isInteractive() && ci.isTrustStoreInMemory()) {
                            if (e.getRootCause() != null && e.getRootCause().getCause() instanceof OpendsCertificateException) {
                                OpendsCertificateException oce;
                                String authType = null;
                                if (trustManager instanceof ApplicationTrustManager) {
                                    ApplicationTrustManager appTrustManager = (ApplicationTrustManager)trustManager;
                                    authType = appTrustManager.getLastRefusedAuthType();
                                }
                                if (ci.checkServerCertificate((oce = (OpendsCertificateException)e.getRootCause().getCause()).getChain(), authType, hostName)) {
                                    trustManager = ci.getTrustManager();
                                    continue;
                                }
                                return null;
                            }
                            message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get(hostName, String.valueOf(portNumber));
                            throw new ClientException(91, message);
                        }
                        message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get(hostName, String.valueOf(portNumber));
                        throw new ClientException(91, message);
                    }
                    break;
                }
            }
            String ldapUrl = "ldap://" + hostName + ":" + portNumber;
            while (true) {
                try {
                    ctx = ConnectionUtils.createLdapContext(ldapUrl, bindDN, bindPassword, ConnectionUtils.getDefaultLDAPTimeout(), null);
                    ctx.reconnect(null);
                }
                catch (NamingException e) {
                    Message message;
                    if (this.isInteractive() && ci.isTrustStoreInMemory()) {
                        if (e.getRootCause() != null && e.getRootCause().getCause() instanceof OpendsCertificateException) {
                            OpendsCertificateException oce;
                            String authType = null;
                            if (trustManager instanceof ApplicationTrustManager) {
                                ApplicationTrustManager appTrustManager = (ApplicationTrustManager)trustManager;
                                authType = appTrustManager.getLastRefusedAuthType();
                            }
                            if (ci.checkServerCertificate((oce = (OpendsCertificateException)e.getRootCause().getCause()).getChain(), authType, hostName)) {
                                trustManager = ci.getTrustManager();
                                continue;
                            }
                            return null;
                        }
                        message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get(hostName, String.valueOf(portNumber));
                        throw new ClientException(91, message);
                    }
                    message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get(hostName, String.valueOf(portNumber));
                    throw new ClientException(91, message);
                }
                break;
            }
        }
        return ctx;
    }

    private static final class NullReader
    extends Reader {
        private NullReader() {
        }

        public void close() throws IOException {
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            return -1;
        }
    }
}

