/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.AddMsg;
import org.opends.server.replication.protocol.DeleteMsg;
import org.opends.server.replication.protocol.ModifyDNMsg;
import org.opends.server.replication.protocol.ModifyMsg;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.replication.protocol.ReplicationMessage;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.LDAPException;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostOperationOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UpdateMessage
extends ReplicationMessage
implements Serializable,
Comparable<UpdateMessage> {
    private ChangeNumber changeNumber;
    private String dn = null;
    private boolean assuredFlag = false;
    private String UniqueId;

    public UpdateMessage(OperationContext ctx, String dn) {
        this.changeNumber = ctx.getChangeNumber();
        this.UniqueId = ctx.getEntryUid();
        this.dn = dn;
    }

    protected UpdateMessage(byte[] in) throws DataFormatException, UnsupportedEncodingException {
        int pos = 1;
        int length = this.getNextLength(in, pos);
        String changenumberStr = new String(in, pos, length, "UTF-8");
        this.changeNumber = new ChangeNumber(changenumberStr);
    }

    public static UpdateMessage generateMsg(PostOperationOperation op, boolean isAssured) {
        UpdateMessage msg = null;
        switch (op.getOperationType()) {
            case MODIFY: {
                msg = new ModifyMsg((PostOperationModifyOperation)op);
                if (!isAssured) break;
                msg.setAssured();
                break;
            }
            case ADD: {
                msg = new AddMsg((PostOperationAddOperation)op);
                if (!isAssured) break;
                msg.setAssured();
                break;
            }
            case DELETE: {
                msg = new DeleteMsg((PostOperationDeleteOperation)op);
                if (!isAssured) break;
                msg.setAssured();
                break;
            }
            case MODIFY_DN: {
                msg = new ModifyDNMsg((PostOperationModifyDNOperation)op);
                if (!isAssured) break;
                msg.setAssured();
            }
        }
        return msg;
    }

    public ChangeNumber getChangeNumber() {
        return this.changeNumber;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getUniqueId() {
        return this.UniqueId;
    }

    public boolean isAssured() {
        return this.assuredFlag;
    }

    public void setAssured() {
        this.assuredFlag = true;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            return this.changeNumber.equals(((UpdateMessage)obj).changeNumber);
        }
        return false;
    }

    public int hashCode() {
        return this.changeNumber.hashCode();
    }

    @Override
    public int compareTo(UpdateMessage msg) {
        return this.changeNumber.compareTo(msg.getChangeNumber());
    }

    public AbstractOperation createOperation(InternalClientConnection conn) throws LDAPException, ASN1Exception, DataFormatException {
        return this.createOperation(conn, this.dn);
    }

    public abstract AbstractOperation createOperation(InternalClientConnection var1, String var2) throws LDAPException, ASN1Exception, DataFormatException;

    public byte[] encodeHeader(byte type, int additionalLength) throws UnsupportedEncodingException {
        byte[] byteDn = this.dn.getBytes("UTF-8");
        byte[] changeNumberByte = this.getChangeNumber().toString().getBytes("UTF-8");
        byte[] byteEntryuuid = this.getUniqueId().getBytes("UTF-8");
        int length = 5 + changeNumberByte.length + byteDn.length + byteEntryuuid.length + additionalLength;
        byte[] encodedMsg = new byte[length];
        encodedMsg[0] = type;
        int pos = 1;
        pos = this.addByteArray(changeNumberByte, encodedMsg, pos);
        encodedMsg[pos++] = this.assuredFlag ? (byte)1 : 0;
        pos = this.addByteArray(byteDn, encodedMsg, pos);
        pos = this.addByteArray(byteEntryuuid, encodedMsg, pos);
        return encodedMsg;
    }

    public int decodeHeader(byte type, byte[] encodedMsg) throws DataFormatException {
        if (encodedMsg[0] != type) {
            throw new DataFormatException("byte[] is not a valid msg");
        }
        try {
            int pos = 1;
            int length = this.getNextLength(encodedMsg, pos);
            String changenumberStr = new String(encodedMsg, pos, length, "UTF-8");
            pos += length + 1;
            this.changeNumber = new ChangeNumber(changenumberStr);
            this.assuredFlag = encodedMsg[pos++] == 1;
            length = this.getNextLength(encodedMsg, pos);
            this.dn = new String(encodedMsg, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(encodedMsg, pos);
            this.UniqueId = new String(encodedMsg, pos, length, "UTF-8");
            return pos += length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }
}

