/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class ASN1Long
extends ASN1Element {
    private static final long serialVersionUID = -6015600344725970947L;
    private long longValue;

    public ASN1Long(long longValue) {
        super((byte)2, ASN1Long.encodeLongValue(longValue));
        this.longValue = longValue;
    }

    public ASN1Long(byte type, long longValue) {
        super(type, ASN1Long.encodeLongValue(longValue));
        this.longValue = longValue;
    }

    private ASN1Long(byte type, byte[] value, long longValue) {
        super(type, value);
        this.longValue = longValue;
    }

    public long longValue() {
        return this.longValue;
    }

    public void setValue(long longValue) {
        this.longValue = longValue;
        this.setValueInternal(ASN1Long.encodeLongValue(longValue));
    }

    public void setValue(byte[] value) throws ASN1Exception {
        if (value == null) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_SET_VALUE_NULL.get();
            throw new ASN1Exception(message);
        }
        if (value.length < 1 || value.length > 8) {
            Message message = ProtocolMessages.ERR_ASN1_LONG_SET_VALUE_INVALID_LENGTH.get(value.length);
            throw new ASN1Exception(message);
        }
        this.longValue = 0L;
        for (byte b : value) {
            this.longValue = this.longValue << 8 | (long)(b & 0xFF);
        }
        this.setValueInternal(value);
    }

    public static ASN1Long decodeAsLong(ASN1Element element) throws ASN1Exception {
        if (element == null) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_DECODE_ELEMENT_NULL.get();
            throw new ASN1Exception(message);
        }
        byte[] value = element.value();
        if (value.length < 1 || value.length > 8) {
            Message message = ProtocolMessages.ERR_ASN1_LONG_DECODE_ELEMENT_INVALID_LENGTH.get(value.length);
            throw new ASN1Exception(message);
        }
        long longValue = 0L;
        for (byte b : value) {
            longValue = longValue << 8 | (long)(b & 0xFF);
        }
        return new ASN1Long(element.getType(), value, longValue);
    }

    public static ASN1Long decodeAsLong(byte[] encodedElement) throws ASN1Exception {
        if (encodedElement == null) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_DECODE_ARRAY_NULL.get();
            throw new ASN1Exception(message);
        }
        if (encodedElement.length < 3) {
            Message message = ProtocolMessages.ERR_ASN1_INTEGER_SHORT_ELEMENT.get(encodedElement.length);
            throw new ASN1Exception(message);
        }
        byte type = encodedElement[0];
        int length = encodedElement[1] & 0x7F;
        int valueStartPos = 2;
        if (length != encodedElement[1]) {
            int numLengthBytes = length;
            if (numLengthBytes > 4) {
                Message message = ProtocolMessages.ERR_ASN1_INVALID_NUM_LENGTH_BYTES.get(numLengthBytes);
                throw new ASN1Exception(message);
            }
            if (encodedElement.length < 2 + numLengthBytes) {
                Message message = ProtocolMessages.ERR_ASN1_TRUNCATED_LENGTH.get(numLengthBytes);
                throw new ASN1Exception(message);
            }
            length = 0;
            valueStartPos = 2 + numLengthBytes;
            for (int i = 0; i < numLengthBytes; ++i) {
                length = length << 8 | encodedElement[i + 2] & 0xFF;
            }
        }
        if (encodedElement.length - valueStartPos != length) {
            Message message = ProtocolMessages.ERR_ASN1_LENGTH_MISMATCH.get(length, encodedElement.length - valueStartPos);
            throw new ASN1Exception(message);
        }
        if (length < 1 || length > 8) {
            Message message = ProtocolMessages.ERR_ASN1_LONG_DECODE_ARRAY_INVALID_LENGTH.get(length);
            throw new ASN1Exception(message);
        }
        byte[] value = new byte[length];
        System.arraycopy(encodedElement, valueStartPos, value, 0, length);
        long longValue = 0L;
        for (byte b : value) {
            longValue = longValue << 8 | (long)(b & 0xFF);
        }
        return new ASN1Long(type, value, longValue);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ASN1Long(type=");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(", value=");
        buffer.append(this.longValue);
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("ASN.1 Long");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  BER Type:  ");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Value:  ");
        buffer.append(this.longValue);
        buffer.append(" (");
        buffer.append(StaticUtils.bytesToHex(this.value()));
        buffer.append(")");
        buffer.append(ServerConstants.EOL);
    }
}

