/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.opends.server.admin.std.server.MemoryUsageMonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryUsageMonitorProvider
extends MonitorProvider<MemoryUsageMonitorProviderCfg> {
    private HashMap<String, Long> lastGCCounts = new HashMap();
    private HashMap<String, Long> lastGCTimes = new HashMap();
    private HashMap<String, Long> recentGCDurations = new HashMap();
    private HashMap<String, String> gcSafeNames = new HashMap();

    public MemoryUsageMonitorProvider() {
        super("JVM Memory Usage Monitor Provider");
    }

    @Override
    public void initializeMonitorProvider(MemoryUsageMonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        return "JVM Memory Usage";
    }

    @Override
    public long getUpdateInterval() {
        return 1000L;
    }

    @Override
    public void updateMonitorData() {
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            String gcName = gc.getName();
            long gcCount = gc.getCollectionCount();
            long gcTime = gc.getCollectionTime();
            long lastGCCount = 0L;
            long lastGCTime = 0L;
            long recentGCDuration = 0L;
            if (this.lastGCCounts.containsKey(gcName)) {
                lastGCCount = this.lastGCCounts.get(gcName);
                lastGCTime = this.lastGCTimes.get(gcName);
                recentGCDuration = this.recentGCDurations.get(gcName);
            }
            if (gcCount > lastGCCount) {
                long recentGCCount = gcCount - lastGCCount;
                long recentGCTime = gcTime - lastGCTime;
                recentGCDuration = recentGCTime / recentGCCount;
            }
            this.lastGCCounts.put(gcName, gcCount);
            this.lastGCTimes.put(gcName, gcTime);
            this.recentGCDurations.put(gcName, recentGCDuration);
        }
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            String safeName;
            String gcName = gc.getName();
            long gcCount = gc.getCollectionCount();
            long gcTime = gc.getCollectionTime();
            long avgGCDuration = 0L;
            if (gcCount > 0L) {
                avgGCDuration = gcTime / gcCount;
            }
            long recentGCDuration = 0L;
            if (this.recentGCDurations.containsKey(gcName)) {
                recentGCDuration = this.recentGCDurations.get(gcName);
            }
            if ((safeName = this.gcSafeNames.get(gcName)) == null) {
                safeName = this.generateSafeName(gcName);
                this.gcSafeNames.put(gcName, safeName);
            }
            attrs.add(this.createAttribute(safeName + "-total-collection-count", String.valueOf(gcCount)));
            attrs.add(this.createAttribute(safeName + "-total-collection-duration", String.valueOf(gcTime)));
            attrs.add(this.createAttribute(safeName + "-average-collection-duration", String.valueOf(avgGCDuration)));
            attrs.add(this.createAttribute(safeName + "-recent-collection-duration", String.valueOf(recentGCDuration)));
        }
        for (MemoryPoolMXBean mp : ManagementFactory.getMemoryPoolMXBeans()) {
            String poolName = mp.getName();
            MemoryUsage currentUsage = mp.getUsage();
            MemoryUsage collectionUsage = mp.getCollectionUsage();
            String safeName = this.gcSafeNames.get(poolName);
            if (safeName == null) {
                safeName = this.generateSafeName(poolName);
                this.gcSafeNames.put(poolName, safeName);
            }
            if (currentUsage == null) {
                attrs.add(this.createAttribute(safeName + "-current-bytes-used", "0"));
            } else {
                attrs.add(this.createAttribute(safeName + "-current-bytes-used", String.valueOf(currentUsage.getUsed())));
            }
            if (collectionUsage == null) {
                attrs.add(this.createAttribute(safeName + "-bytes-used-after-last-collection", "0"));
                continue;
            }
            attrs.add(this.createAttribute(safeName + "-bytes-used-after-last-collection", String.valueOf(collectionUsage.getUsed())));
        }
        return attrs;
    }

    private Attribute createAttribute(String name, String value) {
        AttributeType attrType = DirectoryServer.getDefaultAttributeType(name);
        ASN1OctetString encodedValue = new ASN1OctetString(value);
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(1);
        try {
            values.add(new AttributeValue(encodedValue, attrType.normalize(encodedValue)));
        }
        catch (Exception e) {
            values.add(new AttributeValue(encodedValue, (ByteString)encodedValue));
        }
        return new Attribute(attrType, name, values);
    }

    private String generateSafeName(String name) {
        StringBuilder buffer = new StringBuilder();
        boolean lastWasUppercase = false;
        boolean lastWasDash = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetter(c)) {
                if (Character.isUpperCase(c)) {
                    char lowerCaseCharacter = Character.toLowerCase(c);
                    if (buffer.length() > 0 && !lastWasUppercase && !lastWasDash) {
                        buffer.append('-');
                    }
                    buffer.append(lowerCaseCharacter);
                    lastWasUppercase = true;
                    lastWasDash = false;
                    continue;
                }
                buffer.append(c);
                lastWasUppercase = false;
                lastWasDash = false;
                continue;
            }
            if (Character.isDigit(c)) {
                buffer.append(c);
                lastWasUppercase = false;
                lastWasDash = false;
                continue;
            }
            if (c != ' ' && c != '_' && c != '-') continue;
            if (!lastWasDash) {
                buffer.append('-');
            }
            lastWasUppercase = false;
            lastWasDash = true;
        }
        return buffer.toString();
    }
}

