/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.PasswordPolicyStateExtendedOperationHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Modification;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordPolicyStateExtendedOperation
extends ExtendedOperationHandler<PasswordPolicyStateExtendedOperationHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final int OP_GET_PASSWORD_POLICY_DN = 0;
    public static final int OP_GET_ACCOUNT_DISABLED_STATE = 1;
    public static final int OP_SET_ACCOUNT_DISABLED_STATE = 2;
    public static final int OP_CLEAR_ACCOUNT_DISABLED_STATE = 3;
    public static final int OP_GET_ACCOUNT_EXPIRATION_TIME = 4;
    public static final int OP_SET_ACCOUNT_EXPIRATION_TIME = 5;
    public static final int OP_CLEAR_ACCOUNT_EXPIRATION_TIME = 6;
    public static final int OP_GET_SECONDS_UNTIL_ACCOUNT_EXPIRATION = 7;
    public static final int OP_GET_PASSWORD_CHANGED_TIME = 8;
    public static final int OP_SET_PASSWORD_CHANGED_TIME = 9;
    public static final int OP_CLEAR_PASSWORD_CHANGED_TIME = 10;
    public static final int OP_GET_PASSWORD_EXPIRATION_WARNED_TIME = 11;
    public static final int OP_SET_PASSWORD_EXPIRATION_WARNED_TIME = 12;
    public static final int OP_CLEAR_PASSWORD_EXPIRATION_WARNED_TIME = 13;
    public static final int OP_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION = 14;
    public static final int OP_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION_WARNING = 15;
    public static final int OP_GET_AUTHENTICATION_FAILURE_TIMES = 16;
    public static final int OP_ADD_AUTHENTICATION_FAILURE_TIME = 17;
    public static final int OP_SET_AUTHENTICATION_FAILURE_TIMES = 18;
    public static final int OP_CLEAR_AUTHENTICATION_FAILURE_TIMES = 19;
    public static final int OP_GET_SECONDS_UNTIL_AUTHENTICATION_FAILURE_UNLOCK = 20;
    public static final int OP_GET_REMAINING_AUTHENTICATION_FAILURE_COUNT = 21;
    public static final int OP_GET_LAST_LOGIN_TIME = 22;
    public static final int OP_SET_LAST_LOGIN_TIME = 23;
    public static final int OP_CLEAR_LAST_LOGIN_TIME = 24;
    public static final int OP_GET_SECONDS_UNTIL_IDLE_LOCKOUT = 25;
    public static final int OP_GET_PASSWORD_RESET_STATE = 26;
    public static final int OP_SET_PASSWORD_RESET_STATE = 27;
    public static final int OP_CLEAR_PASSWORD_RESET_STATE = 28;
    public static final int OP_GET_SECONDS_UNTIL_PASSWORD_RESET_LOCKOUT = 29;
    public static final int OP_GET_GRACE_LOGIN_USE_TIMES = 30;
    public static final int OP_ADD_GRACE_LOGIN_USE_TIME = 31;
    public static final int OP_SET_GRACE_LOGIN_USE_TIMES = 32;
    public static final int OP_CLEAR_GRACE_LOGIN_USE_TIMES = 33;
    public static final int OP_GET_REMAINING_GRACE_LOGIN_COUNT = 34;
    public static final int OP_GET_PASSWORD_CHANGED_BY_REQUIRED_TIME = 35;
    public static final int OP_SET_PASSWORD_CHANGED_BY_REQUIRED_TIME = 36;
    public static final int OP_CLEAR_PASSWORD_CHANGED_BY_REQUIRED_TIME = 37;
    public static final int OP_GET_SECONDS_UNTIL_REQUIRED_CHANGE_TIME = 38;
    public static final int OP_GET_PASSWORD_HISTORY = 39;
    public static final int OP_CLEAR_PASSWORD_HISTORY = 40;
    private LinkedHashSet<String> requestAttributes;
    private SearchFilter userFilter;

    @Override
    public void initializeExtendedOperationHandler(PasswordPolicyStateExtendedOperationHandlerCfg config) throws ConfigException, InitializationException {
        block2: {
            try {
                this.userFilter = SearchFilter.createFilterFromString("(objectClass=*)");
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        this.requestAttributes = new LinkedHashSet(2);
        this.requestAttributes.add("*");
        this.requestAttributes.add("+");
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.26027.1.6.1", this);
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.1.8");
    }

    @Override
    public void processExtendedOperation(ExtendedOperation operation) {
        String timeStr;
        Object secondsStr;
        boolean returnAll;
        PasswordPolicy policy;
        PasswordPolicyState pwpState;
        InternalClientConnection conn;
        InternalSearchOperation internalSearch;
        DN targetDN;
        ASN1Sequence opSequence;
        ASN1OctetString dnString;
        operation.setResultCode(ResultCode.UNDEFINED);
        ClientConnection clientConnection = operation.getClientConnection();
        if (!clientConnection.hasPrivilege(Privilege.PASSWORD_RESET, operation)) {
            Message message = ExtensionMessages.ERR_PWPSTATE_EXTOP_NO_PRIVILEGE.get();
            operation.appendErrorMessage(message);
            operation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
            return;
        }
        ASN1OctetString requestValue = operation.getRequestValue();
        if (requestValue == null) {
            Message message = ExtensionMessages.ERR_PWPSTATE_EXTOP_NO_REQUEST_VALUE.get();
            operation.appendErrorMessage(message);
            operation.setResultCode(ResultCode.PROTOCOL_ERROR);
            return;
        }
        try {
            ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(requestValue.value());
            ArrayList<ASN1Element> elements = valueSequence.elements();
            dnString = ((ASN1Element)elements.get(0)).decodeAsOctetString();
            opSequence = elements.size() == 2 ? ((ASN1Element)elements.get(1)).decodeAsSequence() : null;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWPSTATE_EXTOP_DECODE_FAILURE.get(StaticUtils.getExceptionMessage(e));
            operation.appendErrorMessage(message);
            operation.setResultCode(ResultCode.PROTOCOL_ERROR);
            return;
        }
        try {
            targetDN = DN.decode(dnString);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            operation.setResponseData(de);
            return;
        }
        DN rootDN = DirectoryServer.getActualRootBindDN(targetDN);
        if (rootDN != null) {
            targetDN = rootDN;
        }
        if ((internalSearch = (conn = new InternalClientConnection(clientConnection.getAuthenticationInfo())).processSearch(targetDN, SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 1, 0, false, this.userFilter, this.requestAttributes, null)).getResultCode() != ResultCode.SUCCESS) {
            operation.setResultCode(internalSearch.getResultCode());
            operation.setErrorMessage(internalSearch.getErrorMessage());
            operation.setMatchedDN(internalSearch.getMatchedDN());
            operation.setReferralURLs(internalSearch.getReferralURLs());
            return;
        }
        LinkedList<SearchResultEntry> matchingEntries = internalSearch.getSearchEntries();
        if (matchingEntries.isEmpty()) {
            operation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
            return;
        }
        if (matchingEntries.size() > 1) {
            Message message = ExtensionMessages.ERR_PWPSTATE_EXTOP_MULTIPLE_ENTRIES.get(String.valueOf(targetDN));
            operation.appendErrorMessage(message);
            operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
            return;
        }
        Entry userEntry = (Entry)matchingEntries.get(0);
        try {
            pwpState = new PasswordPolicyState(userEntry, false);
            policy = pwpState.getPolicy();
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            operation.setResponseData(de);
            return;
        }
        LinkedHashSet<Integer> returnTypes = new LinkedHashSet<Integer>();
        if (opSequence == null || opSequence.elements().isEmpty()) {
            returnAll = true;
        } else {
            ModifyOperation modifyOperation;
            returnAll = false;
            block69: for (ASN1Element element : opSequence.elements()) {
                Message message;
                ArrayList<String> opValues;
                int opType;
                try {
                    ArrayList<ASN1Element> opElements = element.decodeAsSequence().elements();
                    opType = ((ASN1Element)opElements.get(0)).decodeAsEnumerated().intValue();
                    if (opElements.size() == 1) {
                        opValues = null;
                    } else {
                        ArrayList<ASN1Element> valueElements = ((ASN1Element)opElements.get(1)).decodeAsSequence().elements();
                        if (valueElements.isEmpty()) {
                            opValues = null;
                        } else {
                            opValues = new ArrayList<String>(valueElements.size());
                            for (ASN1Element e : valueElements) {
                                opValues.add(e.decodeAsOctetString().stringValue());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    message = ExtensionMessages.ERR_PWPSTATE_EXTOP_INVALID_OP_ENCODING.get(e.getLocalizedMessage());
                    operation.appendErrorMessage(message);
                    operation.setResultCode(ResultCode.PROTOCOL_ERROR);
                    return;
                }
                switch (opType) {
                    case 0: {
                        returnTypes.add(0);
                        continue block69;
                    }
                    case 1: {
                        returnTypes.add(1);
                        continue block69;
                    }
                    case 2: {
                        if (opValues == null) {
                            operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_NO_DISABLED_VALUE.get());
                            operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                            return;
                        }
                        if (opValues.size() != 1) {
                            operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_DISABLED_VALUE_COUNT.get());
                            operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                            return;
                        }
                        String value = (String)opValues.get(0);
                        if (value.equalsIgnoreCase("true")) {
                            pwpState.setDisabled(true);
                        } else if (value.equalsIgnoreCase("false")) {
                            pwpState.setDisabled(false);
                        } else {
                            operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_DISABLED_VALUE.get());
                            operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                            return;
                        }
                        returnTypes.add(1);
                        continue block69;
                    }
                    case 3: {
                        pwpState.setDisabled(false);
                        returnTypes.add(1);
                        continue block69;
                    }
                    case 4: {
                        returnTypes.add(4);
                        continue block69;
                    }
                    case 5: {
                        ASN1OctetString valueString;
                        if (opValues == null) {
                            pwpState.setAccountExpirationTime(pwpState.getCurrentTime());
                        } else {
                            if (opValues.size() != 1) {
                                operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_ACCT_EXP_VALUE_COUNT.get());
                                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                return;
                            }
                            try {
                                valueString = new ASN1OctetString((String)opValues.get(0));
                                long time = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                                pwpState.setAccountExpirationTime(time);
                            }
                            catch (DirectoryException de) {
                                operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_ACCT_EXP_VALUE.get((CharSequence)opValues.get(0), de.getMessageObject()));
                                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                return;
                            }
                        }
                        returnTypes.add(4);
                        continue block69;
                    }
                    case 6: {
                        pwpState.clearAccountExpirationTime();
                        returnTypes.add(4);
                        continue block69;
                    }
                    case 7: {
                        returnTypes.add(7);
                        continue block69;
                    }
                    case 8: {
                        returnTypes.add(8);
                        continue block69;
                    }
                    case 9: {
                        ASN1OctetString valueString;
                        if (opValues == null) {
                            pwpState.setPasswordChangedTime();
                        } else {
                            if (opValues.size() != 1) {
                                operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_PWCHANGETIME_VALUE_COUNT.get());
                                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                return;
                            }
                            try {
                                valueString = new ASN1OctetString((String)opValues.get(0));
                                long time = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                                pwpState.setPasswordChangedTime(time);
                            }
                            catch (DirectoryException de) {
                                operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_PWCHANGETIME_VALUE.get((CharSequence)opValues.get(0), de.getMessageObject()));
                                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                return;
                            }
                        }
                        returnTypes.add(8);
                        continue block69;
                    }
                    case 10: {
                        pwpState.clearPasswordChangedTime();
                        returnTypes.add(8);
                        continue block69;
                    }
                    case 11: {
                        returnTypes.add(11);
                        continue block69;
                    }
                    case 12: {
                        ASN1OctetString valueString;
                        if (opValues == null) {
                            pwpState.setWarnedTime();
                        } else {
                            if (opValues.size() != 1) {
                                operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_PWWARNEDTIME_VALUE_COUNT.get());
                                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                return;
                            }
                            try {
                                valueString = new ASN1OctetString((String)opValues.get(0));
                                long time = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                                pwpState.setWarnedTime(time);
                            }
                            catch (DirectoryException de) {
                                operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_PWWARNEDTIME_VALUE.get((CharSequence)opValues.get(0), de.getMessageObject()));
                                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                return;
                            }
                        }
                        returnTypes.add(11);
                        continue block69;
                    }
                    case 13: {
                        pwpState.clearWarnedTime();
                        returnTypes.add(11);
                        continue block69;
                    }
                    case 14: {
                        returnTypes.add(14);
                        continue block69;
                    }
                    case 15: {
                        returnTypes.add(15);
                        continue block69;
                    }
                    case 16: {
                        returnTypes.add(16);
                        continue block69;
                    }
                    case 17: {
                        List<Long> authFailureTimes;
                        ASN1OctetString valueString;
                        if (opValues == null) {
                            if (policy.getLockoutFailureCount() == 0) {
                                returnTypes.add(16);
                                continue block69;
                            }
                            pwpState.updateAuthFailureTimes();
                        } else {
                            if (opValues.size() != 1) {
                                operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_ADD_FAILURE_TIME_COUNT.get());
                                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                return;
                            }
                            try {
                                valueString = new ASN1OctetString((String)opValues.get(0));
                                long time = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                                authFailureTimes = pwpState.getAuthFailureTimes();
                                ArrayList<Long> newFailureTimes = new ArrayList<Long>(authFailureTimes.size() + 1);
                                newFailureTimes.addAll(authFailureTimes);
                                newFailureTimes.add(time);
                                pwpState.setAuthFailureTimes(newFailureTimes);
                            }
                            catch (DirectoryException de) {
                                message = ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_AUTH_FAILURE_TIME.get((CharSequence)opValues.get(0), de.getMessageObject());
                                operation.setResultCode(de.getResultCode());
                                operation.appendErrorMessage(message);
                                return;
                            }
                        }
                        returnTypes.add(16);
                        continue block69;
                    }
                    case 18: {
                        Message message2;
                        ArrayList<Long> valueList;
                        if (opValues == null) {
                            valueList = new ArrayList<Long>(1);
                            valueList.add(pwpState.getCurrentTime());
                            pwpState.setAuthFailureTimes(valueList);
                        } else {
                            valueList = new ArrayList(opValues.size());
                            for (String s : opValues) {
                                try {
                                    valueList.add(GeneralizedTimeSyntax.decodeGeneralizedTimeValue(new ASN1OctetString(s)));
                                }
                                catch (DirectoryException de) {
                                    message2 = ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_AUTH_FAILURE_TIME.get(s, de.getMessageObject());
                                    operation.setResultCode(de.getResultCode());
                                    operation.appendErrorMessage(message2);
                                    return;
                                }
                            }
                            pwpState.setAuthFailureTimes(valueList);
                        }
                        returnTypes.add(16);
                        continue block69;
                    }
                    case 19: {
                        pwpState.clearFailureLockout();
                        returnTypes.add(16);
                        continue block69;
                    }
                    case 20: {
                        returnTypes.add(20);
                        continue block69;
                    }
                    case 21: {
                        returnTypes.add(21);
                        continue block69;
                    }
                    case 22: {
                        returnTypes.add(22);
                        continue block69;
                    }
                    case 23: {
                        ASN1OctetString valueString;
                        if (opValues == null) {
                            pwpState.setLastLoginTime();
                        } else {
                            if (opValues.size() != 1) {
                                operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_LAST_LOGIN_TIME_COUNT.get());
                                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                return;
                            }
                            try {
                                valueString = new ASN1OctetString((String)opValues.get(0));
                                long time = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                                pwpState.setLastLoginTime(time);
                            }
                            catch (DirectoryException de) {
                                operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_LAST_LOGIN_TIME.get((CharSequence)opValues.get(0), de.getMessageObject()));
                                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                return;
                            }
                        }
                        returnTypes.add(22);
                        continue block69;
                    }
                    case 24: {
                        pwpState.clearLastLoginTime();
                        returnTypes.add(22);
                        continue block69;
                    }
                    case 25: {
                        returnTypes.add(25);
                        continue block69;
                    }
                    case 26: {
                        returnTypes.add(26);
                        continue block69;
                    }
                    case 27: {
                        if (opValues == null) {
                            operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_NO_RESET_STATE_VALUE.get());
                            operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                            return;
                        }
                        if (opValues.size() != 1) {
                            operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_RESET_STATE_VALUE_COUNT.get());
                            operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                            return;
                        }
                        String value = (String)opValues.get(0);
                        if (value.equalsIgnoreCase("true")) {
                            pwpState.setMustChangePassword(true);
                        } else if (value.equalsIgnoreCase("false")) {
                            pwpState.setMustChangePassword(false);
                        } else {
                            operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_RESET_STATE_VALUE.get());
                            operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                            return;
                        }
                        returnTypes.add(26);
                        continue block69;
                    }
                    case 28: {
                        pwpState.setMustChangePassword(false);
                        returnTypes.add(26);
                        continue block69;
                    }
                    case 29: {
                        returnTypes.add(29);
                        continue block69;
                    }
                    case 30: {
                        returnTypes.add(30);
                        continue block69;
                    }
                    case 31: {
                        List<Long> authFailureTimes;
                        ASN1OctetString valueString;
                        if (opValues == null) {
                            pwpState.updateGraceLoginTimes();
                        } else {
                            if (opValues.size() != 1) {
                                operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_ADD_GRACE_LOGIN_TIME_COUNT.get());
                                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                return;
                            }
                            try {
                                valueString = new ASN1OctetString((String)opValues.get(0));
                                long time = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                                authFailureTimes = pwpState.getGraceLoginTimes();
                                ArrayList<Long> newGraceTimes = new ArrayList<Long>(authFailureTimes.size() + 1);
                                newGraceTimes.addAll(authFailureTimes);
                                newGraceTimes.add(time);
                                pwpState.setGraceLoginTimes(newGraceTimes);
                            }
                            catch (DirectoryException de) {
                                message = ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_GRACE_LOGIN_TIME.get((CharSequence)opValues.get(0), de.getMessageObject());
                                operation.setResultCode(de.getResultCode());
                                operation.appendErrorMessage(message);
                                return;
                            }
                        }
                        returnTypes.add(30);
                        continue block69;
                    }
                    case 32: {
                        Message message2;
                        ArrayList<Long> valueList;
                        if (opValues == null) {
                            valueList = new ArrayList(1);
                            valueList.add(pwpState.getCurrentTime());
                            pwpState.setGraceLoginTimes(valueList);
                        } else {
                            valueList = new ArrayList(opValues.size());
                            for (String s : opValues) {
                                try {
                                    valueList.add(GeneralizedTimeSyntax.decodeGeneralizedTimeValue(new ASN1OctetString(s)));
                                }
                                catch (DirectoryException de) {
                                    message2 = ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_GRACE_LOGIN_TIME.get(s, de.getMessageObject());
                                    operation.setResultCode(de.getResultCode());
                                    operation.appendErrorMessage(message2);
                                    return;
                                }
                            }
                            pwpState.setGraceLoginTimes(valueList);
                        }
                        returnTypes.add(30);
                        continue block69;
                    }
                    case 33: {
                        pwpState.clearGraceLoginTimes();
                        returnTypes.add(30);
                        continue block69;
                    }
                    case 34: {
                        returnTypes.add(34);
                        continue block69;
                    }
                    case 35: {
                        returnTypes.add(35);
                        continue block69;
                    }
                    case 36: {
                        ASN1OctetString valueString;
                        if (opValues == null) {
                            pwpState.setRequiredChangeTime();
                        } else {
                            if (opValues.size() != 1) {
                                operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_REQUIRED_CHANGE_TIME_COUNT.get());
                                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                return;
                            }
                            try {
                                valueString = new ASN1OctetString((String)opValues.get(0));
                                long time = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                                pwpState.setRequiredChangeTime(time);
                            }
                            catch (DirectoryException de) {
                                operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_REQUIRED_CHANGE_TIME.get((CharSequence)opValues.get(0), de.getMessageObject()));
                                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                return;
                            }
                        }
                        returnTypes.add(35);
                        continue block69;
                    }
                    case 37: {
                        pwpState.clearRequiredChangeTime();
                        returnTypes.add(35);
                        continue block69;
                    }
                    case 38: {
                        returnTypes.add(38);
                        continue block69;
                    }
                    case 39: {
                        returnTypes.add(39);
                        continue block69;
                    }
                    case 40: {
                        pwpState.clearPasswordHistory();
                        returnTypes.add(39);
                        continue block69;
                    }
                }
                operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_UNKNOWN_OP_TYPE.get(String.valueOf(opType)));
                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                return;
            }
            LinkedList<Modification> stateMods = pwpState.getModifications();
            if (stateMods != null && !stateMods.isEmpty() && (modifyOperation = conn.processModify(targetDN, stateMods)).getResultCode() != ResultCode.SUCCESS) {
                operation.setResultCode(modifyOperation.getResultCode());
                operation.setErrorMessage(modifyOperation.getErrorMessage());
                operation.setMatchedDN(modifyOperation.getMatchedDN());
                operation.setReferralURLs(modifyOperation.getReferralURLs());
                return;
            }
        }
        ArrayList<ASN1Element> opElements = new ArrayList<ASN1Element>();
        if (returnAll || returnTypes.contains(0)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(0, policy.getConfigEntryDN().toString()));
        }
        if (returnAll || returnTypes.contains(1)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(1, String.valueOf(pwpState.isDisabled())));
        }
        if (returnAll || returnTypes.contains(4)) {
            long expTime = pwpState.getAccountExpirationTime();
            String expTimeStr = expTime < 0L ? null : GeneralizedTimeSyntax.format(expTime);
            opElements.add(PasswordPolicyStateExtendedOperation.encode(4, expTimeStr));
        }
        if (returnAll || returnTypes.contains(7)) {
            long expTime = pwpState.getAccountExpirationTime();
            secondsStr = expTime < 0L ? null : String.valueOf((expTime - pwpState.getCurrentTime()) / 1000L);
            opElements.add(PasswordPolicyStateExtendedOperation.encode(7, secondsStr));
        }
        if (returnAll || returnTypes.contains(8)) {
            long changedTime = pwpState.getPasswordChangedTime();
            timeStr = changedTime < 0L ? null : GeneralizedTimeSyntax.format(changedTime);
            opElements.add(PasswordPolicyStateExtendedOperation.encode(8, timeStr));
        }
        if (returnAll || returnTypes.contains(11)) {
            long warnedTime = pwpState.getWarnedTime();
            timeStr = warnedTime < 0L ? null : GeneralizedTimeSyntax.format(warnedTime);
            opElements.add(PasswordPolicyStateExtendedOperation.encode(11, timeStr));
        }
        if (returnAll || returnTypes.contains(14)) {
            int secondsUntilExp = pwpState.getSecondsUntilExpiration();
            secondsStr = secondsUntilExp < 0 ? null : String.valueOf(secondsUntilExp);
            opElements.add(PasswordPolicyStateExtendedOperation.encode(14, (String)secondsStr));
        }
        if (returnAll || returnTypes.contains(15)) {
            int secondsUntilWarning;
            int secondsUntilExp = pwpState.getSecondsUntilExpiration();
            secondsStr = secondsUntilExp < 0 ? null : ((secondsUntilWarning = secondsUntilExp - policy.getWarningInterval()) <= 0 ? "0" : String.valueOf(secondsUntilWarning));
            opElements.add(PasswordPolicyStateExtendedOperation.encode(15, (String)secondsStr));
        }
        if (returnAll || returnTypes.contains(16)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(16, pwpState.getAuthFailureTimes()));
        }
        if (returnAll || returnTypes.contains(20)) {
            int seconds;
            secondsStr = pwpState.lockedDueToFailures() ? ((seconds = pwpState.getSecondsUntilUnlock()) <= 0 ? null : String.valueOf(seconds)) : null;
            opElements.add(PasswordPolicyStateExtendedOperation.encode(20, (String)secondsStr));
        }
        if (returnAll || returnTypes.contains(21)) {
            String remainingFailuresStr;
            int allowedFailureCount = policy.getLockoutFailureCount();
            if (allowedFailureCount > 0) {
                int remainingFailures = allowedFailureCount - pwpState.getAuthFailureTimes().size();
                if (remainingFailures < 0) {
                    remainingFailures = 0;
                }
                remainingFailuresStr = String.valueOf(remainingFailures);
            } else {
                remainingFailuresStr = null;
            }
            opElements.add(PasswordPolicyStateExtendedOperation.encode(21, remainingFailuresStr));
        }
        if (returnAll || returnTypes.contains(22)) {
            long lastLoginTime = pwpState.getLastLoginTime();
            timeStr = lastLoginTime < 0L ? null : GeneralizedTimeSyntax.format(lastLoginTime);
            opElements.add(PasswordPolicyStateExtendedOperation.encode(22, timeStr));
        }
        if (returnAll || returnTypes.contains(25)) {
            long currentTime;
            long lockoutTime;
            int secondsUntilLockout;
            long lastLoginTime;
            int lockoutInterval = policy.getIdleLockoutInterval();
            secondsStr = lockoutInterval > 0 ? ((lastLoginTime = pwpState.getLastLoginTime()) < 0L ? "0" : ((secondsUntilLockout = (int)(((lockoutTime = lastLoginTime + (long)(lockoutInterval * 1000)) - (currentTime = pwpState.getCurrentTime())) / 1000L)) <= 0 ? "0" : String.valueOf(secondsUntilLockout))) : null;
            opElements.add(PasswordPolicyStateExtendedOperation.encode(25, (String)secondsStr));
        }
        if (returnAll || returnTypes.contains(26)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(26, String.valueOf(pwpState.mustChangePassword())));
        }
        if (returnAll || returnTypes.contains(29)) {
            long changedTime;
            long currentTime;
            int changeAge;
            int timeToLockout;
            int maxAge;
            secondsStr = pwpState.mustChangePassword() ? ((maxAge = policy.getMaximumPasswordResetAge()) > 0 ? ((timeToLockout = maxAge - (changeAge = (int)(((currentTime = pwpState.getCurrentTime()) - (changedTime = pwpState.getPasswordChangedTime())) / 1000L))) <= 0 ? "0" : String.valueOf(timeToLockout)) : null) : null;
            opElements.add(PasswordPolicyStateExtendedOperation.encode(29, (String)secondsStr));
        }
        if (returnAll || returnTypes.contains(30)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(30, pwpState.getGraceLoginTimes()));
        }
        if (returnAll || returnTypes.contains(34)) {
            int remainingGraceLogins = pwpState.getGraceLoginsRemaining();
            String remainingStr = remainingGraceLogins <= 0 ? "0" : String.valueOf(remainingGraceLogins);
            opElements.add(PasswordPolicyStateExtendedOperation.encode(34, remainingStr));
        }
        if (returnAll || returnTypes.contains(35)) {
            long requiredChangeTime = pwpState.getRequiredChangeTime();
            timeStr = requiredChangeTime < 0L ? null : GeneralizedTimeSyntax.format(requiredChangeTime);
            opElements.add(PasswordPolicyStateExtendedOperation.encode(35, timeStr));
        }
        if (returnAll || returnTypes.contains(38)) {
            long currentTime;
            long accountRequiredChangeTime;
            long policyRequiredChangeTime = policy.getRequireChangeByTime();
            secondsStr = policyRequiredChangeTime > 0L ? ((accountRequiredChangeTime = pwpState.getRequiredChangeTime()) >= policyRequiredChangeTime ? null : ((currentTime = pwpState.getCurrentTime()) >= policyRequiredChangeTime ? "0" : String.valueOf((policyRequiredChangeTime - currentTime) / 1000L))) : null;
            opElements.add(PasswordPolicyStateExtendedOperation.encode(38, (String)secondsStr));
        }
        if (returnAll || returnTypes.contains(39)) {
            opElements.add(PasswordPolicyStateExtendedOperation.encode(39, pwpState.getPasswordHistoryValues()));
        }
        ArrayList<ASN1Element> responseValueElements = new ArrayList<ASN1Element>(2);
        responseValueElements.add(dnString);
        responseValueElements.add(new ASN1Sequence(opElements));
        ASN1OctetString responseValue = new ASN1OctetString(new ASN1Sequence(responseValueElements).encode());
        operation.setResponseOID("1.3.6.1.4.1.26027.1.6.1");
        operation.setResponseValue(responseValue);
        operation.setResultCode(ResultCode.SUCCESS);
    }

    public static ASN1Element encode(int opType, String value) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1Enumerated(opType));
        if (value != null) {
            ArrayList<ASN1Element> valueElements = new ArrayList<ASN1Element>(1);
            valueElements.add(new ASN1OctetString(value));
            elements.add(new ASN1Sequence(valueElements));
        }
        return new ASN1Sequence(elements);
    }

    public static ASN1Element encode(int opType, String[] values) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1Enumerated(opType));
        if (values != null && values.length > 0) {
            ArrayList<ASN1Element> valueElements = new ArrayList<ASN1Element>(values.length);
            for (int i = 0; i < values.length; ++i) {
                valueElements.add(new ASN1OctetString(values[i]));
            }
            elements.add(new ASN1Sequence(valueElements));
        }
        return new ASN1Sequence(elements);
    }

    public static ASN1Element encode(int opType, List<Long> values) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1Enumerated(opType));
        ArrayList<ASN1Element> valueElements = new ArrayList<ASN1Element>(values.size());
        for (long l : values) {
            valueElements.add(new ASN1OctetString(GeneralizedTimeSyntax.format(l)));
        }
        elements.add(new ASN1Sequence(valueElements));
        return new ASN1Sequence(elements);
    }
}

