/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Set;
import org.opends.server.controls.EntryChangeNotificationControl;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.workflowelement.localbackend.LocalBackendAddOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendDeleteOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyDNOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentSearch {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean returnECs;
    private DN baseDN;
    private Set<PersistentSearchChangeType> changeTypes;
    private SearchScope scope;
    private SearchFilter filter;
    private SearchOperation searchOperation;

    public PersistentSearch(SearchOperation searchOperation, Set<PersistentSearchChangeType> changeTypes, boolean returnECs) {
        this.searchOperation = searchOperation;
        this.changeTypes = changeTypes;
        this.returnECs = returnECs;
        this.baseDN = searchOperation.getBaseDN();
        this.scope = searchOperation.getScope();
        this.filter = searchOperation.getFilter();
    }

    public SearchOperation getSearchOperation() {
        return this.searchOperation;
    }

    public Set<PersistentSearchChangeType> getChangeTypes() {
        return this.changeTypes;
    }

    public boolean getReturnECs() {
        return this.returnECs;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public SearchFilter getFilter() {
        return this.filter;
    }

    public void processAdd(LocalBackendAddOperation addOperation, Entry entry) {
        block18: {
            if (!this.changeTypes.contains((Object)PersistentSearchChangeType.ADD)) {
                return;
            }
            switch (this.scope) {
                case BASE_OBJECT: {
                    if (this.baseDN.equals(entry.getDN())) break;
                    return;
                }
                case SINGLE_LEVEL: {
                    if (this.baseDN.equals(entry.getDN().getParentDNInSuffix())) break;
                    return;
                }
                case WHOLE_SUBTREE: {
                    if (this.baseDN.isAncestorOf(entry.getDN())) break;
                    return;
                }
                case SUBORDINATE_SUBTREE: {
                    if (!this.baseDN.equals(entry.getDN()) && this.baseDN.isAncestorOf(entry.getDN())) break;
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                if (!this.filter.matchesEntry(entry)) {
                    return;
                }
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                return;
            }
            ArrayList<Control> entryControls = new ArrayList<Control>(1);
            if (this.returnECs) {
                entryControls.add(new EntryChangeNotificationControl(PersistentSearchChangeType.ADD, addOperation.getChangeNumber()));
            }
            try {
                if (!this.searchOperation.returnEntry(entry, entryControls)) {
                    DirectoryServer.deregisterPersistentSearch(this);
                    this.searchOperation.sendSearchResultDone();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                DirectoryServer.deregisterPersistentSearch(this);
                try {
                    this.searchOperation.sendSearchResultDone();
                }
                catch (Exception e2) {
                    if (!DebugLogger.debugEnabled()) break block18;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
            }
        }
    }

    public void processDelete(LocalBackendDeleteOperation deleteOperation, Entry entry) {
        block18: {
            if (!this.changeTypes.contains((Object)PersistentSearchChangeType.DELETE)) {
                return;
            }
            switch (this.scope) {
                case BASE_OBJECT: {
                    if (this.baseDN.equals(entry.getDN())) break;
                    return;
                }
                case SINGLE_LEVEL: {
                    if (this.baseDN.equals(entry.getDN().getParentDNInSuffix())) break;
                    return;
                }
                case WHOLE_SUBTREE: {
                    if (this.baseDN.isAncestorOf(entry.getDN())) break;
                    return;
                }
                case SUBORDINATE_SUBTREE: {
                    if (!this.baseDN.equals(entry.getDN()) && this.baseDN.isAncestorOf(entry.getDN())) break;
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                if (!this.filter.matchesEntry(entry)) {
                    return;
                }
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                return;
            }
            ArrayList<Control> entryControls = new ArrayList<Control>(1);
            if (this.returnECs) {
                entryControls.add(new EntryChangeNotificationControl(PersistentSearchChangeType.DELETE, deleteOperation.getChangeNumber()));
            }
            try {
                if (!this.searchOperation.returnEntry(entry, entryControls)) {
                    DirectoryServer.deregisterPersistentSearch(this);
                    this.searchOperation.sendSearchResultDone();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                DirectoryServer.deregisterPersistentSearch(this);
                try {
                    this.searchOperation.sendSearchResultDone();
                }
                catch (Exception e2) {
                    if (!DebugLogger.debugEnabled()) break block18;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
            }
        }
    }

    public void processModify(LocalBackendModifyOperation modifyOperation, Entry oldEntry, Entry newEntry) {
        block18: {
            if (!this.changeTypes.contains((Object)PersistentSearchChangeType.MODIFY)) {
                return;
            }
            switch (this.scope) {
                case BASE_OBJECT: {
                    if (this.baseDN.equals(oldEntry.getDN())) break;
                    return;
                }
                case SINGLE_LEVEL: {
                    if (this.baseDN.equals(oldEntry.getDN().getParentDNInSuffix())) break;
                    return;
                }
                case WHOLE_SUBTREE: {
                    if (this.baseDN.isAncestorOf(oldEntry.getDN())) break;
                    return;
                }
                case SUBORDINATE_SUBTREE: {
                    if (!this.baseDN.equals(oldEntry.getDN()) && this.baseDN.isAncestorOf(oldEntry.getDN())) break;
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                if (!this.filter.matchesEntry(oldEntry) && !this.filter.matchesEntry(newEntry)) {
                    return;
                }
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                return;
            }
            ArrayList<Control> entryControls = new ArrayList<Control>(1);
            if (this.returnECs) {
                entryControls.add(new EntryChangeNotificationControl(PersistentSearchChangeType.MODIFY, modifyOperation.getChangeNumber()));
            }
            try {
                if (!this.searchOperation.returnEntry(newEntry, entryControls)) {
                    DirectoryServer.deregisterPersistentSearch(this);
                    this.searchOperation.sendSearchResultDone();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                DirectoryServer.deregisterPersistentSearch(this);
                try {
                    this.searchOperation.sendSearchResultDone();
                }
                catch (Exception e2) {
                    if (!DebugLogger.debugEnabled()) break block18;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
            }
        }
    }

    public void processModifyDN(LocalBackendModifyDNOperation modifyDNOperation, Entry oldEntry, Entry newEntry) {
        block18: {
            if (!this.changeTypes.contains((Object)PersistentSearchChangeType.MODIFY_DN)) {
                return;
            }
            boolean oldMatches = false;
            boolean newMatches = false;
            switch (this.scope) {
                case BASE_OBJECT: {
                    oldMatches = this.baseDN.equals(oldEntry.getDN());
                    newMatches = this.baseDN.equals(newEntry.getDN());
                    if (oldMatches || newMatches) break;
                    return;
                }
                case SINGLE_LEVEL: {
                    oldMatches = this.baseDN.equals(oldEntry.getDN().getParentDNInSuffix());
                    newMatches = this.baseDN.equals(newEntry.getDN().getParentDNInSuffix());
                    if (oldMatches || newMatches) break;
                    return;
                }
                case WHOLE_SUBTREE: {
                    oldMatches = this.baseDN.isAncestorOf(oldEntry.getDN());
                    newMatches = this.baseDN.isAncestorOf(newEntry.getDN());
                    if (oldMatches || newMatches) break;
                    return;
                }
                case SUBORDINATE_SUBTREE: {
                    oldMatches = !this.baseDN.equals(oldEntry.getDN()) && this.baseDN.isAncestorOf(oldEntry.getDN());
                    boolean bl = newMatches = !this.baseDN.equals(newEntry.getDN()) && this.baseDN.isAncestorOf(newEntry.getDN());
                    if (oldMatches || newMatches) break;
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                if (!(oldMatches && this.filter.matchesEntry(oldEntry) || newMatches || this.filter.matchesEntry(newEntry))) {
                    return;
                }
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                return;
            }
            ArrayList<Control> entryControls = new ArrayList<Control>(1);
            if (this.returnECs) {
                entryControls.add(new EntryChangeNotificationControl(PersistentSearchChangeType.MODIFY_DN, oldEntry.getDN(), modifyDNOperation.getChangeNumber()));
            }
            try {
                if (!this.searchOperation.returnEntry(newEntry, entryControls)) {
                    DirectoryServer.deregisterPersistentSearch(this);
                    this.searchOperation.sendSearchResultDone();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                DirectoryServer.deregisterPersistentSearch(this);
                try {
                    this.searchOperation.sendSearchResultDone();
                }
                catch (Exception e2) {
                    if (!DebugLogger.debugEnabled()) break block18;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("PersistentSearch(connID=");
        buffer.append(this.searchOperation.getConnectionID());
        buffer.append(",opID=");
        buffer.append(this.searchOperation.getOperationID());
        buffer.append(",baseDN=\"");
        this.searchOperation.getBaseDN().toString(buffer);
        buffer.append("\",scope=");
        buffer.append(this.scope.toString());
        buffer.append(",filter=\"");
        this.filter.toString(buffer);
        buffer.append("\")");
    }
}

