/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.AlertHandlerCfgDefn;
import org.opends.server.admin.std.server.AlertHandlerCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.AlertHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertHandlerConfigManager
implements ConfigurationChangeListener<AlertHandlerCfg>,
ConfigurationAddListener<AlertHandlerCfg>,
ConfigurationDeleteListener<AlertHandlerCfg> {
    private ConcurrentHashMap<DN, AlertHandler> alertHandlers = new ConcurrentHashMap();

    public void initializeAlertHandlers() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addAlertHandlerAddListener(this);
        rootConfiguration.addAlertHandlerDeleteListener(this);
        for (String name : rootConfiguration.listAlertHandlers()) {
            AlertHandlerCfg configuration = rootConfiguration.getAlertHandler(name);
            configuration.addChangeListener(this);
            if (!configuration.isEnabled()) continue;
            String className = configuration.getJavaClass();
            try {
                AlertHandler handler = this.loadHandler(className, configuration, true);
                this.alertHandlers.put(configuration.dn(), handler);
                DirectoryServer.registerAlertHandler(handler);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(AlertHandlerCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadHandler(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(AlertHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        AlertHandler alertHandler = null;
        String className = configuration.getJavaClass();
        try {
            alertHandler = this.loadHandler(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.alertHandlers.put(configuration.dn(), alertHandler);
            DirectoryServer.registerAlertHandler(alertHandler);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(AlertHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(AlertHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        AlertHandler alertHandler = this.alertHandlers.remove(configuration.dn());
        if (alertHandler != null) {
            DirectoryServer.deregisterAlertHandler(alertHandler);
            alertHandler.finalizeAlertHandler();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(AlertHandlerCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadHandler(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(AlertHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        AlertHandler existingHandler = this.alertHandlers.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingHandler != null) {
                DirectoryServer.deregisterAlertHandler(existingHandler);
                AlertHandler alertHandler = this.alertHandlers.remove(configuration.dn());
                if (alertHandler != null) {
                    alertHandler.finalizeAlertHandler();
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaClass();
        if (existingHandler != null) {
            if (!className.equals(existingHandler.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        AlertHandler alertHandler = null;
        try {
            alertHandler = this.loadHandler(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.alertHandlers.put(configuration.dn(), alertHandler);
            DirectoryServer.registerAlertHandler(alertHandler);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private AlertHandler loadHandler(String className, AlertHandlerCfg configuration, boolean initialize) throws InitializationException {
        try {
            AlertHandlerCfgDefn definition = AlertHandlerCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<AlertHandler> handlerClass = propertyDefinition.loadClass(className, AlertHandler.class);
            AlertHandler handler = handlerClass.newInstance();
            if (initialize) {
                Method method = handler.getClass().getMethod("initializeAlertHandler", configuration.configurationClass());
                method.invoke((Object)handler, configuration);
            } else {
                Method method = handler.getClass().getMethod("isConfigurationAcceptable", AlertHandlerCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)handler, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_ALERTHANDLER_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return handler;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_ALERTHANDLER_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

