/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigException;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=true, mayInvoke=true)
public abstract class ConfigAttribute {
    private boolean hasPendingValues;
    private boolean isMultiValued;
    private boolean isRequired;
    private boolean requiresAdminAction;
    private LinkedHashSet<AttributeValue> activeValues;
    private LinkedHashSet<AttributeValue> pendingValues;
    private Message description;
    private String name;

    protected ConfigAttribute(String name, Message description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction) {
        this.name = name;
        this.description = description;
        this.isRequired = isRequired;
        this.isMultiValued = isMultiValued;
        this.requiresAdminAction = requiresAdminAction;
        this.hasPendingValues = false;
        this.activeValues = new LinkedHashSet();
        this.pendingValues = this.activeValues;
    }

    protected ConfigAttribute(String name, Message description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, LinkedHashSet<AttributeValue> activeValues) {
        this.name = name;
        this.description = description;
        this.isRequired = isRequired;
        this.isMultiValued = isMultiValued;
        this.requiresAdminAction = requiresAdminAction;
        this.hasPendingValues = false;
        this.activeValues = activeValues == null ? new LinkedHashSet() : activeValues;
        this.pendingValues = this.activeValues;
    }

    protected ConfigAttribute(String name, Message description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, LinkedHashSet<AttributeValue> activeValues, boolean hasPendingValues, LinkedHashSet<AttributeValue> pendingValues) {
        this.name = name;
        this.description = description;
        this.isRequired = isRequired;
        this.isMultiValued = isMultiValued;
        this.requiresAdminAction = requiresAdminAction;
        this.hasPendingValues = hasPendingValues;
        this.activeValues = activeValues == null ? new LinkedHashSet() : activeValues;
        this.pendingValues = !hasPendingValues ? this.activeValues : (pendingValues == null ? new LinkedHashSet() : pendingValues);
    }

    public String getName() {
        return this.name;
    }

    public Message getDescription() {
        return this.description;
    }

    public abstract String getDataType();

    public abstract AttributeSyntax getSyntax();

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public boolean requiresAdminAction() {
        return this.requiresAdminAction;
    }

    public LinkedHashSet<AttributeValue> getActiveValues() {
        return this.activeValues;
    }

    public boolean hasPendingValues() {
        return this.hasPendingValues;
    }

    public LinkedHashSet<AttributeValue> getPendingValues() {
        if (this.requiresAdminAction) {
            return this.pendingValues;
        }
        return this.activeValues;
    }

    public abstract boolean valueIsAcceptable(AttributeValue var1, StringBuilder var2);

    protected void setValues(LinkedHashSet<AttributeValue> values) throws ConfigException {
        StringBuilder rejectReason;
        if (values == null || values.isEmpty()) {
            if (this.isRequired) {
                Message message = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(this.name);
                throw new ConfigException(message);
            }
            if (this.requiresAdminAction) {
                this.pendingValues = values == null ? new LinkedHashSet() : values;
                this.hasPendingValues = true;
            } else {
                this.activeValues = values == null ? new LinkedHashSet() : values;
                this.pendingValues = this.activeValues;
                this.hasPendingValues = false;
            }
            return;
        }
        Iterator iterator = values.iterator();
        AttributeValue value = (AttributeValue)iterator.next();
        if (!this.valueIsAcceptable(value, rejectReason = new StringBuilder())) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_REJECTED_VALUE.get(value.getStringValue(), this.name, rejectReason.toString());
            throw new ConfigException(message);
        }
        if (!this.isMultiValued && iterator.hasNext()) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_SET_VALUES_IS_SINGLE_VALUED.get(this.name);
            throw new ConfigException(message);
        }
        while (iterator.hasNext()) {
            value = (AttributeValue)iterator.next();
            if (this.valueIsAcceptable(value, rejectReason)) continue;
            Message message = ConfigMessages.ERR_CONFIG_ATTR_REJECTED_VALUE.get(value.getStringValue(), this.name, rejectReason.toString());
            throw new ConfigException(message);
        }
        if (this.requiresAdminAction) {
            this.pendingValues = values;
            this.hasPendingValues = true;
        } else {
            this.activeValues = values;
            this.pendingValues = this.activeValues;
            this.hasPendingValues = false;
        }
    }

    protected void setActiveValues(LinkedHashSet<AttributeValue> values) {
        this.activeValues = values;
    }

    protected void setPendingValues(LinkedHashSet<AttributeValue> values) {
        this.pendingValues = values;
        this.hasPendingValues = true;
    }

    protected void addValues(List<AttributeValue> values) throws ConfigException {
        LinkedHashSet<AttributeValue> tempValues;
        if (values == null) {
            return;
        }
        int numValues = values.size();
        if (numValues == 0) {
            return;
        }
        if (!this.isMultiValued && (numValues > 1 || this.hasPendingValues && this.pendingValues.size() > 0 || !this.hasPendingValues && this.activeValues.size() > 0)) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_ADD_VALUES_IS_SINGLE_VALUED.get(this.name);
            throw new ConfigException(message);
        }
        if (this.requiresAdminAction && this.hasPendingValues) {
            tempValues = new LinkedHashSet(this.pendingValues.size() + numValues);
            tempValues.addAll(this.pendingValues);
        } else {
            tempValues = new LinkedHashSet<AttributeValue>(this.activeValues.size() + numValues);
            tempValues.addAll(this.activeValues);
        }
        StringBuilder rejectReason = new StringBuilder();
        for (AttributeValue value : values) {
            if (tempValues.contains(value)) {
                Message message = ConfigMessages.ERR_CONFIG_ATTR_ADD_VALUES_ALREADY_EXISTS.get(this.name, value.getStringValue());
                throw new ConfigException(message);
            }
            if (this.valueIsAcceptable(value, rejectReason)) continue;
            Message message = ConfigMessages.ERR_CONFIG_ATTR_REJECTED_VALUE.get(value.getStringValue(), this.name, rejectReason.toString());
            throw new ConfigException(message);
        }
        if (this.requiresAdminAction) {
            this.pendingValues = tempValues;
            this.hasPendingValues = true;
        } else {
            this.activeValues = tempValues;
            this.pendingValues = tempValues;
            this.hasPendingValues = false;
        }
    }

    protected void removeValues(List<AttributeValue> values) throws ConfigException {
        LinkedHashSet<AttributeValue> tempValues;
        if (this.requiresAdminAction && this.hasPendingValues) {
            tempValues = new LinkedHashSet(this.pendingValues.size());
            tempValues.addAll(this.pendingValues);
        } else {
            tempValues = new LinkedHashSet<AttributeValue>(this.activeValues.size());
            tempValues.addAll(this.activeValues);
        }
        for (AttributeValue value : values) {
            if (tempValues.remove(value)) continue;
            Message message = ConfigMessages.ERR_CONFIG_ATTR_NO_SUCH_VALUE.get(this.name, value.getStringValue());
            throw new ConfigException(message);
        }
        if (this.isRequired && tempValues.isEmpty()) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(this.name);
            throw new ConfigException(message);
        }
        if (this.requiresAdminAction) {
            this.pendingValues = tempValues;
            this.hasPendingValues = true;
        } else {
            this.activeValues = tempValues;
            this.pendingValues = tempValues;
            this.hasPendingValues = false;
        }
    }

    protected void removeAllValues() throws ConfigException {
        if (this.isRequired) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_IS_REQUIRED.get(this.name);
            throw new ConfigException(message);
        }
        if (this.requiresAdminAction) {
            if (this.pendingValues == null) {
                this.pendingValues = new LinkedHashSet();
            } else {
                this.pendingValues.clear();
            }
            this.hasPendingValues = true;
        } else {
            this.activeValues.clear();
            this.pendingValues = this.activeValues;
            this.hasPendingValues = false;
        }
    }

    public void setInitialValues(LinkedHashSet<AttributeValue> values) {
        if (values == null) {
            values = new LinkedHashSet();
        }
        this.activeValues = values;
        this.pendingValues = values;
        this.hasPendingValues = false;
    }

    public void applyPendingValues() {
        if (this.hasPendingValues) {
            this.activeValues = this.pendingValues;
            this.hasPendingValues = false;
        }
    }

    public abstract LinkedHashSet<AttributeValue> stringsToValues(List<String> var1, boolean var2) throws ConfigException;

    public abstract List<String> activeValuesToStrings();

    public abstract List<String> pendingValuesToStrings();

    public abstract ConfigAttribute getConfigAttribute(List<Attribute> var1) throws ConfigException;

    public abstract javax.management.Attribute toJMXAttribute();

    public abstract javax.management.Attribute toJMXAttributePending();

    public abstract void toJMXAttribute(AttributeList var1);

    public abstract void toJMXAttributeInfo(List<MBeanAttributeInfo> var1);

    public abstract MBeanParameterInfo toJMXParameterInfo();

    public abstract void setValue(javax.management.Attribute var1) throws ConfigException;

    public abstract ConfigAttribute duplicate();
}

