/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.admin.std.server.LocalDBIndexCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.backends.jeb.ApproximateIndexer;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.EqualityIndexer;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexBuffer;
import org.opends.server.backends.jeb.OrderingIndexer;
import org.opends.server.backends.jeb.PresenceIndexer;
import org.opends.server.backends.jeb.State;
import org.opends.server.backends.jeb.SubstringIndexer;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeIndex
implements ConfigurationChangeListener<LocalDBIndexCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final DatabaseEntry presenceKey = new DatabaseEntry("+".getBytes());
    private EntryContainer entryContainer;
    private Environment env;
    private LocalDBIndexCfg indexConfig;
    Index equalityIndex = null;
    Index presenceIndex = null;
    Index substringIndex = null;
    Index orderingIndex = null;
    Index approximateIndex = null;
    private State state;
    private int cursorEntryLimit = 100000;

    public AttributeIndex(LocalDBIndexCfg indexConfig, State state, Environment env, EntryContainer entryContainer) throws DatabaseException, ConfigException {
        Message message;
        this.entryContainer = entryContainer;
        this.env = env;
        this.indexConfig = indexConfig;
        this.state = state;
        AttributeType attrType = indexConfig.getAttribute();
        String name = entryContainer.getDatabasePrefix() + "_" + attrType.getNameOrOID();
        int indexEntryLimit = indexConfig.getIndexEntryLimit();
        if (indexConfig.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.EQUALITY)) {
            if (attrType.getEqualityMatchingRule() == null) {
                Message message2 = JebMessages.ERR_CONFIG_INDEX_TYPE_NEEDS_MATCHING_RULE.get(String.valueOf(attrType), "equality");
                throw new ConfigException(message2);
            }
            EqualityIndexer equalityIndexer = new EqualityIndexer(attrType);
            this.equalityIndex = new Index(name + ".equality", equalityIndexer, state, indexEntryLimit, this.cursorEntryLimit, false, env, entryContainer);
        }
        if (indexConfig.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.PRESENCE)) {
            PresenceIndexer presenceIndexer = new PresenceIndexer(attrType);
            this.presenceIndex = new Index(name + ".presence", presenceIndexer, state, indexEntryLimit, this.cursorEntryLimit, false, env, entryContainer);
        }
        if (indexConfig.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.SUBSTRING)) {
            if (attrType.getSubstringMatchingRule() == null) {
                message = JebMessages.ERR_CONFIG_INDEX_TYPE_NEEDS_MATCHING_RULE.get(String.valueOf(attrType), "substring");
                throw new ConfigException(message);
            }
            SubstringIndexer substringIndexer = new SubstringIndexer(attrType, indexConfig.getSubstringLength());
            this.substringIndex = new Index(name + ".substring", substringIndexer, state, indexEntryLimit, this.cursorEntryLimit, false, env, entryContainer);
        }
        if (indexConfig.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.ORDERING)) {
            if (attrType.getOrderingMatchingRule() == null) {
                message = JebMessages.ERR_CONFIG_INDEX_TYPE_NEEDS_MATCHING_RULE.get(String.valueOf(attrType), "ordering");
                throw new ConfigException(message);
            }
            OrderingIndexer orderingIndexer = new OrderingIndexer(attrType);
            this.orderingIndex = new Index(name + ".ordering", orderingIndexer, state, indexEntryLimit, this.cursorEntryLimit, false, env, entryContainer);
        }
        if (indexConfig.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.APPROXIMATE)) {
            if (attrType.getApproximateMatchingRule() == null) {
                message = JebMessages.ERR_CONFIG_INDEX_TYPE_NEEDS_MATCHING_RULE.get(String.valueOf(attrType), "approximate");
                throw new ConfigException(message);
            }
            ApproximateIndexer approximateIndexer = new ApproximateIndexer(attrType);
            this.approximateIndex = new Index(name + ".approximate", approximateIndexer, state, indexEntryLimit, this.cursorEntryLimit, false, env, entryContainer);
        }
        this.indexConfig.addChangeListener(this);
    }

    public void open() throws DatabaseException {
        if (this.equalityIndex != null) {
            this.equalityIndex.open();
        }
        if (this.presenceIndex != null) {
            this.presenceIndex.open();
        }
        if (this.substringIndex != null) {
            this.substringIndex.open();
        }
        if (this.orderingIndex != null) {
            this.orderingIndex.open();
        }
        if (this.approximateIndex != null) {
            this.approximateIndex.open();
        }
    }

    public void close() throws DatabaseException {
        if (this.equalityIndex != null) {
            this.equalityIndex.close();
        }
        if (this.presenceIndex != null) {
            this.presenceIndex.close();
        }
        if (this.substringIndex != null) {
            this.substringIndex.close();
        }
        if (this.orderingIndex != null) {
            this.orderingIndex.close();
        }
        if (this.approximateIndex != null) {
            this.approximateIndex.close();
        }
        this.indexConfig.removeChangeListener(this);
    }

    public AttributeType getAttributeType() {
        return this.indexConfig.getAttribute();
    }

    public LocalDBIndexCfg getConfiguration() {
        return this.indexConfig;
    }

    public boolean addEntry(IndexBuffer buffer, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        boolean success = true;
        if (this.equalityIndex != null && !this.equalityIndex.addEntry(buffer, entryID, entry)) {
            success = false;
        }
        if (this.presenceIndex != null && !this.presenceIndex.addEntry(buffer, entryID, entry)) {
            success = false;
        }
        if (this.substringIndex != null && !this.substringIndex.addEntry(buffer, entryID, entry)) {
            success = false;
        }
        if (this.orderingIndex != null && !this.orderingIndex.addEntry(buffer, entryID, entry)) {
            success = false;
        }
        if (this.approximateIndex != null && !this.approximateIndex.addEntry(buffer, entryID, entry)) {
            success = false;
        }
        return success;
    }

    public boolean addEntry(Transaction txn, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        boolean success = true;
        if (this.equalityIndex != null && !this.equalityIndex.addEntry(txn, entryID, entry)) {
            success = false;
        }
        if (this.presenceIndex != null && !this.presenceIndex.addEntry(txn, entryID, entry)) {
            success = false;
        }
        if (this.substringIndex != null && !this.substringIndex.addEntry(txn, entryID, entry)) {
            success = false;
        }
        if (this.orderingIndex != null && !this.orderingIndex.addEntry(txn, entryID, entry)) {
            success = false;
        }
        if (this.approximateIndex != null && !this.approximateIndex.addEntry(txn, entryID, entry)) {
            success = false;
        }
        return success;
    }

    public void removeEntry(IndexBuffer buffer, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        if (this.equalityIndex != null) {
            this.equalityIndex.removeEntry(buffer, entryID, entry);
        }
        if (this.presenceIndex != null) {
            this.presenceIndex.removeEntry(buffer, entryID, entry);
        }
        if (this.substringIndex != null) {
            this.substringIndex.removeEntry(buffer, entryID, entry);
        }
        if (this.orderingIndex != null) {
            this.orderingIndex.removeEntry(buffer, entryID, entry);
        }
        if (this.approximateIndex != null) {
            this.approximateIndex.removeEntry(buffer, entryID, entry);
        }
    }

    public void removeEntry(Transaction txn, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException {
        if (this.equalityIndex != null) {
            this.equalityIndex.removeEntry(txn, entryID, entry);
        }
        if (this.presenceIndex != null) {
            this.presenceIndex.removeEntry(txn, entryID, entry);
        }
        if (this.substringIndex != null) {
            this.substringIndex.removeEntry(txn, entryID, entry);
        }
        if (this.orderingIndex != null) {
            this.orderingIndex.removeEntry(txn, entryID, entry);
        }
        if (this.approximateIndex != null) {
            this.approximateIndex.removeEntry(txn, entryID, entry);
        }
    }

    public void modifyEntry(Transaction txn, EntryID entryID, Entry oldEntry, Entry newEntry, List<Modification> mods) throws DatabaseException {
        if (this.equalityIndex != null) {
            this.equalityIndex.modifyEntry(txn, entryID, oldEntry, newEntry, mods);
        }
        if (this.presenceIndex != null) {
            this.presenceIndex.modifyEntry(txn, entryID, oldEntry, newEntry, mods);
        }
        if (this.substringIndex != null) {
            this.substringIndex.modifyEntry(txn, entryID, oldEntry, newEntry, mods);
        }
        if (this.orderingIndex != null) {
            this.orderingIndex.modifyEntry(txn, entryID, oldEntry, newEntry, mods);
        }
        if (this.approximateIndex != null) {
            this.approximateIndex.modifyEntry(txn, entryID, oldEntry, newEntry, mods);
        }
    }

    public void modifyEntry(IndexBuffer buffer, EntryID entryID, Entry oldEntry, Entry newEntry, List<Modification> mods) throws DatabaseException {
        if (this.equalityIndex != null) {
            this.equalityIndex.modifyEntry(buffer, entryID, oldEntry, newEntry, mods);
        }
        if (this.presenceIndex != null) {
            this.presenceIndex.modifyEntry(buffer, entryID, oldEntry, newEntry, mods);
        }
        if (this.substringIndex != null) {
            this.substringIndex.modifyEntry(buffer, entryID, oldEntry, newEntry, mods);
        }
        if (this.orderingIndex != null) {
            this.orderingIndex.modifyEntry(buffer, entryID, oldEntry, newEntry, mods);
        }
        if (this.approximateIndex != null) {
            this.approximateIndex.modifyEntry(buffer, entryID, oldEntry, newEntry, mods);
        }
    }

    private byte[] makeSubstringKey(byte[] bytes, int pos, int len) {
        byte[] keyBytes = new byte[len];
        System.arraycopy(bytes, pos, keyBytes, 0, len);
        return keyBytes;
    }

    Set<ByteString> substringKeys(byte[] value) {
        HashSet<ByteString> set = new HashSet<ByteString>();
        int substrLength = this.indexConfig.getSubstringLength();
        int i = 0;
        for (int remain = value.length; remain > 0; --remain) {
            int len = Math.min(substrLength, remain);
            byte[] keyBytes = this.makeSubstringKey(value, i, len);
            set.add(new ASN1OctetString(keyBytes));
            ++i;
        }
        return set;
    }

    private EntryIDSet matchSubstring(byte[] bytes) {
        int substrLength = this.indexConfig.getSubstringLength();
        if (bytes.length < substrLength) {
            byte[] lower = this.makeSubstringKey(bytes, 0, bytes.length);
            byte[] upper = this.makeSubstringKey(bytes, 0, bytes.length);
            for (int i = upper.length - 1; i >= 0; --i) {
                if (upper[i] != 255) {
                    upper[i] = (byte)(upper[i] + 1);
                    break;
                }
                upper[i] = 0;
            }
            return this.substringIndex.readRange(lower, upper, true, false);
        }
        TreeSet<byte[]> set = new TreeSet<byte[]>(this.substringIndex.indexer.getComparator());
        int first = 0;
        for (int last = substrLength; last <= bytes.length; ++last) {
            byte[] keyBytes = this.makeSubstringKey(bytes, first, substrLength);
            set.add(keyBytes);
            ++first;
        }
        EntryIDSet results = new EntryIDSet();
        DatabaseEntry key = new DatabaseEntry();
        for (byte[] keyBytes : set) {
            key.setData(keyBytes);
            EntryIDSet list = this.substringIndex.readKey(key, null, LockMode.DEFAULT);
            results.retainAll(list);
            if (!results.isDefined() || results.size() > 10L) continue;
            break;
        }
        return results;
    }

    private EntryIDSet matchInitialSubstring(byte[] bytes) {
        byte[] lower = bytes;
        byte[] upper = new byte[bytes.length];
        System.arraycopy(bytes, 0, upper, 0, bytes.length);
        for (int i = upper.length - 1; i >= 0; --i) {
            if (upper[i] != 255) {
                upper[i] = (byte)(upper[i] + 1);
                break;
            }
            upper[i] = 0;
        }
        return this.equalityIndex.readRange(lower, upper, true, false);
    }

    public EntryIDSet evaluateEqualityFilter(SearchFilter equalityFilter, StringBuilder debugBuffer) {
        if (this.equalityIndex == null) {
            return new EntryIDSet();
        }
        try {
            byte[] keyBytes = equalityFilter.getAssertionValue().getNormalizedValue().value();
            DatabaseEntry key = new DatabaseEntry(keyBytes);
            if (debugBuffer != null) {
                debugBuffer.append("[INDEX:");
                debugBuffer.append(this.indexConfig.getAttribute().getNameOrOID());
                debugBuffer.append(".");
                debugBuffer.append("equality]");
            }
            return this.equalityIndex.readKey(key, null, LockMode.DEFAULT);
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return new EntryIDSet();
        }
    }

    public EntryIDSet evaluatePresenceFilter(SearchFilter filter, StringBuilder debugBuffer) {
        if (this.presenceIndex == null) {
            return new EntryIDSet();
        }
        if (debugBuffer != null) {
            debugBuffer.append("[INDEX:");
            debugBuffer.append(this.indexConfig.getAttribute().getNameOrOID());
            debugBuffer.append(".");
            debugBuffer.append("presence]");
        }
        return this.presenceIndex.readKey(presenceKey, null, LockMode.DEFAULT);
    }

    public EntryIDSet evaluateGreaterOrEqualFilter(SearchFilter filter, StringBuilder debugBuffer) {
        if (this.orderingIndex == null) {
            return new EntryIDSet();
        }
        try {
            OrderingMatchingRule orderingRule = filter.getAttributeType().getOrderingMatchingRule();
            byte[] lower = orderingRule.normalizeValue(filter.getAssertionValue().getValue()).value();
            byte[] upper = new byte[]{};
            if (debugBuffer != null) {
                debugBuffer.append("[INDEX:");
                debugBuffer.append(this.indexConfig.getAttribute().getNameOrOID());
                debugBuffer.append(".");
                debugBuffer.append("ordering]");
            }
            return this.orderingIndex.readRange(lower, upper, true, false);
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return new EntryIDSet();
        }
    }

    public EntryIDSet evaluateLessOrEqualFilter(SearchFilter filter, StringBuilder debugBuffer) {
        if (this.orderingIndex == null) {
            return new EntryIDSet();
        }
        try {
            byte[] lower = new byte[]{};
            OrderingMatchingRule orderingRule = filter.getAttributeType().getOrderingMatchingRule();
            byte[] upper = orderingRule.normalizeValue(filter.getAssertionValue().getValue()).value();
            if (debugBuffer != null) {
                debugBuffer.append("[INDEX:");
                debugBuffer.append(this.indexConfig.getAttribute().getNameOrOID());
                debugBuffer.append(".");
                debugBuffer.append("ordering]");
            }
            return this.orderingIndex.readRange(lower, upper, false, true);
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return new EntryIDSet();
        }
    }

    public EntryIDSet evaluateSubstringFilter(SearchFilter filter, StringBuilder debugBuffer) {
        SubstringMatchingRule matchRule = filter.getAttributeType().getSubstringMatchingRule();
        try {
            ArrayList<ByteString> elements = new ArrayList<ByteString>();
            EntryIDSet results = new EntryIDSet();
            if (filter.getSubInitialElement() != null) {
                if (this.equalityIndex != null) {
                    ByteString normValue = matchRule.normalizeSubstring(filter.getSubInitialElement());
                    byte[] normBytes = normValue.value();
                    EntryIDSet list = this.matchInitialSubstring(normBytes);
                    results.retainAll(list);
                    if (results.isDefined() && results.size() <= 10L) {
                        if (debugBuffer != null) {
                            debugBuffer.append("[INDEX:");
                            debugBuffer.append(this.indexConfig.getAttribute().getNameOrOID());
                            debugBuffer.append(".");
                            debugBuffer.append("equality]");
                        }
                        return results;
                    }
                } else {
                    elements.add(filter.getSubInitialElement());
                }
            }
            if (this.substringIndex == null) {
                return results;
            }
            elements.addAll(filter.getSubAnyElements());
            if (filter.getSubFinalElement() != null) {
                elements.add(filter.getSubFinalElement());
            }
            for (ByteString element : elements) {
                ByteString normValue = matchRule.normalizeSubstring(element);
                byte[] normBytes = normValue.value();
                EntryIDSet list = this.matchSubstring(normBytes);
                results.retainAll(list);
                if (!results.isDefined() || results.size() > 10L) continue;
                break;
            }
            if (debugBuffer != null) {
                debugBuffer.append("[INDEX:");
                debugBuffer.append(this.indexConfig.getAttribute().getNameOrOID());
                debugBuffer.append(".");
                debugBuffer.append("substring]");
            }
            return results;
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return new EntryIDSet();
        }
    }

    public EntryIDSet evaluateBoundedRange(AttributeValue lowerValue, AttributeValue upperValue) {
        if (this.orderingIndex == null) {
            return new EntryIDSet();
        }
        try {
            OrderingMatchingRule orderingRule = this.getAttributeType().getOrderingMatchingRule();
            byte[] lower = orderingRule.normalizeValue(lowerValue.getValue()).value();
            byte[] upper = orderingRule.normalizeValue(upperValue.getValue()).value();
            return this.orderingIndex.readRange(lower, upper, true, true);
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return new EntryIDSet();
        }
    }

    public EntryIDSet evaluateApproximateFilter(SearchFilter approximateFilter, StringBuilder debugBuffer) {
        if (this.approximateIndex == null) {
            return new EntryIDSet();
        }
        try {
            ApproximateMatchingRule approximateMatchingRule = approximateFilter.getAttributeType().getApproximateMatchingRule();
            byte[] keyBytes = approximateMatchingRule.normalizeValue(approximateFilter.getAssertionValue().getValue()).value();
            DatabaseEntry key = new DatabaseEntry(keyBytes);
            if (debugBuffer != null) {
                debugBuffer.append("[INDEX:");
                debugBuffer.append(this.indexConfig.getAttribute().getNameOrOID());
                debugBuffer.append(".");
                debugBuffer.append("approximate]");
            }
            return this.approximateIndex.readKey(key, null, LockMode.DEFAULT);
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return new EntryIDSet();
        }
    }

    public void closeCursors() throws DatabaseException {
        if (this.equalityIndex != null) {
            this.equalityIndex.closeCursor();
        }
        if (this.presenceIndex != null) {
            this.presenceIndex.closeCursor();
        }
        if (this.substringIndex != null) {
            this.substringIndex.closeCursor();
        }
        if (this.orderingIndex != null) {
            this.orderingIndex.closeCursor();
        }
        if (this.approximateIndex != null) {
            this.approximateIndex.closeCursor();
        }
    }

    public long getEntryLimitExceededCount() {
        long entryLimitExceededCount = 0L;
        if (this.equalityIndex != null) {
            entryLimitExceededCount += (long)this.equalityIndex.getEntryLimitExceededCount();
        }
        if (this.presenceIndex != null) {
            entryLimitExceededCount += (long)this.presenceIndex.getEntryLimitExceededCount();
        }
        if (this.substringIndex != null) {
            entryLimitExceededCount += (long)this.substringIndex.getEntryLimitExceededCount();
        }
        if (this.orderingIndex != null) {
            entryLimitExceededCount += (long)this.orderingIndex.getEntryLimitExceededCount();
        }
        if (this.approximateIndex != null) {
            entryLimitExceededCount += (long)this.approximateIndex.getEntryLimitExceededCount();
        }
        return entryLimitExceededCount;
    }

    public void listDatabases(List<DatabaseContainer> dbList) {
        if (this.equalityIndex != null) {
            dbList.add(this.equalityIndex);
        }
        if (this.presenceIndex != null) {
            dbList.add(this.presenceIndex);
        }
        if (this.substringIndex != null) {
            dbList.add(this.substringIndex);
        }
        if (this.orderingIndex != null) {
            dbList.add(this.orderingIndex);
        }
        if (this.approximateIndex != null) {
            dbList.add(this.approximateIndex);
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public synchronized boolean isConfigurationChangeAcceptable(LocalDBIndexCfg cfg, List<Message> unacceptableReasons) {
        AttributeType attrType = cfg.getAttribute();
        if (cfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.EQUALITY) && this.equalityIndex == null && attrType.getEqualityMatchingRule() == null) {
            Message message = JebMessages.ERR_CONFIG_INDEX_TYPE_NEEDS_MATCHING_RULE.get(String.valueOf(String.valueOf(attrType)), "equality");
            unacceptableReasons.add(message);
            return false;
        }
        if (cfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.SUBSTRING) && this.substringIndex == null && attrType.getSubstringMatchingRule() == null) {
            Message message = JebMessages.ERR_CONFIG_INDEX_TYPE_NEEDS_MATCHING_RULE.get(String.valueOf(attrType), "substring");
            unacceptableReasons.add(message);
            return false;
        }
        if (cfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.ORDERING) && this.orderingIndex == null && attrType.getOrderingMatchingRule() == null) {
            Message message = JebMessages.ERR_CONFIG_INDEX_TYPE_NEEDS_MATCHING_RULE.get(String.valueOf(attrType), "ordering");
            unacceptableReasons.add(message);
            return false;
        }
        if (cfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.APPROXIMATE) && this.approximateIndex == null && attrType.getApproximateMatchingRule() == null) {
            Message message = JebMessages.ERR_CONFIG_INDEX_TYPE_NEEDS_MATCHING_RULE.get(String.valueOf(attrType), "approximate");
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized ConfigChangeResult applyConfigurationChange(LocalDBIndexCfg cfg) {
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            block52: {
                block57: {
                    Message message;
                    int indexEntryLimit;
                    String name;
                    AttributeType attrType;
                    block51: {
                        block56: {
                            block50: {
                                block55: {
                                    SubstringIndexer substringIndexer;
                                    block49: {
                                        block54: {
                                            block48: {
                                                block53: {
                                                    attrType = cfg.getAttribute();
                                                    name = this.entryContainer.getDatabasePrefix() + "_" + attrType.getNameOrOID();
                                                    indexEntryLimit = cfg.getIndexEntryLimit();
                                                    if (!cfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.EQUALITY)) break block53;
                                                    if (this.equalityIndex == null) {
                                                        EqualityIndexer equalityIndexer = new EqualityIndexer(attrType);
                                                        this.equalityIndex = new Index(name + ".equality", equalityIndexer, this.state, indexEntryLimit, this.cursorEntryLimit, false, this.env, this.entryContainer);
                                                        this.equalityIndex.open();
                                                        adminActionRequired = true;
                                                        messages.add(JebMessages.NOTE_JEB_INDEX_ADD_REQUIRES_REBUILD.get(name + ".equality"));
                                                        break block48;
                                                    } else if (this.equalityIndex.setIndexEntryLimit(indexEntryLimit)) {
                                                        adminActionRequired = true;
                                                        message = JebMessages.NOTE_JEB_CONFIG_INDEX_ENTRY_LIMIT_REQUIRES_REBUILD.get(name + ".equality");
                                                        messages.add(message);
                                                        this.equalityIndex.setIndexEntryLimit(indexEntryLimit);
                                                    }
                                                    break block48;
                                                }
                                                if (this.equalityIndex != null) {
                                                    this.entryContainer.exclusiveLock.lock();
                                                    try {
                                                        this.entryContainer.deleteDatabase(this.equalityIndex);
                                                        this.equalityIndex = null;
                                                    }
                                                    catch (DatabaseException de) {
                                                        ConfigChangeResult ccr;
                                                        messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(de), new Object[0]));
                                                        ConfigChangeResult configChangeResult = ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
                                                        return configChangeResult;
                                                    }
                                                    finally {
                                                        this.entryContainer.exclusiveLock.unlock();
                                                    }
                                                }
                                            }
                                            if (!cfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.PRESENCE)) break block54;
                                            if (this.presenceIndex == null) {
                                                PresenceIndexer presenceIndexer = new PresenceIndexer(attrType);
                                                this.presenceIndex = new Index(name + ".presence", presenceIndexer, this.state, indexEntryLimit, this.cursorEntryLimit, false, this.env, this.entryContainer);
                                                this.presenceIndex.open();
                                                adminActionRequired = true;
                                                messages.add(JebMessages.NOTE_JEB_INDEX_ADD_REQUIRES_REBUILD.get(name + ".presence"));
                                                break block49;
                                            } else if (this.presenceIndex.setIndexEntryLimit(indexEntryLimit)) {
                                                adminActionRequired = true;
                                                message = JebMessages.NOTE_JEB_CONFIG_INDEX_ENTRY_LIMIT_REQUIRES_REBUILD.get(name + ".presence");
                                                messages.add(message);
                                            }
                                            break block49;
                                        }
                                        if (this.presenceIndex != null) {
                                            this.entryContainer.exclusiveLock.lock();
                                            try {
                                                this.entryContainer.deleteDatabase(this.presenceIndex);
                                                this.presenceIndex = null;
                                            }
                                            catch (DatabaseException de) {
                                                ConfigChangeResult ccr;
                                                messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(de), new Object[0]));
                                                ConfigChangeResult configChangeResult = ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
                                                return configChangeResult;
                                            }
                                            finally {
                                                this.entryContainer.exclusiveLock.unlock();
                                            }
                                        }
                                    }
                                    if (!cfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.SUBSTRING)) break block55;
                                    if (this.substringIndex == null) {
                                        substringIndexer = new SubstringIndexer(attrType, cfg.getSubstringLength());
                                        this.substringIndex = new Index(name + ".substring", substringIndexer, this.state, indexEntryLimit, this.cursorEntryLimit, false, this.env, this.entryContainer);
                                        this.substringIndex.open();
                                        adminActionRequired = true;
                                        messages.add(JebMessages.NOTE_JEB_INDEX_ADD_REQUIRES_REBUILD.get(name + ".substring"));
                                        break block50;
                                    } else {
                                        if (this.substringIndex.setIndexEntryLimit(indexEntryLimit)) {
                                            adminActionRequired = true;
                                            message = JebMessages.NOTE_JEB_CONFIG_INDEX_ENTRY_LIMIT_REQUIRES_REBUILD.get(name + ".substring");
                                            messages.add(message);
                                        }
                                        if (this.indexConfig.getSubstringLength() != cfg.getSubstringLength()) {
                                            substringIndexer = new SubstringIndexer(attrType, cfg.getSubstringLength());
                                            this.substringIndex.setIndexer(substringIndexer);
                                        }
                                    }
                                    break block50;
                                }
                                if (this.substringIndex != null) {
                                    this.entryContainer.exclusiveLock.lock();
                                    try {
                                        this.entryContainer.deleteDatabase(this.substringIndex);
                                        this.substringIndex = null;
                                    }
                                    catch (DatabaseException de) {
                                        ConfigChangeResult ccr;
                                        messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(de), new Object[0]));
                                        ConfigChangeResult configChangeResult = ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
                                        return configChangeResult;
                                    }
                                    finally {
                                        this.entryContainer.exclusiveLock.unlock();
                                    }
                                }
                            }
                            if (!cfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.ORDERING)) break block56;
                            if (this.orderingIndex == null) {
                                OrderingIndexer orderingIndexer = new OrderingIndexer(attrType);
                                this.orderingIndex = new Index(name + ".ordering", orderingIndexer, this.state, indexEntryLimit, this.cursorEntryLimit, false, this.env, this.entryContainer);
                                this.orderingIndex.open();
                                adminActionRequired = true;
                                messages.add(JebMessages.NOTE_JEB_INDEX_ADD_REQUIRES_REBUILD.get(name + ".ordering"));
                                break block51;
                            } else if (this.orderingIndex.setIndexEntryLimit(indexEntryLimit)) {
                                adminActionRequired = true;
                                message = JebMessages.NOTE_JEB_CONFIG_INDEX_ENTRY_LIMIT_REQUIRES_REBUILD.get(name + ".ordering");
                                messages.add(message);
                            }
                            break block51;
                        }
                        if (this.orderingIndex != null) {
                            this.entryContainer.exclusiveLock.lock();
                            try {
                                this.entryContainer.deleteDatabase(this.orderingIndex);
                                this.orderingIndex = null;
                            }
                            catch (DatabaseException de) {
                                ConfigChangeResult ccr;
                                messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(de), new Object[0]));
                                ConfigChangeResult configChangeResult = ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
                                return configChangeResult;
                            }
                            finally {
                                this.entryContainer.exclusiveLock.unlock();
                            }
                        }
                    }
                    if (!cfg.getIndexType().contains((Object)LocalDBIndexCfgDefn.IndexType.APPROXIMATE)) break block57;
                    if (this.approximateIndex == null) {
                        ApproximateIndexer approximateIndexer = new ApproximateIndexer(attrType);
                        this.approximateIndex = new Index(name + ".approximate", approximateIndexer, this.state, indexEntryLimit, this.cursorEntryLimit, false, this.env, this.entryContainer);
                        this.approximateIndex.open();
                        adminActionRequired = true;
                        messages.add(JebMessages.NOTE_JEB_INDEX_ADD_REQUIRES_REBUILD.get(name + ".approximate"));
                        break block52;
                    } else if (this.approximateIndex.setIndexEntryLimit(indexEntryLimit)) {
                        adminActionRequired = true;
                        message = JebMessages.NOTE_JEB_CONFIG_INDEX_ENTRY_LIMIT_REQUIRES_REBUILD.get(name + ".approximate");
                        messages.add(message);
                    }
                    break block52;
                }
                if (this.approximateIndex != null) {
                    this.entryContainer.exclusiveLock.lock();
                    try {
                        this.entryContainer.deleteDatabase(this.approximateIndex);
                        this.approximateIndex = null;
                    }
                    catch (DatabaseException de) {
                        ConfigChangeResult ccr;
                        messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(de), new Object[0]));
                        ConfigChangeResult configChangeResult = ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
                        return configChangeResult;
                    }
                    finally {
                        this.entryContainer.exclusiveLock.unlock();
                    }
                }
            }
            this.indexConfig = cfg;
            return new ConfigChangeResult(ResultCode.SUCCESS, adminActionRequired, messages);
        }
        catch (Exception e) {
            messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(e), new Object[0]));
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), adminActionRequired, messages);
        }
    }

    public synchronized void setTrusted(Transaction txn, boolean trusted) throws DatabaseException {
        if (this.equalityIndex != null) {
            this.equalityIndex.setTrusted(txn, trusted);
        }
        if (this.presenceIndex != null) {
            this.presenceIndex.setTrusted(txn, trusted);
        }
        if (this.substringIndex != null) {
            this.substringIndex.setTrusted(txn, trusted);
        }
        if (this.orderingIndex != null) {
            this.orderingIndex.setTrusted(txn, trusted);
        }
        if (this.approximateIndex != null) {
            this.approximateIndex.setTrusted(txn, trusted);
        }
    }

    public synchronized void setRebuildStatus(boolean rebuildRunning) {
        if (this.equalityIndex != null) {
            this.equalityIndex.setRebuildStatus(rebuildRunning);
        }
        if (this.presenceIndex != null) {
            this.presenceIndex.setRebuildStatus(rebuildRunning);
        }
        if (this.substringIndex != null) {
            this.substringIndex.setRebuildStatus(rebuildRunning);
        }
        if (this.orderingIndex != null) {
            this.orderingIndex.setRebuildStatus(rebuildRunning);
        }
        if (this.approximateIndex != null) {
            this.approximateIndex.setRebuildStatus(rebuildRunning);
        }
    }

    public String getName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.entryContainer.getDatabasePrefix());
        builder.append("_");
        builder.append(this.indexConfig.getAttribute().getNameOrOID());
        return builder.toString();
    }

    public Index getEqualityIndex() {
        return this.equalityIndex;
    }

    public Index getApproximateIndex() {
        return this.approximateIndex;
    }

    public Index getOrderingIndex() {
        return this.orderingIndex;
    }

    public Index getSubstringIndex() {
        return this.substringIndex;
    }

    public Index getPresenceIndex() {
        return this.presenceIndex;
    }

    public Collection<Index> getAllIndexes() {
        LinkedHashSet<Index> indexes = new LinkedHashSet<Index>();
        if (this.equalityIndex != null) {
            indexes.add(this.equalityIndex);
        }
        if (this.presenceIndex != null) {
            indexes.add(this.presenceIndex);
        }
        if (this.substringIndex != null) {
            indexes.add(this.substringIndex);
        }
        if (this.orderingIndex != null) {
            indexes.add(this.orderingIndex);
        }
        if (this.approximateIndex != null) {
            indexes.add(this.approximateIndex);
        }
        return indexes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyComparator
    implements Comparator<byte[]> {
        @Override
        public int compare(byte[] a, byte[] b) {
            for (int i = 0; i < a.length && i < b.length; ++i) {
                if (a[i] > b[i]) {
                    return 1;
                }
                if (a[i] >= b[i]) continue;
                return -1;
            }
            if (a.length == b.length) {
                return 0;
            }
            if (a.length > b.length) {
                return 1;
            }
            return -1;
        }
    }
}

