/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumBindRuleType;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.authorization.dseecompat.EnumUserDNType;
import org.opends.server.authorization.dseecompat.KeywordBindRule;
import org.opends.server.authorization.dseecompat.PatternDN;
import org.opends.server.authorization.dseecompat.UserDNTypeURL;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDN
implements KeywordBindRule {
    private static String urlStr = "ldap:///";
    private List<UserDNTypeURL> urlList = null;
    private EnumBindRuleType type = null;

    private UserDN(EnumBindRuleType type, List<UserDNTypeURL> urlList) {
        this.type = type;
        this.urlList = urlList;
    }

    public static KeywordBindRule decode(String expression, EnumBindRuleType type) throws AciException {
        String[] vals = expression.split("[|][|]");
        LinkedList<UserDNTypeURL> urlList = new LinkedList<UserDNTypeURL>();
        int m = vals.length;
        for (int i = 0; i < m; ++i) {
            LDAPURL url;
            StringBuilder value = new StringBuilder(vals[i].trim());
            EnumUserDNType userDNType = UserDN.getType(value);
            try {
                url = LDAPURL.decode(value.toString(), true);
            }
            catch (DirectoryException de) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_USERDN_URL.get(de.getMessageObject());
                throw new AciException(message);
            }
            UserDNTypeURL dnTypeURL = new UserDNTypeURL(userDNType, url);
            urlList.add(dnTypeURL);
        }
        return new UserDN(type, urlList);
    }

    private static EnumUserDNType getType(StringBuilder bldr) {
        EnumUserDNType type;
        String str = bldr.toString();
        if (str.indexOf("?") != -1) {
            type = EnumUserDNType.URL;
        } else if (str.equalsIgnoreCase("ldap:///self")) {
            type = EnumUserDNType.SELF;
            bldr.replace(0, bldr.length(), urlStr);
        } else if (str.equalsIgnoreCase("ldap:///anyone")) {
            type = EnumUserDNType.ANYONE;
            bldr.replace(0, bldr.length(), urlStr);
        } else if (str.equalsIgnoreCase("ldap:///parent")) {
            type = EnumUserDNType.PARENT;
            bldr.replace(0, bldr.length(), urlStr);
        } else if (str.equalsIgnoreCase("ldap:///all")) {
            type = EnumUserDNType.ALL;
            bldr.replace(0, bldr.length(), urlStr);
        } else {
            type = str.indexOf("*") != -1 ? EnumUserDNType.DNPATTERN : EnumUserDNType.DN;
        }
        return type;
    }

    @Override
    public EnumEvalResult evaluate(AciEvalContext evalCtx) {
        EnumEvalResult matched = EnumEvalResult.FALSE;
        boolean undefined = false;
        boolean isAnonUser = evalCtx.isAnonymousUser();
        Iterator<UserDNTypeURL> it = this.urlList.iterator();
        while (it.hasNext() && matched != EnumEvalResult.TRUE && matched != EnumEvalResult.ERR) {
            UserDNTypeURL dnTypeURL = it.next();
            if (isAnonUser) {
                if (dnTypeURL.getUserDNType() != EnumUserDNType.ANYONE) continue;
                matched = EnumEvalResult.TRUE;
                continue;
            }
            matched = this.evalNonAnonymous(evalCtx, dnTypeURL);
        }
        return matched.getRet(this.type, undefined);
    }

    private EnumEvalResult evalNonAnonymous(AciEvalContext evalCtx, UserDNTypeURL dnTypeURL) {
        DN clientDN = evalCtx.getClientDN();
        DN resDN = evalCtx.getResourceDN();
        EnumEvalResult matched = EnumEvalResult.FALSE;
        EnumUserDNType type = dnTypeURL.getUserDNType();
        LDAPURL url = dnTypeURL.getURL();
        switch (type) {
            case URL: {
                matched = UserDN.evalURL(evalCtx, url);
                break;
            }
            case ANYONE: {
                matched = EnumEvalResult.TRUE;
                break;
            }
            case SELF: {
                if (!clientDN.equals(resDN)) break;
                matched = EnumEvalResult.TRUE;
                break;
            }
            case PARENT: {
                DN parentDN = resDN.getParent();
                if (parentDN == null || !parentDN.equals(clientDN)) break;
                matched = EnumEvalResult.TRUE;
                break;
            }
            case ALL: {
                matched = EnumEvalResult.TRUE;
                break;
            }
            case DNPATTERN: {
                matched = this.evalDNPattern(evalCtx, url);
                break;
            }
            case DN: {
                try {
                    DN dn = url.getBaseDN();
                    if (clientDN.equals(dn)) {
                        matched = EnumEvalResult.TRUE;
                        break;
                    }
                    DN actualDN = DirectoryServer.getActualRootBindDN(dn);
                    DN clientActualDN = DirectoryServer.getActualRootBindDN(clientDN);
                    if (actualDN != null) {
                        dn = actualDN;
                    }
                    if (clientActualDN != null) {
                        clientDN = clientActualDN;
                    }
                    if (!clientDN.equals(dn)) break;
                    matched = EnumEvalResult.TRUE;
                    break;
                }
                catch (DirectoryException ex) {
                    // empty catch block
                }
            }
        }
        return matched;
    }

    private EnumEvalResult evalDNPattern(AciEvalContext evalCtx, LDAPURL url) {
        PatternDN pattern;
        try {
            pattern = PatternDN.decode(url.getRawBaseDN());
        }
        catch (DirectoryException ex) {
            return EnumEvalResult.FALSE;
        }
        return pattern.matchesDN(evalCtx.getClientDN()) ? EnumEvalResult.TRUE : EnumEvalResult.FALSE;
    }

    public static EnumEvalResult evalURL(AciEvalContext evalCtx, LDAPURL url) {
        DN userDN;
        DN parent;
        SearchFilter filter;
        DN urlDN;
        EnumEvalResult ret = EnumEvalResult.FALSE;
        try {
            urlDN = url.getBaseDN();
            filter = url.getFilter();
        }
        catch (DirectoryException ex) {
            return EnumEvalResult.FALSE;
        }
        SearchScope scope = url.getScope();
        if (scope == SearchScope.WHOLE_SUBTREE ? !evalCtx.getClientDN().isDescendantOf(urlDN) : (scope == SearchScope.SINGLE_LEVEL ? (parent = evalCtx.getClientDN().getParent()) != null && !parent.equals(urlDN) : (scope == SearchScope.SUBORDINATE_SUBTREE ? (userDN = evalCtx.getClientDN()).getNumComponents() <= urlDN.getNumComponents() || !userDN.isDescendantOf(urlDN) : !evalCtx.getClientDN().equals(urlDN)))) {
            return EnumEvalResult.FALSE;
        }
        try {
            if (filter.matchesEntry(evalCtx.getClientEntry())) {
                ret = EnumEvalResult.TRUE;
            }
        }
        catch (DirectoryException ex) {
            return EnumEvalResult.FALSE;
        }
        return ret;
    }

    public static EnumEvalResult evaluate(Entry e, DN clientDN, AttributeType attrType) {
        EnumEvalResult matched = EnumEvalResult.FALSE;
        List<Attribute> attrs = e.getAttribute(attrType);
        LinkedHashSet<AttributeValue> vals = attrs.get(0).getValues();
        for (AttributeValue v : vals) {
            try {
                DN dn = DN.decode(v.getStringValue());
                if (!dn.equals(clientDN)) continue;
                matched = EnumEvalResult.TRUE;
            }
            catch (DirectoryException ex) {}
            break;
        }
        return matched;
    }
}

