/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternRDN {
    private boolean hasTypeWildcard = false;
    private String[] typePatterns;
    private ArrayList<ArrayList<ByteString>> valuePatterns;
    private int numValues;

    public PatternRDN(String type, ArrayList<ByteString> valuePattern, String dnString) throws DirectoryException {
        if (type.contains("*")) {
            if (!type.equals("*")) {
                Message message = AccessControlMessages.WARN_PATTERN_DN_TYPE_CONTAINS_SUBSTRINGS.get(dnString);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
            }
            this.hasTypeWildcard = true;
        }
        this.numValues = 1;
        this.typePatterns = new String[]{type};
        this.valuePatterns = new ArrayList(1);
        this.valuePatterns.add(valuePattern);
    }

    public boolean addValue(String type, ArrayList<ByteString> valuePattern, String dnString) throws DirectoryException {
        if (this.hasTypeWildcard || type.contains("*")) {
            Message message = AccessControlMessages.WARN_PATTERN_DN_TYPE_WILDCARD_IN_MULTIVALUED_RDN.get(dnString);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message);
        }
        ++this.numValues;
        String[] newTypes = new String[this.numValues];
        System.arraycopy(this.typePatterns, 0, newTypes, 0, this.typePatterns.length);
        newTypes[this.typePatterns.length] = type;
        this.typePatterns = newTypes;
        this.valuePatterns.add(valuePattern);
        return true;
    }

    public int getNumValues() {
        return this.numValues;
    }

    public boolean matchesRDN(RDN rdn) {
        int i;
        if (this.getNumValues() == 1) {
            AttributeType thisType;
            if (this.typePatterns[0].equals("*") && this.valuePatterns.get(0) == null) {
                return true;
            }
            if (rdn.getNumValues() != 1) {
                return false;
            }
            AttributeType thatType = rdn.getAttributeType(0);
            if (!(this.typePatterns[0].equals("*") || (thisType = DirectoryServer.getAttributeType(this.typePatterns[0].toLowerCase())) != null && thisType.equals(thatType))) {
                return false;
            }
            return this.matchValuePattern((List<ByteString>)this.valuePatterns.get(0), thatType, rdn.getAttributeValue(0));
        }
        if (this.hasTypeWildcard) {
            return false;
        }
        if (this.numValues != rdn.getNumValues()) {
            return false;
        }
        TreeMap<String, ArrayList<ByteString>> patternMap = new TreeMap<String, ArrayList<ByteString>>();
        TreeMap<String, AttributeValue> rdnMap = new TreeMap<String, AttributeValue>();
        for (i = 0; i < rdn.getNumValues(); ++i) {
            rdnMap.put(rdn.getAttributeType(i).getNameOrOID(), rdn.getAttributeValue(i));
        }
        for (i = 0; i < this.numValues; ++i) {
            String lowerName = this.typePatterns[i].toLowerCase();
            AttributeType type = DirectoryServer.getAttributeType(lowerName);
            if (type == null) {
                return false;
            }
            patternMap.put(type.getNameOrOID(), this.valuePatterns.get(i));
        }
        Set patternKeys = patternMap.keySet();
        Set rdnKeys = rdnMap.keySet();
        Iterator patternKeyIter = patternKeys.iterator();
        for (String rdnKey : rdnKeys) {
            if (!rdnKey.equals(patternKeyIter.next())) {
                return false;
            }
            if (this.matchValuePattern((List)patternMap.get(rdnKey), DirectoryServer.getAttributeType(rdnKey), (AttributeValue)rdnMap.get(rdnKey))) continue;
            return false;
        }
        return true;
    }

    private boolean matchValuePattern(List<ByteString> pattern, AttributeType type, AttributeValue value) {
        if (pattern == null) {
            return true;
        }
        try {
            if (pattern.size() > 1) {
                ByteString subFinal;
                ByteString subInitial = pattern.get(0);
                if (subInitial.value().length == 0) {
                    subInitial = null;
                }
                if ((subFinal = pattern.get(pattern.size() - 1)).value().length == 0) {
                    subFinal = null;
                }
                List<ByteString> subAnyElements = pattern.size() > 2 ? pattern.subList(1, pattern.size() - 1) : null;
                LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(1);
                values.add(value);
                Attribute attr = new Attribute(type, type.getNameOrOID(), values);
                switch (attr.matchesSubstring(subInitial, subAnyElements, subFinal)) {
                    case TRUE: {
                        return true;
                    }
                }
                return false;
            }
            ByteString thisNormValue = type.normalize(pattern.get(0));
            ByteString thatNormValue = value.getNormalizedValue();
            EqualityMatchingRule mr = type.getEqualityMatchingRule();
            return mr.areEqual(thisNormValue, thatNormValue);
        }
        catch (DirectoryException e) {
            return false;
        }
    }
}

