/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Application;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.CliUserInteraction;
import org.opends.quicksetup.HistoricalRecord;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.ProgressUpdateListenerDelegate;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.Status;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.UserInteraction;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.upgrader.ReversionIssueNotifier;
import org.opends.quicksetup.upgrader.ReversionLauncher;
import org.opends.quicksetup.upgrader.ReversionProgressStep;
import org.opends.quicksetup.upgrader.RevertFileFilter;
import org.opends.quicksetup.upgrader.ReverterUserData;
import org.opends.quicksetup.upgrader.Stage;
import org.opends.quicksetup.upgrader.UpgradeLauncher;
import org.opends.quicksetup.util.FileManager;
import org.opends.quicksetup.util.ProgressMessageFormatter;
import org.opends.quicksetup.util.ServerController;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.Menu;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuResult;

public class Reverter
extends Application
implements CliApplication {
    private static final Logger LOG = Logger.getLogger(Reverter.class.getName());
    private ReversionProgressStep currentProgressStep = ReversionProgressStep.NOT_STARTED;
    private ReverterUserData userData;
    private ProgressUpdateListenerDelegate listenerDelegate;
    private ApplicationException runError;
    private ApplicationException runWarning;
    private Installation installation;
    private Installation archiveInstallation;
    private File tempBackupDir;
    private long historicalOperationId;
    private BuildInformation fromBuildInfo;
    private BuildInformation archiveBuildInfo;
    private boolean abort = false;
    private boolean restartServer = false;
    private Stage stage = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserData createUserData(Launcher launcher) throws UserDataException {
        ReverterUserData ud;
        block28: {
            UpgradeLauncher rl;
            block27: {
                int resp;
                int len$;
                File[] arr$;
                ArrayList<Message> raDirChoiceList;
                File[] raDirs;
                CliUserInteraction ui;
                block26: {
                    block29: {
                        ud = null;
                        if (!(launcher instanceof UpgradeLauncher)) break block28;
                        ud = new ReverterUserData();
                        rl = (UpgradeLauncher)launcher;
                        if (!rl.isInteractive()) break block29;
                        if (rl.isNoPrompt()) {
                            StringBuilder sb = new StringBuilder().append("-").append(UpgradeLauncher.REVERT_ARCHIVE_OPTION_SHORT).append("/--").append("reversionArchive").append(", -").append(ReversionLauncher.REVERT_MOST_RECENT_OPTION_SHORT).append("/--").append("revertMostRecent");
                            throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_NO_DIR.get(sb.toString()));
                        }
                        ui = new CliUserInteraction();
                        Message[] options = new Message[]{QuickSetupMessages.INFO_REVERSION_TYPE_PROMPT_RECENT.get(), QuickSetupMessages.INFO_REVERSION_TYPE_PROMPT_FILE.get()};
                        if (options[0].equals(ui.confirm(QuickSetupMessages.INFO_REVERT_CONFIRM_TITLE.get(), QuickSetupMessages.INFO_REVERSION_TYPE_PROMPT.get(), QuickSetupMessages.INFO_REVERT_CONFIRM_TITLE.get(), UserInteraction.MessageType.QUESTION, options, options[0]))) {
                            ud.setRevertMostRecent(true);
                            break block27;
                        } else {
                            ud.setRevertMostRecent(false);
                            File historyDir = this.getInstallation().getHistoryDirectory();
                            if (historyDir != null && historyDir.exists()) {
                                System.out.println(this.formatter.getFormattedWithPoints(QuickSetupMessages.INFO_REVERSION_DIR_WAIT.get()));
                                Object[] historyChildren = historyDir.list();
                                Arrays.sort(historyChildren);
                                ArrayList<File> raDirList = new ArrayList<File>();
                                for (int i = historyChildren.length - 1; i >= 0; --i) {
                                    File raDirCandidate = new File(historyDir, (String)historyChildren[i]);
                                    if (!this.isReversionFilesDirectory(raDirCandidate)) continue;
                                    raDirList.add(raDirCandidate);
                                }
                                raDirs = raDirList.toArray(new File[raDirList.size()]);
                                raDirChoiceList = new ArrayList<Message>();
                                arr$ = raDirs;
                                len$ = arr$.length;
                                break block26;
                            } else {
                                LOG.log(Level.INFO, "History dir does not exist");
                                throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_NO_HISTORY_DIR.get());
                            }
                        }
                    }
                    if (rl.isRevertMostRecent()) {
                        ud.setRevertMostRecent(true);
                        break block27;
                    } else {
                        File filesDir = rl.getReversionArchiveDirectory();
                        filesDir = this.appendFilesDirIfNeccessary(filesDir);
                        ud.setReversionArchiveDirectory(this.validateReversionArchiveDirectory(filesDir));
                    }
                    break block27;
                }
                for (int i$ = 0; i$ < len$; ++i$) {
                    File raDir = arr$[i$];
                    String name = raDir.getName();
                    Message buildInfo = QuickSetupMessages.INFO_UPGRADE_BUILD_ID_UNKNOWN.get();
                    Message date = QuickSetupMessages.INFO_GENERAL_UNKNOWN.get();
                    try {
                        Installation i = new Installation(this.appendFilesDirIfNeccessary(raDir));
                        BuildInformation bi = i.getBuildInformation();
                        buildInfo = Message.raw(bi.toString(), new Object[0]);
                    }
                    catch (Exception e) {
                        LOG.log(Level.INFO, "Error determining archive version for " + name);
                    }
                    try {
                        Date d = new Date(Long.valueOf(name));
                        DateFormat df = DateFormat.getInstance();
                        date = Message.raw(df.format(d), new Object[0]);
                    }
                    catch (Exception e) {
                        LOG.log(Level.INFO, "Error converting reversion archive name " + name + " to date helper");
                    }
                    MessageBuilder mb = new MessageBuilder(name);
                    mb.append(" (");
                    mb.append(QuickSetupMessages.INFO_REVERSION_DIR_FROM_UPGRADE.get(buildInfo, date));
                    mb.append(")");
                    raDirChoiceList.add(mb.toMessage());
                }
                Message[] raDirChoices = raDirChoiceList.toArray(new Message[0]);
                if (raDirChoices.length <= 0) {
                    LOG.log(Level.INFO, "No archives in history dir");
                    throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_NO_HISTORY_DIR.get());
                }
                MenuBuilder<Integer> builder = new MenuBuilder<Integer>(ui);
                builder.setPrompt(QuickSetupMessages.INFO_REVERSION_DIR_PROMPT.get());
                for (int i = 0; i < raDirChoices.length; ++i) {
                    builder.addNumberedOption(raDirChoices[i], MenuResult.success(i + 1), new Message[0]);
                }
                builder.setDefault(Message.raw(String.valueOf("1"), new Object[0]), MenuResult.success(1));
                Menu menu = builder.toMenu();
                try {
                    MenuResult m = menu.run();
                    if (!m.isSuccess()) {
                        throw new RuntimeException();
                    }
                    resp = (Integer)m.getValue();
                }
                catch (CLIException ce) {
                    resp = 1;
                    LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                }
                File raDir = raDirs[resp - 1];
                raDir = this.appendFilesDirIfNeccessary(raDir);
                try {
                    ud.setReversionArchiveDirectory(this.validateReversionArchiveDirectory(raDir));
                }
                catch (UserDataException ude) {
                    System.err.println(ude.getMessageObject());
                }
            }
            if (ud.isRevertMostRecent()) {
                int len$;
                Object[] arr$;
                Installation install = this.getInstallation();
                File historyDir = install.getHistoryDirectory();
                if (!historyDir.exists()) {
                    throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_NO_HISTORY_DIR.get());
                }
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return !"log".equals(name);
                    }
                };
                Object[] childNames = historyDir.list(filter);
                boolean found = false;
                if (childNames != null && childNames.length > 0) {
                    Arrays.sort(childNames);
                    arr$ = childNames;
                    len$ = arr$.length;
                } else {
                    throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_EMPTY_HISTORY_DIR.get());
                }
                for (int i$ = 0; i$ < len$; ++i$) {
                    Object childName = arr$[i$];
                    File b = new File(historyDir, (String)childName);
                    File d = new File(b, "files");
                    if (!this.isReversionFilesDirectory(d)) continue;
                    found = true;
                    ud.setReversionArchiveDirectory(d);
                    break;
                }
                if (!found) {
                    throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_INVALID_HISTORY_DIR.get());
                }
            }
            ud.setQuiet(rl.isQuiet());
            ud.setInteractive(!rl.isNoPrompt());
            ud.setVerbose(rl.isVerbose());
        }
        return ud;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public void setUserData(UserData userData) {
        if (userData instanceof ReverterUserData) {
            this.userData = (ReverterUserData)userData;
        }
    }

    public void setProgressMessageFormatter(ProgressMessageFormatter formatter) {
        this.formatter = formatter;
        this.listenerDelegate = new ProgressUpdateListenerDelegate();
    }

    public ApplicationException getRunError() {
        return this.runError;
    }

    public ReturnCode getReturnCode() {
        return null;
    }

    public void addProgressUpdateListener(ProgressUpdateListener l) {
        this.listenerDelegate.addProgressUpdateListener(l);
    }

    public void removeProgressUpdateListener(ProgressUpdateListener l) {
        this.listenerDelegate.removeProgressUpdateListener(l);
    }

    public void notifyListeners(Integer ratio, Message currentPhaseSummary, Message newLogDetail) {
        this.listenerDelegate.notifyListeners(null, ratio, currentPhaseSummary, newLogDetail);
    }

    public String getInstallationPath() {
        String installationPath = null;
        String path = Utils.getInstallPathFromClasspath();
        if (path != null) {
            File f = new File(path);
            installationPath = f.getParentFile() != null && f.getParentFile().getParentFile() != null && new File(f.getParentFile().getParentFile(), "locks").exists() ? Utils.getPath(f.getParentFile().getParentFile()) : path;
        }
        return installationPath;
    }

    public ProgressStep getCurrentProgressStep() {
        return this.currentProgressStep;
    }

    public Integer getRatio(ProgressStep step) {
        Integer ratio = null;
        if (step instanceof ReversionProgressStep) {
            ratio = ((ReversionProgressStep)step).getProgress();
        }
        return ratio;
    }

    public Message getSummary(ProgressStep step) {
        Message txt = step == ReversionProgressStep.FINISHED ? this.getFinalSuccessMessage() : ((ReversionProgressStep)step).getSummaryMessage();
        return txt;
    }

    private Message getLogMsg(ReversionProgressStep step) {
        Message txt = step == ReversionProgressStep.FINISHED ? this.getFinalSuccessMessage() : (step == ReversionProgressStep.FINISHED_CANCELED ? step.getSummaryMessage() : (step == ReversionProgressStep.FINISHED_WITH_ERRORS ? step.getSummaryMessage() : (step == ReversionProgressStep.FINISHED_WITH_WARNINGS ? step.getSummaryMessage() : step.getLogMsg(this.isVerbose()))));
        return txt;
    }

    public boolean isFinished() {
        return this.getCurrentProgressStep() == ReversionProgressStep.FINISHED || this.getCurrentProgressStep() == ReversionProgressStep.FINISHED_WITH_ERRORS || this.getCurrentProgressStep() == ReversionProgressStep.FINISHED_WITH_WARNINGS || this.getCurrentProgressStep() == ReversionProgressStep.FINISHED_CANCELED;
    }

    public boolean isCancellable() {
        return false;
    }

    public void cancel() {
    }

    public Installation getInstallation() {
        String installPath;
        if (this.installation == null && (installPath = this.getInstallationPath()) != null) {
            this.installation = new Installation(installPath);
        }
        return this.installation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block28: {
            try {
                UserInteraction ui = this.userInteraction();
                if (ui != null) {
                    String toBuildString;
                    Message cont = QuickSetupMessages.INFO_CONTINUE_BUTTON_LABEL.get();
                    Message cancel = QuickSetupMessages.INFO_CANCEL_BUTTON_LABEL.get();
                    BuildInformation toBi = this.getArchiveBuildInformation();
                    if (toBi != null) {
                        toBuildString = toBi.toString();
                    } else {
                        if (this.getReversionFilesDirectory() == null) {
                            throw new ApplicationException(ReturnCode.APPLICATION_ERROR, QuickSetupMessages.INFO_REVERT_ERROR_INVALID_HISTORY_DIR.get(), null);
                        }
                        toBuildString = QuickSetupMessages.INFO_UPGRADE_BUILD_ID_UNKNOWN.get().toString();
                    }
                    if (cancel.equals(ui.confirm(QuickSetupMessages.INFO_REVERT_CONFIRM_TITLE.get(), QuickSetupMessages.INFO_REVERT_CONFIRM_PROMPT.get(toBuildString, Utils.getPath(this.getReversionFilesDirectory())), QuickSetupMessages.INFO_REVERT_CONFIRM_TITLE.get(), UserInteraction.MessageType.WARNING, new Message[]{cont, cancel}, cont))) {
                        throw new ApplicationException(ReturnCode.CANCELLED, QuickSetupMessages.INFO_REVERSION_CANCELED.get(), null);
                    }
                }
                Installation installation = this.getInstallation();
                Status status = installation.getStatus();
                ServerController sc = new ServerController(installation);
                if (status.isServerRunning()) {
                    this.restartServer = true;
                    sc = new ServerController(installation);
                    try {
                        this.setCurrentProgressStep(ReversionProgressStep.STOPPING_SERVER);
                        LOG.log(Level.INFO, "Stopping server");
                        if (this.isVerbose()) {
                            this.notifyListeners(this.getTaskSeparator());
                        } else {
                            this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_STOPPING_NON_VERBOSE.get()));
                        }
                        sc.stopServer(!this.isVerbose());
                        if (!this.isVerbose()) {
                            this.notifyListeners(this.getFormattedDoneWithLineBreak());
                        } else {
                            this.notifyListeners(this.getLineBreak());
                        }
                    }
                    catch (ApplicationException ae) {
                        this.runError = ae;
                        this.notifyListeners(this.getFormattedErrorWithLineBreak());
                    }
                }
                try {
                    this.setCurrentProgressStep(ReversionProgressStep.INITIALIZING);
                    this.initialize();
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                }
                catch (ApplicationException ae) {
                    LOG.log(Level.INFO, "Error initializing reversion", ae);
                    this.notifyListeners(this.getFormattedErrorWithLineBreak());
                    throw ae;
                }
                try {
                    LOG.log(Level.INFO, "Reverting components");
                    this.setCurrentProgressStep(ReversionProgressStep.REVERTING_FILESYSTEM);
                    this.revertComponents();
                    LOG.log(Level.INFO, "Finished reverting components");
                    this.notifyListeners(this.getFormattedDoneWithLineBreak());
                }
                catch (ApplicationException ae) {
                    LOG.log(Level.INFO, "Error reverting components", ae);
                    this.notifyListeners(this.getFormattedErrorWithLineBreak());
                    throw ae;
                }
                if (!this.restartServer) break block28;
                try {
                    LOG.log(Level.INFO, "Restarting server");
                    this.setCurrentProgressStep(ReversionProgressStep.STARTING_SERVER);
                    if (this.isVerbose()) {
                        this.notifyListeners(this.getTaskSeparator());
                    } else {
                        this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_STARTING_NON_VERBOSE.get()));
                    }
                    sc.startServer(!this.isVerbose());
                    if (!this.isVerbose()) {
                        this.notifyListeners(this.getFormattedDoneWithLineBreak());
                        break block28;
                    }
                    this.notifyListeners(this.getLineBreak());
                }
                catch (ApplicationException ae) {
                    this.runError = ae;
                    this.notifyListeners(this.getFormattedErrorWithLineBreak());
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ApplicationException)) {
                    this.runError = new ApplicationException(ReturnCode.BUG, Message.raw(e.getLocalizedMessage(), new Object[0]), e);
                } else {
                    this.runError = (ApplicationException)e;
                    this.abort = ReturnCode.CANCELLED.equals(((ApplicationException)e).getType());
                }
            }
            finally {
                this.end();
            }
        }
    }

    private void setCurrentProgressStep(ReversionProgressStep step) {
        this.currentProgressStep = step;
        int progress = step.getProgress();
        Message summary = this.getSummary(step);
        Message log = this.getLogMsg(step);
        if (step.logRequiresPoints(this.isVerbose()) && log != null) {
            log = this.getFormattedWithPoints(log);
        }
        this.notifyListeners(progress, summary, log);
    }

    private void initialize() throws ApplicationException {
        this.historicalOperationId = this.writeInitialHistoricalRecord(this.getFromBuildInformation(), this.getArchiveBuildInformation());
        this.insureRevertability();
        this.backupCurrentInstallation();
    }

    private void backupCurrentInstallation() throws ApplicationException {
        LOG.log(Level.INFO, "Backing up filesystem");
        try {
            File filesBackupDirectory = this.getTempBackupDirectory();
            FileManager fm = new FileManager();
            File root = this.getInstallation().getRootDirectory();
            RevertFileFilter filter = new RevertFileFilter(root);
            for (String fileName : root.list()) {
                File f = new File(root, fileName);
                if (Utils.isWindows() && fileName.equals("upgrade.bat")) continue;
                fm.move(f, filesBackupDirectory, filter);
            }
            LOG.log(Level.INFO, "Finished backing up filesystem");
        }
        catch (ApplicationException ae) {
            LOG.log(Level.INFO, "Error backing up filesystem", ae);
            throw ae;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Error backing up filesystem", e);
            throw new ApplicationException(ReturnCode.FILE_SYSTEM_ACCESS_ERROR, QuickSetupMessages.INFO_ERROR_BACKUP_FILESYSTEM.get(), e);
        }
    }

    private void revertComponents() throws ApplicationException {
        try {
            Stage stage = this.getStage();
            Installation installation = this.getInstallation();
            File root = installation.getRootDirectory();
            stage.move(root, new RevertFileFilter(this.getReversionFilesDirectory()));
            LOG.log(Level.INFO, "Reverted bits to " + installation.getBuildInformation(false));
        }
        catch (IOException e) {
            throw ApplicationException.createFileSystemException(QuickSetupMessages.INFO_ERROR_UPGRADING_COMPONENTS.get(), e);
        }
    }

    private File getReversionFilesDirectory() throws ApplicationException, IOException {
        return this.userData.getReversionArchiveDirectory();
    }

    private File validateReversionArchiveDirectory(File filesDir) throws UserDataException {
        if (filesDir == null) {
            throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_NULL_FILES_DIR.get());
        }
        if (!filesDir.isDirectory()) {
            throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_NOT_DIR_FILES_DIR.get());
        }
        if (!this.isReversionFilesDirectory(filesDir)) {
            throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_INVALID_FILES_DIR.get());
        }
        return filesDir;
    }

    private boolean isReversionFilesDirectory(File filesDir) {
        filesDir = this.appendFilesDirIfNeccessary(filesDir);
        boolean isFilesDir = false;
        if (filesDir != null && filesDir.exists() && filesDir.isDirectory()) {
            String[] children = filesDir.list();
            HashSet<String> cs = new HashSet<String>(Arrays.asList(children));
            isFilesDir = cs.contains("config") && cs.contains("lib");
        }
        return isFilesDir;
    }

    private void end() {
        try {
            HistoricalRecord.Status status;
            String note = null;
            if (this.runError == null && !this.abort) {
                status = HistoricalRecord.Status.SUCCESS;
                LOG.log(Level.INFO, "Cleaning up after reversion");
                this.setCurrentProgressStep(ReversionProgressStep.CLEANUP);
                this.deleteArchive();
                this.deleteBackup();
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
                LOG.log(Level.INFO, "Clean up complete");
            } else {
                if (this.abort) {
                    status = HistoricalRecord.Status.CANCEL;
                } else {
                    status = HistoricalRecord.Status.FAILURE;
                    note = this.runError.getLocalizedMessage();
                }
                LOG.log(Level.INFO, "Canceling reversion");
                ReversionProgressStep lastProgressStep = this.currentProgressStep;
                this.setCurrentProgressStep(ReversionProgressStep.ABORT);
                this.abort(lastProgressStep);
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
                LOG.log(Level.INFO, "Cancelation complete");
            }
            this.deleteReversionLib();
            LOG.log(Level.INFO, "Recording history");
            this.setCurrentProgressStep(ReversionProgressStep.RECORDING_HISTORY);
            this.writeHistoricalRecord(this.historicalOperationId, this.getFromBuildInformation(), this.getArchiveBuildInformation(), status, note);
            this.notifyListeners(this.getFormattedDoneWithLineBreak());
            LOG.log(Level.INFO, "History recorded");
            this.notifyListeners(new MessageBuilder(QuickSetupMessages.INFO_GENERAL_SEE_FOR_HISTORY.get(Utils.getPath(this.getInstallation().getHistoryLogFile()))).append(this.getLineBreak()).toMessage());
            try {
                Stage stage = this.getStage();
                List<Message> stageMessages = stage.getMessages();
                for (Message m : stageMessages) {
                    this.notifyListeners(m);
                }
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "failed to access stage", e);
            }
        }
        catch (ApplicationException e) {
            this.notifyListeners(this.getFormattedDoneWithLineBreak());
            LOG.log(Level.INFO, "Error cleaning up after reversion.", e);
        }
        if (this.abort) {
            LOG.log(Level.INFO, "reversion canceled by user");
            this.setCurrentProgressStep(ReversionProgressStep.FINISHED_CANCELED);
        } else if (this.runError != null) {
            LOG.log(Level.INFO, "reversion completed with errors", this.runError);
            this.notifyListeners(this.getFormattedErrorWithLineBreak(this.runError, true));
            this.notifyListeners(this.getLineBreak());
            this.setCurrentProgressStep(ReversionProgressStep.FINISHED_WITH_ERRORS);
            this.notifyListeners(this.getLineBreak());
        } else if (this.runWarning != null) {
            LOG.log(Level.INFO, "reversion completed with warnings");
            Message warningText = this.runWarning.getMessageObject();
            this.notifyListeners(this.getFormattedErrorWithLineBreak(warningText, true));
            this.notifyListeners(this.getLineBreak());
            this.setCurrentProgressStep(ReversionProgressStep.FINISHED_WITH_WARNINGS);
            this.notifyListeners(this.formatter.getLineBreak());
        } else {
            LOG.log(Level.INFO, "reversion completed successfully");
            this.setCurrentProgressStep(ReversionProgressStep.FINISHED);
        }
    }

    private void abort(ProgressStep lastStep) throws ApplicationException {
        if ("true".equals(System.getProperty("org.opends.quicksetup.upgrader.NoAbort"))) {
            return;
        }
        ReversionProgressStep lastReversionStep = (ReversionProgressStep)lastStep;
        EnumSet<ReversionProgressStep> stepsStarted = EnumSet.range(ReversionProgressStep.NOT_STARTED, lastReversionStep);
        if (stepsStarted.contains(ReversionProgressStep.REVERTING_FILESYSTEM)) {
            File root = this.getInstallation().getRootDirectory();
            try {
                File backupDirectory = this.getTempBackupDirectory();
                FileManager fm = new FileManager();
                boolean restoreError = false;
                for (String fileName : backupDirectory.list()) {
                    File f = new File(backupDirectory, fileName);
                    try {
                        fm.move(f, root, null);
                    }
                    catch (Throwable t) {
                        restoreError = true;
                        this.notifyListeners(QuickSetupMessages.INFO_ERROR_RESTORING_FILE.get(Utils.getPath(f), Utils.getPath(root)));
                    }
                }
                if (!restoreError) {
                    fm.deleteRecursively(backupDirectory);
                }
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Error getting backup directory", e);
            }
        }
    }

    private void deleteArchive() {
        FileManager fm = new FileManager();
        try {
            fm.deleteRecursively(this.getReversionFilesDirectory());
            File parent = this.getReversionFilesDirectory().getParentFile();
            if (Utils.directoryExistsAndIsEmpty(parent.getAbsolutePath())) {
                fm.deleteRecursively(parent);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error: " + e, e);
        }
    }

    private void deleteBackup() {
        FileManager fm = new FileManager();
        try {
            fm.deleteRecursively(this.getTempBackupDirectory());
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error: " + e, e);
        }
    }

    private void deleteReversionLib() {
        FileManager fm = new FileManager();
        try {
            File tmpDir = this.getInstallation().getTemporaryDirectory();
            File revertLibDir = new File(tmpDir, "revert");
            fm.deleteRecursively(revertLibDir, null, FileManager.DeletionPolicy.DELETE_ON_EXIT);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File getTempBackupDirectory() throws IOException, ApplicationException {
        if (this.tempBackupDir == null) {
            this.tempBackupDir = new File(this.getInstallation().getTemporaryDirectory(), "files");
            if (this.tempBackupDir.exists()) {
                FileManager fm = new FileManager();
                fm.deleteRecursively(this.tempBackupDir);
            }
            if (!this.tempBackupDir.mkdirs()) {
                throw new IOException("error creating files backup directory");
            }
        }
        return this.tempBackupDir;
    }

    private BuildInformation getFromBuildInformation() {
        if (this.fromBuildInfo == null && this.currentProgressStep.ordinal() < ReversionProgressStep.REVERTING_FILESYSTEM.ordinal()) {
            try {
                this.fromBuildInfo = this.installation.getBuildInformation(false);
            }
            catch (ApplicationException e) {
                LOG.log(Level.INFO, "Failed to obtain 'from' build information", e);
            }
        }
        return this.fromBuildInfo;
    }

    private BuildInformation getArchiveBuildInformation() {
        if (this.archiveBuildInfo == null) {
            if (this.currentProgressStep.ordinal() > ReversionProgressStep.REVERTING_FILESYSTEM.ordinal()) {
                try {
                    this.archiveBuildInfo = this.installation.getBuildInformation(false);
                }
                catch (ApplicationException e) {
                    LOG.log(Level.INFO, "Failed to obtain archived build information from reverted files", e);
                }
            } else {
                try {
                    Installation archiveInstall = this.getArchiveInstallation();
                    this.archiveBuildInfo = archiveInstall.getBuildInformation();
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "Failed to obtain archived build information from archived files", e);
                }
            }
        }
        return this.archiveBuildInfo;
    }

    private Message getFinalSuccessMessage() {
        String newVersion;
        String installPath = Utils.getPath(this.getInstallation().getRootDirectory());
        try {
            BuildInformation bi = this.getInstallation().getBuildInformation();
            newVersion = bi != null ? bi.toString() : QuickSetupMessages.INFO_UPGRADE_BUILD_ID_UNKNOWN.get().toString();
        }
        catch (ApplicationException e) {
            newVersion = QuickSetupMessages.INFO_UPGRADE_BUILD_ID_UNKNOWN.get().toString();
        }
        Message txt = QuickSetupMessages.INFO_SUMMARY_REVERT_FINISHED_SUCCESSFULLY_CLI.get(this.formatter.getFormattedText(Message.raw(installPath, new Object[0])), newVersion);
        return txt;
    }

    private void insureRevertability() throws ApplicationException {
        BuildInformation newVersion;
        BuildInformation currentVersion;
        try {
            currentVersion = this.getInstallation().getBuildInformation();
        }
        catch (ApplicationException e) {
            LOG.log(Level.INFO, "Error getting build information for current installation", e);
            throw ApplicationException.createFileSystemException(QuickSetupMessages.INFO_ERROR_DETERMINING_CURRENT_BUILD.get(), e);
        }
        try {
            Installation revInstallation = this.getArchiveInstallation();
            newVersion = revInstallation.getBuildInformation();
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Error getting build information for staged installation", e);
            throw ApplicationException.createFileSystemException(QuickSetupMessages.INFO_ERROR_DETERMINING_REVERSION_BUILD.get(), e);
        }
        if (currentVersion != null && newVersion != null) {
            ReversionIssueNotifier uo = new ReversionIssueNotifier(this.userInteraction(), currentVersion, newVersion);
            uo.notifyUser();
            if (uo.noServerStartFollowingOperation()) {
                this.getUserData().setStartServer(false);
            }
        } else {
            LOG.log(Level.INFO, "Did not run reversion issue notifier due to incomplete build information");
        }
    }

    private Installation getArchiveInstallation() throws ApplicationException, IOException {
        if (this.archiveInstallation == null) {
            File revFiles = this.getReversionFilesDirectory();
            this.archiveInstallation = new Installation(revFiles);
        }
        return this.archiveInstallation;
    }

    private File appendFilesDirIfNeccessary(File archiveDir) {
        if (archiveDir != null && !archiveDir.getName().endsWith("files")) {
            archiveDir = new File(archiveDir, "files");
        }
        return archiveDir;
    }

    private Stage getStage() throws IOException, ApplicationException {
        if (this.stage == null) {
            this.stage = new Stage(this.getReversionFilesDirectory());
        }
        return this.stage;
    }
}

