/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.UtilityMessages;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.upgrader.UpgradeLauncher;
import org.opends.quicksetup.upgrader.UpgradeUserData;
import org.opends.quicksetup.upgrader.UpgraderCliHelper;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.Menu;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuResult;

public class BuildExtractorCliHelper
extends UpgraderCliHelper {
    private static final Logger LOG = Logger.getLogger(BuildExtractorCliHelper.class.getName());

    public BuildExtractorCliHelper(UpgradeLauncher launcher) {
        super(launcher);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UpgradeUserData createUserData(String[] args) throws UserDataException {
        UpgradeUserData uud = super.createUserData(args);
        if (this.launcher.isInteractive()) {
            int choice;
            if (this.launcher.isNoPrompt()) throw new UserDataException(null, QuickSetupMessages.INFO_ERROR_OPTIONS_REQUIRED_OR_INTERACTIVE.get());
            LOG.log(Level.INFO, "obtaining file information interactively");
            boolean UPGRADE = true;
            int REVERT = 2;
            int[] indexes = new int[]{1, 2};
            Message[] options = new Message[]{QuickSetupMessages.INFO_UPGRADE_OPERATION_UPGRADE.get(), QuickSetupMessages.INFO_UPGRADE_OPERATION_REVERSION.get()};
            MenuBuilder<Integer> builder = new MenuBuilder<Integer>(this);
            builder.setPrompt(QuickSetupMessages.INFO_UPGRADE_OPERATION_PROMPT.get());
            for (int i = 0; i < indexes.length; ++i) {
                builder.addNumberedOption(options[i], MenuResult.success(indexes[i]), new Message[0]);
            }
            builder.setDefault(Message.raw(String.valueOf(1), new Object[0]), MenuResult.success(1));
            Menu menu = builder.toMenu();
            try {
                MenuResult m = menu.run();
                if (!m.isSuccess()) {
                    throw new RuntimeException();
                }
                choice = (Integer)m.getValue();
            }
            catch (CLIException ce) {
                choice = 1;
                LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
            }
            if (choice == 1) {
                uud.setOperation(UpgradeUserData.Operation.UPGRADE);
                int nTries = 0;
                do {
                    String fileName;
                    if ((fileName = this.readInput(QuickSetupMessages.INFO_UPGRADE_FILE_PROMPT.get(), null, LOG)) != null) {
                        try {
                            uud.setInstallPackage(this.validateInstallPackFile(fileName));
                            LOG.log(Level.INFO, "file specified interactively: " + fileName);
                            return uud;
                        }
                        catch (UserDataException ude) {
                            System.out.println(ude.getMessage());
                            continue;
                        }
                    }
                    System.out.println();
                } while (++nTries < 5);
                throw new UserDataException(null, UtilityMessages.ERR_CONFIRMATION_TRIES_LIMIT_REACHED.get(5));
            }
            uud.setOperation(UpgradeUserData.Operation.REVERSION);
            return uud;
        }
        String upgradeFile = this.launcher.getUpgradeFileName();
        if (upgradeFile != null) {
            uud.setInstallPackage(this.validateInstallPackFile(upgradeFile));
        }
        if (!this.launcher.isRevertMostRecent() && !this.launcher.isRevertToArchive()) return uud;
        uud.setOperation(UpgradeUserData.Operation.REVERSION);
        return uud;
    }

    private File validateInstallPackFile(String fileName) throws UserDataException {
        File f = new File(fileName);
        if (!f.exists()) {
            throw new UserDataException(null, QuickSetupMessages.INFO_BUILD_EXTRACTOR_ERROR_FILE_NO_EXIST.get(fileName));
        }
        if (f.isDirectory() || !f.getName().toLowerCase().endsWith(".zip")) {
            throw new UserDataException(null, QuickSetupMessages.INFO_BUILD_EXTRACTOR_ERROR_FILE_NOT_ZIP.get(fileName));
        }
        return f;
    }
}

