/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel.ui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.ToolTipManager;

class InstantaneousToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    private ToolTipManager ttipManager = ToolTipManager.sharedInstance();
    private Popup tipWindow;
    private boolean isVisible;

    public void registerComponent(JComponent comp) {
        this.ttipManager.unregisterComponent(comp);
        comp.removeMouseListener(this);
        comp.addMouseListener(this);
        comp.removeMouseMotionListener(this);
        comp.addMouseMotionListener(this);
    }

    public void unregisterComponent(JComponent comp) {
        this.ttipManager.registerComponent(comp);
        comp.removeMouseListener(this);
        comp.removeMouseMotionListener(this);
    }

    public void mouseDragged(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        this.displayToolTip(event);
    }

    public void mouseExited(MouseEvent event) {
        this.hideToolTip(event);
    }

    public void mouseMoved(MouseEvent event) {
        this.hideToolTip(event);
        this.displayToolTip(event);
    }

    public void mousePressed(MouseEvent event) {
        if (this.isVisible) {
            this.hideToolTip(event);
        } else {
            this.hideToolTip(event);
            this.displayToolTip(event);
        }
    }

    private void displayToolTip(MouseEvent event) {
        JComponent component = (JComponent)event.getSource();
        String toolTipText = component.getToolTipText(event);
        if (toolTipText != null) {
            Point preferredLocation = component.getToolTipLocation(event);
            Rectangle sBounds = component.getGraphicsConfiguration().getBounds();
            JToolTip tip = component.createToolTip();
            tip.setTipText(toolTipText);
            Dimension size = tip.getPreferredSize();
            Point location = new Point();
            Point screenLocation = component.getLocationOnScreen();
            if (preferredLocation != null) {
                location.x = screenLocation.x + preferredLocation.x;
                location.y = screenLocation.y + preferredLocation.y;
            } else {
                location.x = screenLocation.x + event.getX();
                location.y = screenLocation.y + event.getY() + 20;
            }
            if (location.x < sBounds.x) {
                location.x = sBounds.x;
            } else if (location.x - sBounds.x + size.width > sBounds.width) {
                location.x = sBounds.x + Math.max(0, sBounds.width - size.width);
            }
            if (location.y < sBounds.y) {
                location.y = sBounds.y;
            } else if (location.y - sBounds.y + size.height > sBounds.height) {
                location.y = sBounds.y + Math.max(0, sBounds.height - size.height);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.tipWindow = popupFactory.getPopup(component, tip, location.x, location.y);
            this.tipWindow.show();
        }
        this.isVisible = true;
    }

    private void hideToolTip(MouseEvent event) {
        if (this.tipWindow != null) {
            this.tipWindow.hide();
            this.tipWindow = null;
        }
        this.isVisible = false;
    }
}

