/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.guitools.statuspanel.DatabaseDescriptor;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.StaticUtils;

public class BaseDNDescriptor
implements Comparable {
    private int nEntries;
    private int missingChanges;
    private DatabaseDescriptor db;
    private long ageOfOldestMissingChange;
    private Type type;
    private String baseDn;
    private String unescapedDn;
    private static final Logger LOG = Logger.getLogger(BaseDNDescriptor.class.getName());

    public BaseDNDescriptor(Type type, String baseDn, DatabaseDescriptor db, int nEntries, long ageOfOldestMissingChange, int missingChanges) {
        this.baseDn = baseDn;
        this.db = db;
        this.type = type;
        this.nEntries = nEntries;
        this.ageOfOldestMissingChange = ageOfOldestMissingChange;
        this.missingChanges = missingChanges;
        try {
            this.unescapedDn = this.unescapeUtf8(baseDn);
        }
        catch (Throwable t) {
            this.unescapedDn = baseDn;
            LOG.log(Level.WARNING, "Error unescaping dn: " + baseDn, t);
        }
    }

    public String getDn() {
        return this.baseDn;
    }

    public String getUnescapedDn() {
        return this.unescapedDn;
    }

    public boolean equals(Object v) {
        boolean equals = false;
        if (this != v) {
            if (v instanceof BaseDNDescriptor) {
                BaseDNDescriptor desc = (BaseDNDescriptor)v;
                equals = this.getType() == desc.getType() && Utils.areDnsEqual(this.getDn(), desc.getDn()) && this.getAgeOfOldestMissingChange() == desc.getAgeOfOldestMissingChange() && this.getMissingChanges() == desc.getMissingChanges() && this.getDatabase().getBackendID().equals(desc.getDatabase().getBackendID()) && this.getEntries() == desc.getEntries();
            }
        } else {
            equals = true;
        }
        return equals;
    }

    public int hashCode() {
        return (this.getType().toString() + this.getAgeOfOldestMissingChange() + this.getDn() + this.getDatabase().getBackendID() + this.getMissingChanges()).hashCode();
    }

    public int compareTo(Object o) {
        int returnValue = -1;
        if (o instanceof BaseDNDescriptor) {
            BaseDNDescriptor desc = (BaseDNDescriptor)o;
            returnValue = desc.getDn().compareTo(this.getDn());
        }
        return returnValue;
    }

    public int getEntries() {
        return this.nEntries;
    }

    public int getMissingChanges() {
        return this.missingChanges;
    }

    public long getAgeOfOldestMissingChange() {
        return this.ageOfOldestMissingChange;
    }

    public Type getType() {
        return this.type;
    }

    public DatabaseDescriptor getDatabase() {
        return this.db;
    }

    void setType(Type type) {
        this.type = type;
    }

    void setDatabase(DatabaseDescriptor db) {
        this.db = db;
    }

    void setEntries(int nEntries) {
        this.nEntries = nEntries;
    }

    private String unescapeUtf8(String v) throws UnsupportedEncodingException {
        byte[] stringBytes = v.getBytes("UTF-8");
        byte[] decodedBytes = new byte[stringBytes.length];
        int pos = 0;
        for (int i = 0; i < stringBytes.length; ++i) {
            if (stringBytes[i] == 92 && i + 2 < stringBytes.length && StaticUtils.isHexDigit(stringBytes[i + 1]) && StaticUtils.isHexDigit(stringBytes[i + 2])) {
                int b;
                byte escapedByte1 = stringBytes[++i];
                switch (escapedByte1) {
                    case 48: {
                        b = 0;
                        break;
                    }
                    case 49: {
                        b = 16;
                        break;
                    }
                    case 50: {
                        b = 32;
                        break;
                    }
                    case 51: {
                        b = 48;
                        break;
                    }
                    case 52: {
                        b = 64;
                        break;
                    }
                    case 53: {
                        b = 80;
                        break;
                    }
                    case 54: {
                        b = 96;
                        break;
                    }
                    case 55: {
                        b = 112;
                        break;
                    }
                    case 56: {
                        b = -128;
                        break;
                    }
                    case 57: {
                        b = -112;
                        break;
                    }
                    case 65: 
                    case 97: {
                        b = -96;
                        break;
                    }
                    case 66: 
                    case 98: {
                        b = -80;
                        break;
                    }
                    case 67: 
                    case 99: {
                        b = -64;
                        break;
                    }
                    case 68: 
                    case 100: {
                        b = -48;
                        break;
                    }
                    case 69: 
                    case 101: {
                        b = -32;
                        break;
                    }
                    case 70: 
                    case 102: {
                        b = -16;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected byte: " + escapedByte1);
                    }
                }
                byte escapedByte2 = stringBytes[++i];
                switch (escapedByte2) {
                    case 48: {
                        break;
                    }
                    case 49: {
                        b = (byte)(b | 1);
                        break;
                    }
                    case 50: {
                        b = (byte)(b | 2);
                        break;
                    }
                    case 51: {
                        b = (byte)(b | 3);
                        break;
                    }
                    case 52: {
                        b = (byte)(b | 4);
                        break;
                    }
                    case 53: {
                        b = (byte)(b | 5);
                        break;
                    }
                    case 54: {
                        b = (byte)(b | 6);
                        break;
                    }
                    case 55: {
                        b = (byte)(b | 7);
                        break;
                    }
                    case 56: {
                        b = (byte)(b | 8);
                        break;
                    }
                    case 57: {
                        b = (byte)(b | 9);
                        break;
                    }
                    case 65: 
                    case 97: {
                        b = (byte)(b | 0xA);
                        break;
                    }
                    case 66: 
                    case 98: {
                        b = (byte)(b | 0xB);
                        break;
                    }
                    case 67: 
                    case 99: {
                        b = (byte)(b | 0xC);
                        break;
                    }
                    case 68: 
                    case 100: {
                        b = (byte)(b | 0xD);
                        break;
                    }
                    case 69: 
                    case 101: {
                        b = (byte)(b | 0xE);
                        break;
                    }
                    case 70: 
                    case 102: {
                        b = (byte)(b | 0xF);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected byte: " + escapedByte2);
                    }
                }
                decodedBytes[pos++] = b;
                continue;
            }
            decodedBytes[pos++] = stringBytes[i];
        }
        return new String(decodedBytes, 0, pos, "UTF-8");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NOT_REPLICATED,
        REPLICATED;

    }
}

