/*
 * Decompiled with CFR 0.152.
 */
package studio.ultoolapp.lotusutil;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.util.Patterns;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.NonNull;
import java.util.Objects;

public final class IOUtil {
    public static void hideKeyboardFrom(@NonNull Context context, @NonNull View view) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        Objects.requireNonNull(imm).hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static String GetPathString() {
        StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < stackTraces.length; ++i) {
            builder.append(stackTraces[i]).append("\n");
        }
        return builder.toString();
    }

    public static String GetPathString(int maxLine) {
        StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < stackTraces.length && i < maxLine; ++i) {
            builder.append(stackTraces[i]).append("\n");
        }
        if (stackTraces.length > maxLine) {
            builder.append("(collapse ").append(stackTraces.length - maxLine).append(" lines)");
        }
        return builder.toString();
    }

    public static boolean isEmail(CharSequence sequence) {
        return Patterns.EMAIL_ADDRESS.matcher(sequence).matches();
    }

    public static void CopyText(Context context, String textToCopy) {
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"simple text", (CharSequence)textToCopy);
        Objects.requireNonNull(clipboard).setPrimaryClip(clip);
    }
}

