/*
 * Decompiled with CFR 0.152.
 */
package studio.ultoolapp.lotusutil;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.widget.RemoteViews;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import java.util.ArrayList;

public final class NotificationUtil {
    public static final int NOTIFICATION_LEVEL_HIGH = 4;
    public static final int NOTIFICATION_LEVEL_DEFAULT = 3;
    public static final int NOTIFICATION_LEVEL_LOW = 2;
    public static final int NOTIFICATION_LEVEL_MIN = 1;
    private static final String TAG = "NotificationUtil";
    private static final String EXAMPLE_CHANNEL_ID = "thatChannel";
    private static final String EXAMPLE_CHANNEL_NAME = "That Channel";
    private static final int EXAMPLE_PENDING_INTENT_ID = 1308;
    private static final int EXAMPLE_NOTIFICATION_ID = 2120;
    private static final int EXAMPLE_NOTIFICATION_PICTURE_RESOURCE = 0x10D0000;
    private static ArrayList<NotificationChannel> channels = new ArrayList();

    private static int LevelToPriority16(int level) {
        switch (level) {
            case 4: {
                return 1;
            }
            case 3: {
                return 0;
            }
            case 2: {
                return -1;
            }
            case 1: {
                return -2;
            }
        }
        return level;
    }

    private static void CreateExampleNotification(Context context, Class<?> openThisActivity) {
        NotificationCompat.Builder builder = NotificationUtil.getNotificationBuilder(context, EXAMPLE_CHANNEL_ID, EXAMPLE_CHANNEL_NAME, 4);
        PendingIntent action = NotificationUtil.createPendingIntent(IntentOpenType.START_ACTIVITY, context, openThisActivity, 1308);
        builder.setSmallIcon(0x10D0000).setContentTitle((CharSequence)"Hello").setContentText((CharSequence)"This is an notification.").setContentIntent(action).setAutoCancel(true);
        NotificationUtil.SendNotification(context, builder, 2120);
    }

    public static NotificationCompat.Builder getNotificationBuilder(Context context, String channelID, String channelName) {
        return NotificationUtil.getNotificationBuilder(context, channelID, channelName, 3);
    }

    public static NotificationCompat.Builder getNotificationBuilder(Context context, String channelID, String channelName, int level) {
        NotificationCompat.Builder builder;
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = NotificationUtil.getNotificationChannel(context, EXAMPLE_CHANNEL_ID, EXAMPLE_CHANNEL_NAME, level);
            builder = new NotificationCompat.Builder(context, channel.getId());
        } else {
            builder = new NotificationCompat.Builder(context).setPriority(NotificationUtil.LevelToPriority16(level));
        }
        return builder;
    }

    @RequiresApi(api=26)
    public static NotificationChannel getNotificationChannel(Context context, String channelID, String channelName) {
        return NotificationUtil.getNotificationChannel(context, channelID, channelName, 3);
    }

    @RequiresApi(api=26)
    public static NotificationChannel getNotificationChannel(Context context, String channelID, String channelName, int importance) {
        NotificationChannel channel = NotificationUtil.getChannel(channelID);
        if (channel != null) {
            channel.setImportance(importance);
        }
        return channel != null ? channel : NotificationUtil.createNotificationChannel(context, channelID, channelName, importance);
    }

    @RequiresApi(api=26)
    private static NotificationChannel createNotificationChannel(Context context, String channelID, String channelName, int importance) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        NotificationChannel channel = new NotificationChannel(channelID, (CharSequence)channelName, importance);
        assert (notificationManager != null);
        notificationManager.createNotificationChannel(channel);
        channels.add(channel);
        return channel;
    }

    @RequiresApi(api=26)
    public static NotificationChannel getChannel(String channelID) {
        for (int i = 0; i < channels.size(); ++i) {
            if (!channels.get(i).getId().equals(channelID)) continue;
            return channels.get(i);
        }
        return null;
    }

    @RequiresApi(api=26)
    public static int getChannelsCount() {
        return channels.size();
    }

    @RequiresApi(api=26)
    public static NotificationChannel getChannel(int index) {
        return channels.size() <= index ? null : channels.get(index);
    }

    @RequiresApi(api=26)
    public static NotificationChannel getDefaultChannel() {
        if (channels.size() == 0) {
            Log.e((String)TAG, (String)"getDefaultChannel: you didn't create any channel!!!!");
            return null;
        }
        return channels.get(0);
    }

    public static PendingIntent createPendingIntent(IntentOpenType actionType, Context context, Class<?> openThis, int uniqueID) {
        return NotificationUtil.createPendingIntent(actionType, context, openThis, uniqueID, 0x8000000);
    }

    public static PendingIntent createPendingIntent(IntentOpenType actionType, Context context, Intent intent, int uniqueID) {
        return NotificationUtil.createPendingIntent(actionType, context, intent, uniqueID, 0x8000000);
    }

    public static PendingIntent createPendingIntent(IntentOpenType actionType, Context context, Class<?> openThis, int uniqueID, int updateFlag) {
        Intent intent = new Intent(context, openThis);
        return NotificationUtil.createPendingIntent(actionType, context, intent, uniqueID, updateFlag);
    }

    public static PendingIntent createPendingIntent(IntentOpenType actionType, Context context, Intent intent, int uniqueID, int updateFlag) {
        PendingIntent pendingIntent = null;
        switch (actionType) {
            case START_ACTIVITY: {
                pendingIntent = PendingIntent.getActivity((Context)context, (int)uniqueID, (Intent)intent, (int)updateFlag);
                break;
            }
            case START_SERVICE: {
                pendingIntent = PendingIntent.getService((Context)context, (int)uniqueID, (Intent)intent, (int)updateFlag);
                break;
            }
            case SEND_BROADCAST: {
                pendingIntent = PendingIntent.getBroadcast((Context)context, (int)uniqueID, (Intent)intent, (int)updateFlag);
                break;
            }
            case START_FOREGROUND: {
                if (Build.VERSION.SDK_INT < 26) {
                    Log.w((String)TAG, (String)"createPendingIntent: your Android version is too old: START_FOREGROUND is unable to use. Will get service instead.");
                    pendingIntent = PendingIntent.getService((Context)context, (int)uniqueID, (Intent)intent, (int)updateFlag);
                    break;
                }
                pendingIntent = PendingIntent.getForegroundService((Context)context, (int)uniqueID, (Intent)intent, (int)updateFlag);
                break;
            }
            default: {
                Log.e((String)TAG, (String)"createPendingIntent: TAKING UN-DEFINED ACTION!!! WILL DO NOTHING.");
            }
        }
        return pendingIntent;
    }

    public static PendingIntent createBundledActivityPendingIntent(Context context, Class<?> openThis, Bundle bundle, int uniqueID) {
        return PendingIntent.getActivity((Context)context, (int)uniqueID, (Intent)new Intent(context, openThis), (int)0x8000000, (Bundle)bundle);
    }

    public static PendingIntent createBundledActivityPendingIntent(Context context, Class<?> openThis, Bundle bundle, int uniqueID, int updateFlag) {
        return PendingIntent.getActivity((Context)context, (int)uniqueID, (Intent)new Intent(context, openThis), (int)updateFlag, (Bundle)bundle);
    }

    public static PendingIntent createActivitiesPendingIntent(Context context, Class<?>[] openThese, int uniqueID, int updateFlag) {
        Intent[] intents = new Intent[openThese.length];
        for (int i = 0; i < intents.length; ++i) {
            intents[i] = new Intent(context, openThese[i]);
        }
        return PendingIntent.getActivities((Context)context, (int)uniqueID, (Intent[])intents, (int)updateFlag);
    }

    public static PendingIntent createBundledActivitiesPendingIntent(Context context, Class<?>[] openThese, Bundle bundle, int uniqueID, int updateFlag) {
        Intent[] intents = new Intent[openThese.length];
        for (int i = 0; i < intents.length; ++i) {
            intents[i] = new Intent(context, openThese[i]);
        }
        return PendingIntent.getActivities((Context)context, (int)uniqueID, (Intent[])intents, (int)updateFlag, (Bundle)bundle);
    }

    public static NotificationCompat.Builder UpdateContentView(NotificationCompat.Builder builder, RemoteViews remoteViews) {
        if (Build.VERSION.SDK_INT < 24) {
            builder.setContent(remoteViews);
        } else {
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.DecoratedCustomViewStyle()).setCustomContentView(remoteViews);
        }
        return builder;
    }

    public static void SendNotification(Context context, NotificationCompat.Builder builder, int notificationID) {
        Notification notification = builder.build();
        if (Build.VERSION.SDK_INT >= 26) {
            if (channels.size() == 0) {
                Log.e((String)TAG, (String)"SendNotification: you didn't create notification channel before sending notification -- it is not recommended in Oreo / API 26 or above. Will do nothing.");
                return;
            }
            if (notification.getChannelId().equals("")) {
                Log.e((String)TAG, (String)"SendNotification: channel ID not assigned. Will be assigned with first created channel.");
                notification = builder.setChannelId(channels.get(0).getId()).build();
            }
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        assert (notificationManager != null);
        notificationManager.notify(notificationID, notification);
    }

    public static void SendNotification(Context context, Notification notification, int notificationID) {
        if (Build.VERSION.SDK_INT >= 26) {
            if (channels.size() == 0) {
                Log.e((String)TAG, (String)"SendNotification: you didn't create notification channel before sending notification -- it is not allowed in Oreo / API 26 or above. Will do nothing.");
                return;
            }
            if (notification.getChannelId().equals("")) {
                Log.e((String)TAG, (String)"SendNotification: channel ID not assigned. Won't send.");
                return;
            }
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        assert (notificationManager != null);
        notificationManager.notify(notificationID, notification);
    }

    public static void clearAllNotifications(Context context) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        assert (notificationManager != null);
        notificationManager.cancelAll();
    }

    public static void CancelSingleNotification(Context context, int notificationID) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        assert (notificationManager != null);
        notificationManager.cancel(notificationID);
    }

    public static void CancelSingleNotification(Context context, String notificationTag, int notificationID) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        assert (notificationManager != null);
        notificationManager.cancel(notificationTag, notificationID);
    }

    public static enum IntentOpenType {
        START_ACTIVITY,
        START_SERVICE,
        SEND_BROADCAST,
        START_FOREGROUND;

    }
}

