/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.terminal;

import com.sshtools.daemon.terminal.Colorizer;
import com.sshtools.daemon.terminal.Terminal;
import com.sshtools.daemon.terminal.TerminalIO;

public abstract class BasicTerminal
implements Terminal {
    protected Colorizer myColorizer = Colorizer.getReference();

    public int translateControlCharacter(int n) {
        switch (n) {
            case 127: {
                return 1302;
            }
            case 8: {
                return 1303;
            }
            case 9: {
                return 1301;
            }
            case 27: {
                return 1200;
            }
            case 1: {
                return 1304;
            }
            case 4: {
                return 1306;
            }
        }
        return n;
    }

    public int translateEscapeSequence(int[] nArray) {
        try {
            if (nArray[0] == 91) {
                switch (nArray[1]) {
                    case 65: {
                        return 1001;
                    }
                    case 66: {
                        return 1002;
                    }
                    case 67: {
                        return 1003;
                    }
                    case 68: {
                        return 1004;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 1201;
        }
        return 1202;
    }

    public byte[] getCursorMoveSequence(int n, int n2) {
        byte[] byArray = null;
        byArray = n2 == 1 ? new byte[3] : new byte[n2 * 3];
        for (int i = 0; i < n2 * 3; ++i) {
            byArray[i] = 27;
            byArray[i + 1] = 91;
            switch (n) {
                case 1001: {
                    byArray[i + 2] = 65;
                    break;
                }
                case 1002: {
                    byArray[i + 2] = 66;
                    break;
                }
                case 1003: {
                    byArray[i + 2] = 67;
                    break;
                }
                case 1004: {
                    byArray[i + 2] = 68;
                    break;
                }
            }
            i += 2;
        }
        return byArray;
    }

    public byte[] getCursorPositioningSequence(int[] nArray) {
        byte[] byArray = null;
        if (nArray == TerminalIO.HOME) {
            byArray = new byte[]{27, 91, 72};
        } else {
            byte[] byArray2 = this.translateIntToDigitCodes(nArray[0]);
            byte[] byArray3 = this.translateIntToDigitCodes(nArray[1]);
            int n = 0;
            byArray = new byte[4 + byArray2.length + byArray3.length];
            byArray[0] = 27;
            byArray[1] = 91;
            System.arraycopy(byArray2, 0, byArray, 2, byArray2.length);
            n = 2 + byArray2.length;
            byArray[n] = 59;
            System.arraycopy(byArray3, 0, byArray, ++n, byArray3.length);
            byArray[n += byArray3.length] = 72;
        }
        return byArray;
    }

    public byte[] getEraseSequence(int n) {
        byte[] byArray = null;
        switch (n) {
            case 1100: {
                byArray = new byte[]{27, 91, 75};
                break;
            }
            case 1101: {
                byArray = new byte[]{27, 91, 49, 75};
                break;
            }
            case 1103: {
                byArray = new byte[]{27, 91, 50, 75};
                break;
            }
            case 1104: {
                byArray = new byte[]{27, 91, 74};
                break;
            }
            case 1105: {
                byArray = new byte[]{27, 91, 49, 74};
                break;
            }
            case 1106: {
                byArray = new byte[]{27, 91, 50, 74};
                break;
            }
        }
        return byArray;
    }

    public byte[] getSpecialSequence(int n) {
        byte[] byArray = null;
        switch (n) {
            case 1051: {
                byArray = new byte[]{27, 55};
                break;
            }
            case 1052: {
                byArray = new byte[]{27, 56};
            }
        }
        return byArray;
    }

    public byte[] getGRSequence(int n, int n2) {
        byte[] byArray = new byte[]{};
        int n3 = 0;
        switch (n) {
            case 10001: 
            case 10002: {
                byte[] byArray2 = this.translateIntToDigitCodes(n2);
                byArray = new byte[3 + byArray2.length];
                byArray[0] = 27;
                byArray[1] = 91;
                System.arraycopy(byArray2, 0, byArray, 2, byArray2.length);
                n3 = 2 + byArray2.length;
                byArray[n3] = 109;
                break;
            }
            case 10003: {
                byte[] byArray3 = this.translateIntToDigitCodes(n2);
                byArray = new byte[3 + byArray3.length];
                byArray[0] = 27;
                byArray[1] = 91;
                System.arraycopy(byArray3, 0, byArray, 2, byArray3.length);
                n3 = 2 + byArray3.length;
                byArray[n3] = 109;
                break;
            }
            case 10004: {
                byArray = new byte[]{27, 91, 52, 56, 109};
            }
        }
        return byArray;
    }

    public byte[] getScrollMarginsSequence(int n, int n2) {
        byte[] byArray = new byte[]{};
        if (this.supportsScrolling()) {
            byte[] byArray2 = this.translateIntToDigitCodes(n);
            byte[] byArray3 = this.translateIntToDigitCodes(n2);
            int n3 = 0;
            byArray = new byte[4 + byArray2.length + byArray3.length];
            byArray[0] = 27;
            byArray[1] = 91;
            System.arraycopy(byArray2, 0, byArray, 2, byArray2.length);
            n3 = 2 + byArray2.length;
            byArray[n3] = 59;
            System.arraycopy(byArray3, 0, byArray, ++n3, byArray3.length);
            byArray[n3 += byArray3.length] = 114;
        }
        return byArray;
    }

    public String format(String string) {
        return this.myColorizer.colorize(string, this.supportsSGR());
    }

    public byte[] getInitSequence() {
        byte[] byArray = new byte[]{};
        return byArray;
    }

    public int getAtomicSequenceLength() {
        return 2;
    }

    public byte[] translateIntToDigitCodes(int n) {
        return Integer.toString(n).getBytes();
    }

    public abstract boolean supportsSGR();

    public abstract boolean supportsScrolling();
}

