/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelDataWindow;
import java.io.IOException;
import java.io.OutputStream;

public class ChannelOutputStream
extends OutputStream {
    private Channel channel;
    private boolean isClosed = false;
    private Integer type = null;

    public ChannelOutputStream(Channel channel, Integer n) {
        this.channel = channel;
        this.type = n;
    }

    public ChannelOutputStream(Channel channel) {
        this(channel, null);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void close() throws IOException {
        this.isClosed = true;
        if (!this.channel.isClosed()) {
            this.channel.connection.sendChannelEOF(this.channel);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException("The ChannelOutputStream is closed!");
        }
        byte[] byArray2 = null;
        if (n > 0 || n2 < byArray.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        } else {
            byArray2 = byArray;
        }
        this.sendChannelData(byArray2);
    }

    public void write(int n) throws IOException {
        if (this.isClosed) {
            throw new IOException("The ChannelOutputStream is closed!");
        }
        byte[] byArray = new byte[]{(byte)n};
        this.sendChannelData(byArray);
    }

    private void sendChannelData(byte[] byArray) throws IOException {
        int n = 0;
        ChannelDataWindow channelDataWindow = this.channel.getRemoteWindow();
        while (n < byArray.length) {
            int n2 = byArray.length - n;
            long l = channelDataWindow.getWindowSpace() < this.channel.getRemotePacketSize() ? channelDataWindow.getWindowSpace() : this.channel.getRemotePacketSize();
            int n3 = l < (long)n2 ? (int)l : n2;
            this.channel.remoteWindow.consumeWindowSpace(n3);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n, byArray2, 0, n3);
            if (this.type != null) {
                this.channel.sendChannelExtData(this.type, byArray2);
            } else {
                this.channel.sendChannelData(byArray2);
            }
            n += n3;
        }
    }
}

