/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClientFactory;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshToolsConnectionHostTab
extends JPanel
implements SshToolsConnectionTab {
    public static final int DEFAULT_PORT = 22;
    public static final String CONNECT_ICON = "largeserveridentity.png";
    public static final String AUTH_ICON = "largelock.png";
    public static final String SHOW_AVAILABLE = "<Show available methods>";
    protected XTextField jTextHostname = new XTextField();
    protected NumericTextField jTextPort = new NumericTextField(new Integer(0), new Integer(65535), new Integer(22));
    protected XTextField jTextUsername = new XTextField();
    protected JList jListAuths = new JList();
    protected List methods = new ArrayList();
    protected SshToolsConnectionProfile profile;
    protected JCheckBox allowAgentForwarding;
    protected Log log = LogFactory.getLog((Class)(class$com$sshtools$common$ui$SshToolsConnectionHostTab == null ? (class$com$sshtools$common$ui$SshToolsConnectionHostTab = SshToolsConnectionHostTab.class$("com.sshtools.common.ui.SshToolsConnectionHostTab")) : class$com$sshtools$common$ui$SshToolsConnectionHostTab));
    static /* synthetic */ Class class$com$sshtools$common$ui$SshToolsConnectionHostTab;

    public SshToolsConnectionHostTab() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        UIUtil.jGridBagAdd(jPanel, new JLabel("Hostname"), gridBagConstraints, 0);
        gridBagConstraints.fill = 2;
        UIUtil.jGridBagAdd(jPanel, this.jTextHostname, gridBagConstraints, 0);
        gridBagConstraints.fill = 0;
        UIUtil.jGridBagAdd(jPanel, new JLabel("Port"), gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel, this.jTextPort, gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel, new JLabel("Username"), gridBagConstraints, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        UIUtil.jGridBagAdd(jPanel, this.jTextUsername, gridBagConstraints, 0);
        gridBagConstraints.fill = 0;
        IconWrapperPanel iconWrapperPanel = new IconWrapperPanel(new ResourceIcon(class$com$sshtools$common$ui$SshToolsConnectionHostTab == null ? (class$com$sshtools$common$ui$SshToolsConnectionHostTab = SshToolsConnectionHostTab.class$("com.sshtools.common.ui.SshToolsConnectionHostTab")) : class$com$sshtools$common$ui$SshToolsConnectionHostTab, CONNECT_ICON), jPanel);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Authentication Methods"), gridBagConstraints, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        this.jListAuths.setVisibleRowCount(5);
        UIUtil.jGridBagAdd(jPanel2, new JScrollPane(this.jListAuths), gridBagConstraints, 0);
        this.allowAgentForwarding = new JCheckBox("Allow agent forwarding");
        UIUtil.jGridBagAdd(jPanel2, this.allowAgentForwarding, gridBagConstraints, 0);
        IconWrapperPanel iconWrapperPanel2 = new IconWrapperPanel(new ResourceIcon(class$com$sshtools$common$ui$SshToolsConnectionHostTab == null ? (class$com$sshtools$common$ui$SshToolsConnectionHostTab = SshToolsConnectionHostTab.class$("com.sshtools.common.ui.SshToolsConnectionHostTab")) : class$com$sshtools$common$ui$SshToolsConnectionHostTab, AUTH_ICON), jPanel2);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        UIUtil.jGridBagAdd(this, iconWrapperPanel, gridBagConstraints, 0);
        gridBagConstraints.weighty = 1.0;
        UIUtil.jGridBagAdd(this, iconWrapperPanel2, gridBagConstraints, 0);
        this.addAuthenticationMethods();
    }

    public void setConnectionProfile(SshToolsConnectionProfile sshToolsConnectionProfile) {
        this.profile = sshToolsConnectionProfile;
        this.jTextHostname.setText(sshToolsConnectionProfile == null ? "" : sshToolsConnectionProfile.getHost());
        this.jTextUsername.setText(sshToolsConnectionProfile == null ? "" : sshToolsConnectionProfile.getUsername());
        this.jTextPort.setValue(new Integer(sshToolsConnectionProfile == null ? 22 : sshToolsConnectionProfile.getPort()));
        if (System.getProperty("sshtools.agent") == null) {
            this.allowAgentForwarding.setSelected(false);
            this.allowAgentForwarding.setEnabled(false);
        } else {
            this.allowAgentForwarding.setEnabled(true);
            this.allowAgentForwarding.setSelected(sshToolsConnectionProfile != null && sshToolsConnectionProfile.getAllowAgentForwarding());
        }
        Map map = sshToolsConnectionProfile == null ? new HashMap() : sshToolsConnectionProfile.getAuthenticationMethods();
        Iterator iterator = map.entrySet().iterator();
        int[] nArray = new int[map.values().size()];
        int n = 0;
        ListModel listModel = this.jListAuths.getModel();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            for (int i = 0; i < listModel.getSize(); ++i) {
                if (!listModel.getElementAt(i).equals(string)) continue;
                nArray[n++] = i;
                break;
            }
            this.jListAuths.clearSelection();
            this.jListAuths.setSelectedIndices(nArray);
        }
    }

    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    private void addAuthenticationMethods() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(SHOW_AVAILABLE);
        arrayList.addAll(SshAuthenticationClientFactory.getSupportedMethods());
        this.jListAuths.setListData(arrayList.toArray());
        this.jListAuths.setSelectedIndex(0);
    }

    public String getTabContext() {
        return "Connection";
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabTitle() {
        return "Host";
    }

    public String getTabToolTipText() {
        return "The main host connection details.";
    }

    public int getTabMnemonic() {
        return 104;
    }

    public Component getTabComponent() {
        return this;
    }

    public boolean validateTab() {
        if (this.jTextHostname.getText().equals("") || this.jTextPort.getText().equals("") || this.jTextUsername.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Please enter all details!", "Connect", 0);
            return false;
        }
        List list = this.getChosenAuth();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    SshAuthenticationClient sshAuthenticationClient = SshAuthenticationClientFactory.newInstance((String)string);
                }
                catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
                    JOptionPane.showMessageDialog(this, string + " is not supported!");
                    return false;
                }
            }
        }
        return true;
    }

    private List getChosenAuth() {
        Object[] objectArray = this.jListAuths.getSelectedValues();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                if (string.equals(SHOW_AVAILABLE)) {
                    return null;
                }
                arrayList.add(string);
            }
        } else {
            return null;
        }
        return arrayList;
    }

    public void applyTab() {
        this.profile.setHost(this.jTextHostname.getText());
        this.profile.setPort(Integer.valueOf(this.jTextPort.getText()));
        this.profile.setUsername(this.jTextUsername.getText());
        this.profile.setAllowAgentForwarding(this.allowAgentForwarding.getModel().isSelected());
        List list = this.getChosenAuth();
        this.profile.removeAuthenticationMethods();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    SshAuthenticationClient sshAuthenticationClient = SshAuthenticationClientFactory.newInstance((String)string);
                    sshAuthenticationClient.setUsername(this.jTextUsername.getText());
                    this.profile.addAuthenticationMethod(sshAuthenticationClient);
                }
                catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
                    this.log.error((Object)"This should have been caught by validateTab()?", (Throwable)algorithmNotSupportedException);
                }
            }
        }
    }

    public void tabSelected() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

