/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.httpinvoker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.springframework.remoting.httpinvoker.AbstractHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.support.RemoteInvocationResult;

public class CommonsHttpInvokerRequestExecutor
extends AbstractHttpInvokerRequestExecutor {
    private HttpClient httpClient;

    public CommonsHttpInvokerRequestExecutor() {
        this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    }

    public CommonsHttpInvokerRequestExecutor(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteInvocationResult doExecuteRequest(HttpInvokerClientConfiguration config, ByteArrayOutputStream baos) throws IOException, ClassNotFoundException {
        PostMethod postMethod = this.createPostMethod(config);
        try {
            postMethod.setRequestBody((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            this.executePostMethod(config, this.httpClient, postMethod);
            RemoteInvocationResult remoteInvocationResult = this.readRemoteInvocationResult(postMethod.getResponseBodyAsStream(), config.getCodebaseUrl());
            return remoteInvocationResult;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    protected PostMethod createPostMethod(HttpInvokerClientConfiguration config) throws IOException {
        PostMethod postMethod = new PostMethod(config.getServiceUrl());
        postMethod.setRequestHeader("Content-Type", "application/x-java-serialized-object");
        return postMethod;
    }

    protected void executePostMethod(HttpInvokerClientConfiguration config, HttpClient httpClient, PostMethod postMethod) throws IOException {
        this.httpClient.executeMethod((HttpMethod)postMethod);
    }
}

