/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.util.ClassUtils;

public class TransactionAwarePersistenceManagerFactoryProxy
implements FactoryBean {
    private PersistenceManagerFactory target;
    private PersistenceManagerFactory proxy;
    static /* synthetic */ Class class$javax$jdo$PersistenceManagerFactory;

    public void setTargetPersistenceManagerFactory(PersistenceManagerFactory target) {
        this.target = target;
        this.proxy = (PersistenceManagerFactory)Proxy.newProxyInstance((class$javax$jdo$PersistenceManagerFactory == null ? (class$javax$jdo$PersistenceManagerFactory = TransactionAwarePersistenceManagerFactoryProxy.class$("javax.jdo.PersistenceManagerFactory")) : class$javax$jdo$PersistenceManagerFactory).getClassLoader(), new Class[]{class$javax$jdo$PersistenceManagerFactory == null ? (class$javax$jdo$PersistenceManagerFactory = TransactionAwarePersistenceManagerFactoryProxy.class$("javax.jdo.PersistenceManagerFactory")) : class$javax$jdo$PersistenceManagerFactory}, (InvocationHandler)new TransactionAwareFactoryInvocationHandler(target));
    }

    public PersistenceManagerFactory getTargetPersistenceManagerFactory() {
        return this.target;
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class getObjectType() {
        return class$javax$jdo$PersistenceManagerFactory == null ? (class$javax$jdo$PersistenceManagerFactory = TransactionAwarePersistenceManagerFactoryProxy.class$("javax.jdo.PersistenceManagerFactory")) : class$javax$jdo$PersistenceManagerFactory;
    }

    public boolean isSingleton() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private final PersistenceManager target;
        private final PersistenceManagerFactory persistenceManagerFactory;

        public TransactionAwareInvocationHandler(PersistenceManager target, PersistenceManagerFactory pmf) {
            this.target = target;
            this.persistenceManagerFactory = pmf;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("close")) {
                if (this.persistenceManagerFactory != null) {
                    PersistenceManagerFactoryUtils.doReleasePersistenceManager(this.target, this.persistenceManagerFactory);
                }
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private static class TransactionAwareFactoryInvocationHandler
    implements InvocationHandler {
        private final PersistenceManagerFactory target;

        public TransactionAwareFactoryInvocationHandler(PersistenceManagerFactory target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getPersistenceManager")) {
                PersistenceManager pm = PersistenceManagerFactoryUtils.doGetPersistenceManager(this.target, true);
                Class[] ifcs = ClassUtils.getAllInterfaces(pm);
                return (PersistenceManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), ifcs, (InvocationHandler)new TransactionAwareInvocationHandler(pm, this.target));
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

