/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.assembler;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.MBeanParameterInfo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.assembler.AbstractReflectiveMBeanInfoAssembler;
import org.springframework.jmx.export.assembler.AutodetectCapableMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.InvalidMetadataException;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.metadata.ManagedAttribute;
import org.springframework.jmx.export.metadata.ManagedOperation;
import org.springframework.jmx.export.metadata.ManagedOperationParameter;
import org.springframework.jmx.export.metadata.ManagedResource;
import org.springframework.util.StringUtils;

public class MetadataMBeanInfoAssembler
extends AbstractReflectiveMBeanInfoAssembler
implements AutodetectCapableMBeanInfoAssembler,
InitializingBean {
    private static final String LOG = "log";
    private static final String LOG_FILE = "logFile";
    private static final String CURRENCY_TIME_LIMIT = "currencyTimeLimit";
    private static final String DEFAULT = "default";
    private static final String PERSIST_POLICY = "persistPolicy";
    private static final String PERSIST_PERIOD = "persistPeriod";
    private static final String PERSIST_LOCATION = "persistLocation";
    private static final String PERSIST_NAME = "persistName";
    private JmxAttributeSource attributeSource;

    public void setAttributeSource(JmxAttributeSource attributeSource) {
        this.attributeSource = attributeSource;
    }

    public void afterPropertiesSet() {
        if (this.attributeSource == null) {
            throw new IllegalArgumentException("'attributeSource' is required");
        }
    }

    protected boolean includeReadAttribute(Method method, String beanKey) {
        return this.hasManagedAttribute(method);
    }

    protected boolean includeWriteAttribute(Method method, String beanKey) {
        return this.hasManagedAttribute(method);
    }

    protected boolean includeOperation(Method method, String beanKey) {
        PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
        if (pd != null) {
            return this.hasManagedAttribute(method);
        }
        return this.hasManagedOperation(method);
    }

    protected String getOperationDescription(Method method) {
        PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
        if (pd != null) {
            ManagedAttribute ma = this.attributeSource.getManagedAttribute(method);
            if (ma != null && StringUtils.hasText(ma.getDescription())) {
                return ma.getDescription();
            }
            return method.getName();
        }
        ManagedOperation mo = this.attributeSource.getManagedOperation(method);
        if (mo != null && StringUtils.hasText(mo.getDescription())) {
            return mo.getDescription();
        }
        return method.getName();
    }

    protected String getAttributeDescription(PropertyDescriptor propertyDescriptor) {
        ManagedAttribute setter;
        Method readMethod = propertyDescriptor.getReadMethod();
        Method writeMethod = propertyDescriptor.getWriteMethod();
        ManagedAttribute getter = readMethod != null ? this.attributeSource.getManagedAttribute(readMethod) : null;
        ManagedAttribute managedAttribute = setter = writeMethod != null ? this.attributeSource.getManagedAttribute(writeMethod) : null;
        if (getter != null && StringUtils.hasText(getter.getDescription())) {
            return getter.getDescription();
        }
        if (setter != null && StringUtils.hasText(setter.getDescription())) {
            return setter.getDescription();
        }
        return propertyDescriptor.getDisplayName();
    }

    protected String getDescription(String beanKey, Class beanClass) {
        ManagedResource mr = this.attributeSource.getManagedResource(beanClass);
        return mr != null ? mr.getDescription() : "";
    }

    protected void populateMBeanDescriptor(Descriptor mbeanDescriptor, String beanKey, Class beanClass) {
        ManagedResource mr = this.attributeSource.getManagedResource(beanClass);
        if (mr == null) {
            throw new InvalidMetadataException("No ManagedResource attribute found for class: " + beanClass.getName());
        }
        if (mr.getCurrencyTimeLimit() > 0) {
            mbeanDescriptor.setField(CURRENCY_TIME_LIMIT, Integer.toString(mr.getCurrencyTimeLimit()));
        }
        mbeanDescriptor.setField(LOG, mr.isLog() ? "true" : "false");
        if (mr.getLogFile() != null) {
            mbeanDescriptor.setField(LOG_FILE, mr.getLogFile());
        }
        mbeanDescriptor.setField(PERSIST_POLICY, mr.getPersistPolicy());
        mbeanDescriptor.setField(PERSIST_PERIOD, Integer.toString(mr.getPersistPeriod()));
        mbeanDescriptor.setField(PERSIST_NAME, mr.getPersistName());
        mbeanDescriptor.setField(PERSIST_LOCATION, mr.getPersistLocation());
    }

    protected void populateAttributeDescriptor(Descriptor descriptor, Method getter, Method setter) {
        ManagedAttribute gma = getter == null ? ManagedAttribute.EMPTY : this.attributeSource.getManagedAttribute(getter);
        ManagedAttribute sma = setter == null ? ManagedAttribute.EMPTY : this.attributeSource.getManagedAttribute(setter);
        int ctl = this.resolveIntDescriptor(gma.getCurrencyTimeLimit(), sma.getCurrencyTimeLimit());
        descriptor.setField(CURRENCY_TIME_LIMIT, Integer.toString(ctl));
        Object defaultValue = this.resolveObjectDescriptor(gma.getDefaultValue(), sma.getDefaultValue());
        descriptor.setField(DEFAULT, defaultValue);
        String persistPolicy = this.resolveStringDescriptor(gma.getPersistPolicy(), sma.getPersistPolicy(), "Never");
        descriptor.setField(PERSIST_POLICY, persistPolicy);
        int persistPeriod = this.resolveIntDescriptor(gma.getPersistPeriod(), sma.getPersistPeriod());
        descriptor.setField(PERSIST_PERIOD, Integer.toString(persistPeriod));
    }

    protected void populateOperationDescriptor(Descriptor descriptor, Method method) {
        ManagedOperation mo = this.attributeSource.getManagedOperation(method);
        if (mo != null) {
            descriptor.setField(CURRENCY_TIME_LIMIT, Integer.toString(mo.getCurrencyTimeLimit()));
        }
    }

    protected MBeanParameterInfo[] getOperationParameters(Method method) {
        ManagedOperationParameter[] params = this.attributeSource.getManagedOperationParameters(method);
        if (params == null || params.length == 0) {
            return new MBeanParameterInfo[0];
        }
        MBeanParameterInfo[] parameterInfo = new MBeanParameterInfo[params.length];
        Class<?>[] methodParameters = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            ManagedOperationParameter param = params[i];
            parameterInfo[i] = new MBeanParameterInfo(param.getName(), methodParameters[i].getName(), param.getDescription());
        }
        return parameterInfo;
    }

    private int resolveIntDescriptor(int getter, int setter) {
        if (getter == 0 && setter != 0) {
            return setter;
        }
        if (setter == 0 && getter != 0) {
            return getter;
        }
        return getter >= setter ? getter : setter;
    }

    private Object resolveObjectDescriptor(Object getter, Object setter) {
        if (getter != null) {
            return getter;
        }
        if (setter != null) {
            return setter;
        }
        return null;
    }

    private String resolveStringDescriptor(String getter, String setter, String defaultValue) {
        if (getter != null && !defaultValue.equals(getter)) {
            return getter;
        }
        if (setter != null) {
            return setter;
        }
        return null;
    }

    private boolean hasManagedAttribute(Method method) {
        ManagedAttribute ma = this.attributeSource.getManagedAttribute(method);
        return ma != null;
    }

    private boolean hasManagedOperation(Method method) {
        ManagedOperation mo = this.attributeSource.getManagedOperation(method);
        return mo != null;
    }

    public boolean includeBean(String beanName, Class beanClass) {
        ManagedResource mr = this.attributeSource.getManagedResource(beanClass);
        return mr != null;
    }
}

