/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.validation.DefaultMessageCodesResolver;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.ObjectError;

public class BindException
extends Exception
implements Errors {
    public static final String ERROR_KEY_PREFIX = (class$org$springframework$validation$BindException == null ? (class$org$springframework$validation$BindException = BindException.class$("org.springframework.validation.BindException")) : class$org$springframework$validation$BindException).getName() + ".";
    private final List errors = new LinkedList();
    private final BeanWrapper beanWrapper;
    private final String objectName;
    private MessageCodesResolver messageCodesResolver = new DefaultMessageCodesResolver();
    private String nestedPath = "";
    private final Stack nestedPathStack = new Stack();
    static /* synthetic */ Class class$org$springframework$validation$BindException;

    public BindException(Object target, String name) {
        this.beanWrapper = new BeanWrapperImpl(target);
        this.objectName = name;
        this.nestedPath = "";
    }

    protected BeanWrapper getBeanWrapper() {
        return this.beanWrapper;
    }

    public Object getTarget() {
        return this.beanWrapper.getWrappedInstance();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    public MessageCodesResolver getMessageCodesResolver() {
        return this.messageCodesResolver;
    }

    public void setNestedPath(String nestedPath) {
        this.doSetNestedPath(nestedPath);
        this.nestedPathStack.clear();
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public void pushNestedPath(String subPath) {
        this.nestedPathStack.push(this.nestedPath);
        this.doSetNestedPath(this.nestedPath + subPath);
    }

    public void popNestedPath() throws IllegalArgumentException {
        try {
            String formerNestedPath = (String)this.nestedPathStack.pop();
            this.doSetNestedPath(formerNestedPath);
        }
        catch (EmptyStackException ex) {
            throw new IllegalStateException("Cannot pop nested path: no nested path on stack");
        }
    }

    protected void doSetNestedPath(String nestedPath) {
        if (nestedPath == null) {
            nestedPath = "";
        }
        if (nestedPath.length() > 0 && !nestedPath.endsWith(".")) {
            nestedPath = nestedPath + ".";
        }
        this.nestedPath = nestedPath;
    }

    protected String fixedField(String field) {
        return this.nestedPath + field;
    }

    public void reject(String errorCode, String defaultMessage) {
        this.reject(errorCode, null, defaultMessage);
    }

    public void reject(String errorCode, Object[] errorArgs, String defaultMessage) {
        this.addError(new ObjectError(this.objectName, this.resolveMessageCodes(errorCode), errorArgs, defaultMessage));
    }

    public void rejectValue(String field, String errorCode, String defaultMessage) {
        this.rejectValue(field, errorCode, null, defaultMessage);
    }

    public void rejectValue(String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        String fixedField = this.fixedField(field);
        Object newVal = this.getBeanWrapper().getPropertyValue(fixedField);
        FieldError fe = new FieldError(this.objectName, fixedField, newVal, false, this.resolveMessageCodes(errorCode, field), errorArgs, defaultMessage);
        this.addError(fe);
    }

    protected String[] resolveMessageCodes(String errorCode) {
        return this.messageCodesResolver.resolveMessageCodes(errorCode, this.objectName);
    }

    protected String[] resolveMessageCodes(String errorCode, String field) {
        String fixedField = this.fixedField(field);
        Class fieldType = this.beanWrapper.getPropertyType(fixedField);
        return this.messageCodesResolver.resolveMessageCodes(errorCode, this.objectName, fixedField, fieldType);
    }

    protected void addError(ObjectError error) {
        this.errors.add(error);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public List getAllErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean hasGlobalErrors() {
        return this.getGlobalErrorCount() > 0;
    }

    public int getGlobalErrorCount() {
        return this.getGlobalErrors().size();
    }

    public List getGlobalErrors() {
        LinkedList result = new LinkedList();
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            Object error = it.next();
            if (error instanceof FieldError) continue;
            result.add(error);
        }
        return Collections.unmodifiableList(result);
    }

    public ObjectError getGlobalError() {
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            ObjectError objectError = (ObjectError)it.next();
            if (objectError instanceof FieldError) continue;
            return objectError;
        }
        return null;
    }

    public boolean hasFieldErrors(String field) {
        return this.getFieldErrorCount(field) > 0;
    }

    public int getFieldErrorCount(String field) {
        return this.getFieldErrors(field).size();
    }

    public List getFieldErrors(String field) {
        LinkedList result = new LinkedList();
        String fixedField = this.fixedField(field);
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            Object error = it.next();
            if (!(error instanceof FieldError) || !this.isMatchingFieldError(fixedField, (FieldError)error)) continue;
            result.add(error);
        }
        return Collections.unmodifiableList(result);
    }

    public FieldError getFieldError(String field) {
        String fixedField = this.fixedField(field);
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            FieldError fe;
            Object error = it.next();
            if (!(error instanceof FieldError) || !this.isMatchingFieldError(fixedField, fe = (FieldError)error)) continue;
            return fe;
        }
        return null;
    }

    protected boolean isMatchingFieldError(String field, FieldError fieldError) {
        return field.equals(fieldError.getField()) || field.endsWith("*") && fieldError.getField().startsWith(field.substring(0, field.length() - 1));
    }

    public Object getFieldValue(String field) {
        PropertyEditor customEditor;
        Object value;
        FieldError fe = this.getFieldError(field);
        String fixedField = this.fixedField(field);
        Object object = value = fe != null ? fe.getRejectedValue() : this.getBeanWrapper().getPropertyValue(fixedField);
        if (!(fe != null && fe.isBindingFailure() || (customEditor = this.getCustomEditor(fixedField)) == null)) {
            customEditor.setValue(value);
            return customEditor.getAsText();
        }
        return value;
    }

    public PropertyEditor getCustomEditor(String field) {
        String fixedField = this.fixedField(field);
        Class type = this.getBeanWrapper().getPropertyType(fixedField);
        return this.getBeanWrapper().findCustomEditor(type, fixedField);
    }

    public final Map getModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(ERROR_KEY_PREFIX + this.objectName, this);
        model.put(this.objectName, this.beanWrapper.getWrappedInstance());
        return model;
    }

    public String getMessage() {
        StringBuffer sb = new StringBuffer("BindException: ");
        sb.append(this.getErrorCount()).append(" errors");
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            sb.append("; ").append(it.next());
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

