/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.ResultReader;
import org.springframework.jdbc.object.SqlQuery;

public abstract class MappingSqlQueryWithParameters
extends SqlQuery {
    public MappingSqlQueryWithParameters() {
    }

    public MappingSqlQueryWithParameters(DataSource ds, String sql) {
        super(ds, sql);
    }

    protected ResultReader newResultReader(int rowsExpected, Object[] parameters, Map context) {
        return new ResultReaderImpl(rowsExpected, parameters, context);
    }

    protected abstract Object mapRow(ResultSet var1, int var2, Object[] var3, Map var4) throws SQLException;

    protected class ResultReaderImpl
    implements ResultReader {
        private final List results;
        private final Object[] params;
        private final Map context;
        private int rowNum = 0;

        public ResultReaderImpl(int rowsExpected, Object[] parameters, Map context) {
            this.results = rowsExpected > 0 ? new ArrayList(rowsExpected) : new LinkedList();
            this.params = parameters;
            this.context = context;
        }

        public void processRow(ResultSet rs) throws SQLException {
            this.results.add(MappingSqlQueryWithParameters.this.mapRow(rs, this.rowNum++, this.params, this.context));
        }

        public List getResults() {
            return this.results;
        }
    }
}

