/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.List;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.InterceptorAndDynamicMethodMatcher;

public class ReflectiveMethodInvocation
implements MethodInvocation,
Cloneable {
    protected Object proxy;
    protected Object target;
    protected Method method;
    protected Object[] arguments;
    private Class targetClass;
    protected List interceptorsAndDynamicMethodMatchers;
    private int currentInterceptorIndex = -1;

    public ReflectiveMethodInvocation(Object proxy, Object target, Method method, Object[] arguments, Class targetClass, List interceptorsAndDynamicMethodMatchers) {
        this.proxy = proxy;
        this.target = target;
        this.targetClass = targetClass;
        this.method = method;
        this.arguments = arguments;
        this.interceptorsAndDynamicMethodMatchers = interceptorsAndDynamicMethodMatchers;
    }

    public final Object getProxy() {
        return this.proxy;
    }

    public final Object getThis() {
        return this.target;
    }

    public final AccessibleObject getStaticPart() {
        return this.method;
    }

    public final Method getMethod() {
        return this.method;
    }

    public final Object[] getArguments() {
        return this.arguments;
    }

    public Object proceed() throws Throwable {
        Object interceptorOrInterceptionAdvice;
        if (this.currentInterceptorIndex == this.interceptorsAndDynamicMethodMatchers.size() - 1) {
            return this.invokeJoinpoint();
        }
        if ((interceptorOrInterceptionAdvice = this.interceptorsAndDynamicMethodMatchers.get(++this.currentInterceptorIndex)) instanceof InterceptorAndDynamicMethodMatcher) {
            InterceptorAndDynamicMethodMatcher dm = (InterceptorAndDynamicMethodMatcher)interceptorOrInterceptionAdvice;
            if (dm.methodMatcher.matches(this.method, this.targetClass, this.arguments)) {
                return dm.interceptor.invoke((MethodInvocation)this);
            }
            return this.proceed();
        }
        return ((MethodInterceptor)interceptorOrInterceptionAdvice).invoke((MethodInvocation)this);
    }

    protected Object invokeJoinpoint() throws Throwable {
        return AopProxyUtils.invokeJoinpointUsingReflection(this.target, this.method, this.arguments);
    }

    public MethodInvocation invocableClone() {
        try {
            ReflectiveMethodInvocation clone = (ReflectiveMethodInvocation)this.clone();
            if (this.arguments != null) {
                clone.arguments = new Object[this.arguments.length];
                System.arraycopy(this.arguments, 0, clone.arguments, 0, this.arguments.length);
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AspectException("Should be able to clone object of " + this.getClass(), (Throwable)ex);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Invocation: method=[");
        sb.append(this.method).append("] ").append("args=").append(this.arguments).append("] ");
        if (this.target == null) {
            sb.append("target is null");
        } else {
            sb.append("target is of class [").append(this.target.getClass().getName()).append(']');
        }
        return sb.toString();
    }
}

