/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import java.lang.reflect.Method;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.jta.JtaTransactionManager;

public class WebLogicJtaTransactionManager
extends JtaTransactionManager {
    public static final String DEFAULT_TRANSACTION_MANAGER_NAME = "javax.transaction.TransactionManager";
    private static final String TRANSACTION_MANAGER_CLASS_NAME = "weblogic.transaction.TransactionManager";
    private final Method forceResumeMethod;
    static /* synthetic */ Class class$javax$transaction$Transaction;

    public WebLogicJtaTransactionManager() throws TransactionSystemException {
        this.setTransactionManagerName(DEFAULT_TRANSACTION_MANAGER_NAME);
        try {
            Class<?> transactionManagerClass = this.getClass().getClassLoader().loadClass(TRANSACTION_MANAGER_CLASS_NAME);
            this.forceResumeMethod = transactionManagerClass.getMethod("forceResume", class$javax$transaction$Transaction == null ? (class$javax$transaction$Transaction = WebLogicJtaTransactionManager.class$("javax.transaction.Transaction")) : class$javax$transaction$Transaction);
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Couldn't initialize WebLogicJtaTransactionManager because WebLogic API classes are not available", ex);
        }
    }

    protected void doJtaResume(Transaction suspendedTransaction) throws SystemException {
        try {
            this.getTransactionManager().resume(suspendedTransaction);
        }
        catch (InvalidTransactionException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Standard JTA resume threw InvalidTransactionException: " + ex.getMessage() + " - trying WebLogic JTA forceResume"));
            }
            try {
                this.forceResumeMethod.invoke((Object)this.getTransactionManager(), suspendedTransaction);
            }
            catch (Exception ex2) {
                throw new TransactionSystemException("Could not invoke WebLogic's forceResume method", ex2);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

